<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'workshop', language 'te', version '4.3'.
 *
 * @package     workshop
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aggregategrades'] = 'గ్రేడ్లను తిరిగి లెక్కించండి';
$string['aggregation'] = 'గ్రేడ్లు అగ్రిగేషన్';
$string['allocate'] = 'సమర్పణలను కేటాయించండి';
$string['allocatedetails'] = 'ఊహించినది: {$a->expected}<br /> సమర్పించినది: {$a->submitted} <br /> కేటాయించవలసినది: {$a->allocate}';
$string['allocation'] = 'సమర్పణ కేటాయింపు';
$string['allocationconfigured'] = 'కేటాయింపు కాన్ఫిగర్ చేయబడింది';
$string['allocationdone'] = 'కేటాయింపు పూర్తయింది';
$string['allocationerror'] = 'కేటాయింపు లోపం';
$string['allowedfiletypesforoverallfeedback'] = 'చూడు అటాచ్మెంట్ ఫైల్ రకాలను అనుమతించింది';
$string['allowedfiletypesforoverallfeedback_help'] = 'అనుమతించే  ఫైల్ రకాల జాబితాను అందించడం ద్వారా వాడుకరులు సమర్పించే  అటాచ్మెంట్ ఫైల్ రకాలను నియంత్రించవచ్చు . ఫీల్డ్ ఖాళీగా ఉంటే, అప్పుడు అన్ని రకాల ఫైళ్ళు  అనుమతించబడతాయి.';
$string['allowedfiletypesforoverallfeedback_link'] = 'admin/tool/filetypes/index';
$string['allowedfiletypesforsubmission'] = 'అనుమతించబడే అటాచ్మెంట్ ఫైల్ రకాలు';
$string['allowedfiletypesforsubmission_help'] = 'అనుమతించే  ఫైల్ రకాల జాబితాను అందించడం ద్వారా అటాచ్మెంట్ ఫైల్ రకాలను నియంత్రించవచ్చు. ఫీల్డ్ ఖాళీగా ఉంటే, అప్పుడు అన్ని  రకాల ఫైళ్ళు  అనుమతించబడతాయి.';
$string['allowedfiletypesforsubmission_link'] = 'admin/tool/filetypes/index';
$string['allsubmissions'] = 'అన్ని సమర్పణలు ({$a})';
$string['alreadygraded'] = 'ఇప్పటికే వర్గీకరించబడింది';
$string['areaconclusion'] = 'తీర్మానం టెక్స్ట్';
$string['areainstructauthors'] = 'సమర్పణకు సూచనలు';
$string['areainstructreviewers'] = 'అంచనా కోసం సూచనలు';
$string['areaoverallfeedbackattachment'] = 'మొత్తం అభిప్రాయ జోడింపులను';
$string['areaoverallfeedbackcontent'] = 'మొత్తం అభిప్రాయ పాఠాలు';
$string['areasubmissionattachment'] = 'సమర్పణ జోడింపులు';
$string['areasubmissioncontent'] = 'సమర్పణ పాఠాలు';
$string['assess'] = 'అంచనా';
$string['assessedexample'] = 'ఉదాహరణ సమర్పణ';
$string['assessedsubmission'] = 'సమర్పించిన సమర్పణ';
$string['assessingexample'] = 'ఉదాహరణ సమర్పణను అంచనా వేయడం';
$string['assessingsubmission'] = 'సమర్పణను అంచనా వేయడం';
$string['assessment'] = 'అసెస్మెంట్';
$string['assessmentby'] = '<a href="{$a->url} "> {$a->name}</a> ద్వారా';
$string['assessmentbyfullname'] = '{$a} ద్వారా అంచనా';
$string['assessmentbyyourself'] = 'మీ అంచనా';
$string['assessmentdeleted'] = 'మీ అంచనా';
$string['assessmentend'] = 'అంచనా కోసం గడువు';
$string['assessmentendbeforestart'] = 'మదింపు తేదీకి తెరిచే ముందు అంచనా వేయడానికి గడువు ఇవ్వబడదు';
$string['assessmentenddatetime'] = 'అసెస్మెంట్ గడువు: {$a->daydatetime} ({$a->distanceday)}';
$string['assessmentendevent'] = 'అంచనా కోసం {$a} గడువు';
$string['assessmentform'] = 'అసెస్మెంట్ రూపం';
$string['assessmentofsubmission'] = '<a href="{$a->submissionurl}"> {$a->submissiontitle}</a> <a href="{$a-> assessmenturl}"> అంచనా </a>';
$string['assessmentreference'] = 'సూచన అంచనా';
$string['assessmentreferenceconflict'] = 'మీరు ఒక రిఫరెన్స్ అంచనాను అందించిన ఉదాహరణ సమర్పణను అంచనా వేయడం సాధ్యం కాదు.';
$string['assessmentreferenceneeded'] = 'సూచన సూచనను అందించడానికి మీరు ఈ ఉదాహరణ సమర్పణను అంచనా వేయాలి. సమర్పణను అంచనా వేయడానికి \'కొనసాగించు\' బటన్ క్లిక్ చేయండి.';
$string['assessments'] = 'లెక్కింపులు';
$string['assessmentsettings'] = 'అసెస్మెంట్ సెట్టింగులు';
$string['assessmentstart'] = 'నుండి అంచనా కోసం తెరవండి';
$string['assessmentstartdatetime'] = '{$a->daydatetime} ({$a->distanceday)} నుండి అంచనా కోసం తెరవండి';
$string['assessmentstartevent'] = '{$a} అంచనా కోసం తెరుస్తుంది';
$string['assessmentweight'] = 'అసెస్మెంట్ బరువు';
$string['assignedassessments'] = 'అంచనా వేయడానికి కేటాయించిన సమర్పణలు';
$string['assignedassessmentsnone'] = 'మీరు అంచనా వేయడానికి కేటాయించిన ఎటువంటి సమర్పణ లేదు';
$string['backtoeditform'] = 'ఫారమ్ను సవరించడానికి తిరిగి వెళ్ళు';
$string['byfullname'] = '<a href="{$a->url}"> {$a->name} </a> ద్వారా';
$string['byfullnamewithoutlink'] = '{$a} ద్వారా';
$string['calculategradinggrades'] = 'అంచనా తరగతులు లెక్కించు';
$string['calculategradinggradesdetails'] = 'ఊహించినది: {$a->expected}<br /> లెక్కిస్తారు: {$a->calculated}';
$string['calculatesubmissiongrades'] = 'సమర్పణ తరగతులు లెక్కించు';
$string['calculatesubmissiongradesdetails'] = 'ఊహించినది: {$a->expected}<br /> లెక్కిస్తారు: {$a->calculated}';
$string['chooseuser'] = 'వినియోగదారుని ఎంచుకోండి ...';
$string['clearaggregatedgrades'] = 'మొత్తం సమగ్ర తరగతులు క్లియర్ చేయండి';
$string['clearaggregatedgrades_help'] = 'అంచనా కోసం సమర్పణ మరియు గ్రేడుల కోసం గ్రేడ్స్ గ్రేడింగ్ రీసెట్ చేయబడుతుంది. మీరు తిరిగి గ్రేడింగ్ మూల్యాంకన దశలో గీతలుగా ఈ తరగతులు తిరిగి లెక్కించవచ్చు.';
$string['clearaggregatedgradesconfirm'] = 'మీరు అంచనా కోసం సమర్పణలు మరియు గ్రేడుల కోసం లెక్కించిన తరగతులు క్లియర్ చేయాలనుకుంటున్నారా?';
$string['clearassessments'] = 'స్పష్టమైన లెక్కింపులు';
$string['clearassessments_help'] = 'అంచనా కోసం సమర్పణ తరగతులు మరియు అంచనాలకు రీసెట్ చేయబడతాయి. అంచనా రూపాలు నిండి ఎలా సమాచారం ఇప్పటికీ ఉంచబడుతుంది, కానీ అన్ని సమీక్షకులు మళ్ళీ అంచనా రూపం తెరిచి తిరిగి ఇచ్చిన తరగతులు లెక్కించడానికి ఇది తిరిగి సేవ్ ఉండాలి.';
$string['clearassessmentsconfirm'] = 'మీరు అన్ని అంచనా తరగతులు క్లియర్ చేయాలనుకుంటున్నారా? మీరు మీ స్వంత సమాచారాన్ని తిరిగి పొందలేరు, సమీక్షకులు కేటాయించిన సమర్పణలను తిరిగి అంచనా వేయవలసి ఉంటుంది.';
$string['conclusion'] = 'ముగింపు';
$string['conclusion_help'] = 'సూచించే ముగింపులో పాల్గొనేవారికి ముగింపు టెక్స్ట్ ప్రదర్శించబడుతుంది.';
$string['configexamplesmode'] = 'వర్క్షాప్ల్లో ఉదాహరణలు అంచనా యొక్క డిఫాల్ట్ మోడ్';
$string['configgrade'] = 'వర్క్షాప్ల్లో సమర్పణ కోసం డిఫాల్ట్ గరిష్ట గ్రేడ్';
$string['configgradedecimals'] = 'అంకెలు ప్రదర్శించేటప్పుడు దశాంశ బిందువు తర్వాత చూపించవలసిన అంకెల యొక్క డిఫాల్ట్ సంఖ్య.';
$string['configgradinggrade'] = 'వర్క్షాప్ల్లో అంచనా కోసం డిఫాల్ట్ గరిష్ట గ్రేడ్';
$string['configmaxbytes'] = 'సైట్లోని అన్ని కార్ఖానాలకు డిఫాల్ట్ గరిష్ట సమర్పణ ఫైల్ పరిమాణం (కోర్సు పరిమితులు మరియు ఇతర స్థానిక సెట్టింగులు)';
$string['configstrategy'] = 'కార్ఖానాలు కోసం డిఫాల్ట్ గ్రేడింగ్ వ్యూహం';
$string['createsubmission'] = 'మీ సమర్పణను సిద్ధం చేయడాన్ని ప్రారంభించండి';
$string['daysago'] = '{$a} రోజుల క్రితం';
$string['daysleft'] = '{$a} రోజులు మిగిలి ఉన్నాయి';
$string['daystoday'] = 'నేడు';
$string['daystomorrow'] = 'రేపు';
$string['daysyesterday'] = 'నిన్న';
$string['deadlinesignored'] = 'సమయం పరిమితులు మీకు వర్తించవు';
$string['deletesubmission'] = 'సమర్పణను తొలగించండి';
$string['editassessmentform'] = 'అంచనా రూపం సవరించండి';
$string['editassessmentformstrategy'] = 'అంచనా రూపాన్ని సవరించండి ({$a})';
$string['editingassessmentform'] = 'ఎడిటింగ్ అంచనా రూపం';
$string['editingsubmission'] = 'సమర్పణను సవరించడం';
$string['editsubmission'] = 'సమర్పణను సవరించండి';
$string['err_multiplesubmissions'] = 'ఈ ఫారమ్ను సవరిస్తున్నప్పుడు, సమర్పణ యొక్క మరొక వెర్షన్ సేవ్ చేయబడింది. వినియోగదారుకు బహుళ సమర్పణలు అనుమతించబడవు.';
$string['err_removegrademappings'] = 'ఉపయోగించని గ్రేడ్ మ్యాపింగ్లను తొలగించడం సాధ్యం కాదు';
$string['evaluategradeswait'] = 'మదింపులను మూల్యాంకనం చేసే వరకు వేచి ఉండండి మరియు గ్రేడ్ లెక్కిస్తారు';
$string['evaluation'] = 'గ్రేడింగ్ మూల్యాంకనం';
$string['evaluationmethod'] = 'గ్రేడింగ్ మూల్యాంకన పద్ధతి';
$string['evaluationmethod_help'] = 'గ్రేడింగ్ మూల్యాంకన పద్ధతి అంచనా వేయడానికి ఎలా గ్రేడ్ నిర్ణయించబడుతుంది. మీరు ఫలితంతో సంతోషంగా ఉన్నట్లయితే వేర్వేరు సెట్టింగ్లతో పదేపదే గణనలను మళ్ళీ లెక్కించగలుగుతారు.';
$string['evaluationsettings'] = 'గ్రేడింగ్ మూల్యాంకనం సెట్టింగులు';
$string['eventassessableuploaded'] = 'సమర్పణ అప్లోడ్ చేయబడింది.';
$string['eventassessmentevaluated'] = 'అంచనా వేయబడింది';
$string['eventassessmentevaluationsreset'] = 'అసెస్మెంట్ అంచనాలు రీసెట్';
$string['eventassessmentreevaluated'] = 'అసెస్మెంట్ తిరిగి అంచనా వేయబడింది';
$string['eventphaseswitched'] = 'దశ స్విచ్ చేయబడింది';
$string['eventsubmissionassessed'] = 'సమర్పణ అంచనా';
$string['eventsubmissionassessmentsreset'] = 'సబ్మిషన్ అసెస్మెంట్స్ క్లియర్';
$string['eventsubmissioncreated'] = 'సమర్పణ సృష్టించబడింది';
$string['eventsubmissiondeleted'] = 'సమర్పణ తొలగించబడింది';
$string['eventsubmissionreassessed'] = 'సబ్మిషన్ తిరిగి అంచనా వేయబడింది';
$string['eventsubmissionupdated'] = 'సమర్పణ నవీకరించబడింది';
$string['eventsubmissionviewed'] = 'సమర్పణ వీక్షించబడింది';
$string['example'] = 'ఉదాహరణ సమర్పణ';
$string['exampleadd'] = 'ఉదాహరణకు సమర్పణను జోడించండి';
$string['exampleassess'] = 'ఉదాహరణ సమర్పణను అంచనా వేయండి';
$string['exampleassessments'] = 'ఉదాహరణ సమర్పణలు అంచనా వేయడానికి';
$string['exampleassesstask'] = 'ఉదాహరణలను అంచనా వేయండి';
$string['exampleassesstaskdetails'] = 'ఊహించినది: {$a->expected} <br /> అంచనా వేయబడింది: {$a->assesed}';
$string['examplecomparing'] = 'ఉదాహరణ సమర్పణ (సబ్మిషన్) అసెస్మెంట్లను పోల్చబడుతోంది';
$string['exampledelete'] = 'ఉదాహరణ తొలగించు';
$string['exampledeleteconfirm'] = 'మీరు ఈ క్రింది ఉదాహరణ సమర్పణను తొలగించాలనుకుంటున్నారా? సమర్పణను తొలగించడానికి \'కొనసాగించు\' బటన్ క్లిక్ చేయండి.';
$string['exampleedit'] = 'ఉదాహరణను సవరించండి';
$string['exampleediting'] = 'ఎడిటింగ్ ఉదాహరణ';
$string['exampleneedassessed'] = 'మీరు మొదట అన్ని ఉదాహరణ సమర్పణలను అంచనా వేయాలి';
$string['exampleneedsubmission'] = 'మీరు మీ పనిని సమర్పించి, మొదట అన్ని ఉదాహరణ సమర్పణలను అంచనా వేయాలి';
$string['examplesbeforeassessment'] = 'సొంత సమర్పణ తరువాత ఉదాహరణలు అందుబాటులో ఉన్నాయి మరియు పీర్ అంచనాకు ముందుగా అంచనా వేయాలి';
$string['examplesbeforesubmission'] = 'సొంత సమర్పణకు ముందు ఉదాహరణలను అంచనా వేయాలి';
$string['examplesmode'] = 'ఉదాహరణలు అంచనా మోడ్';
$string['examplesubmissions'] = 'ఉదాహరణ సమర్పణలు';
$string['examplesvoluntary'] = 'ఉదాహరణకు సమర్పణ యొక్క అంచనా స్వచ్ఛందంగా ఉంటుంది';
$string['exportsubmission'] = 'ఈ పేజీని ఎగుమతి చేయండి';
$string['feedbackauthor'] = 'రచయిత కోసం అభిప్రాయం';
$string['feedbackauthorattachment'] = 'జోడింపు';
$string['feedbackby'] = '{$a}';
$string['feedbackreviewer'] = 'సమీక్షకుడికి అభిప్రాయం';
$string['feedbacksettings'] = 'అభిప్రాయం';
$string['formataggregatedgrade'] = 'అభిప్రాయం';
$string['formataggregatedgradeover'] = '<del>{$a->grade}</del><br /><ins>{$a->over}</ins>';
$string['formatpeergrade'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">({$a->gradinggrade})</span>';
$string['formatpeergradeover'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">(<del>{$a->gradinggrade}</del> / <ins>{$a->gradinggradeover}</ins>)</span>';
$string['formatpeergradeoverweighted'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">(<del>{$a->gradinggrade}</del> / <ins>{$a->gradinggradeover}</ins>)</span>';
$string['formatpeergradeweighted'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">(<del>{$a->gradinggrade}</del> / <ins>{$a->gradinggradeover}</ins>)</span>';
$string['givengrades'] = 'ఇచ్చిన గ్రేడులు';
$string['gradecalculated'] = 'సమర్పణ కోసం గణించిన గ్రేడ్';
$string['gradedecimals'] = 'గ్రేడుల్లో డెసిమల్ స్థానాలు';
$string['gradegivento'] = '&gt;';
$string['gradeinfo'] = 'గ్రేడ్: {$a->received} {$a->max}';
$string['gradeitemassessment'] = '{$a->workshopname} (అంచనా)';
$string['gradeitemsubmission'] = '{$a->workshopname} (సమర్పణ)';
$string['gradeover'] = 'సమర్పణ కోసం ఓవర్రైడ్ గ్రేడ్';
$string['gradereceivedfrom'] = '&lt;';
$string['gradesreport'] = 'వర్క్షాప్ గ్రేడుల నివేదిక';
$string['gradetopassgrading'] = 'ఉత్తీర్ణులవడానికి కావల్సిన అసెస్మెంట్ గ్రేడు';
$string['gradetopasssubmission'] = 'ఉత్తీర్ణులవడానికి కావల్సిన సబ్మిషన్  గ్రేడు';
$string['gradinggrade'] = 'అంచనా కోసం గ్రేడ్';
$string['gradinggrade_help'] = 'ఈ సెట్టింగ్ సమర్పణ అంచనా కోసం పొందిన గరిష్ట గ్రేడ్ నిర్దేశిస్తుంది.';
$string['gradinggradecalculated'] = 'అంచనా కోసం అంచనా గ్రేడ్';
$string['gradinggradeof'] = 'అంచనా కోసం గ్రేడ్ ({$a})';
$string['gradinggradeover'] = 'అంచనా కోసం ఓవర్రైడ్ గ్రేడ్';
$string['gradingsettings'] = 'గ్రేడింగ్ సెట్టింగ్లు';
$string['groupnoallowed'] = 'ఈ వర్క్షాప్లో ఏదైనా సమూహాన్ని ప్రాప్యత చేయడానికి మీకు అనుమతి లేదు';
$string['iamsure'] = 'అవును, నేను ఖచ్చితంగా ఉన్నాను';
$string['indicator:cognitivedepth'] = 'వర్క్షాప్ అభిజ్ఞా';
$string['indicator:cognitivedepth_help'] = 'ఈ సూచీ ఒక వర్క్షాప్ కార్యక్రమంలో విద్యార్థి చేరుకున్న అభిజ్ఞాత్మక లోతు ఆధారంగా ఉంది.';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'వర్క్షాప్ సామాజిక';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['info'] = 'సమాచారం';
$string['instructauthors'] = 'సమర్పణకు సూచనలు';
$string['instructreviewers'] = 'అంచనా కోసం సూచనలు';
$string['introduction'] = 'వివరణ';
$string['latesubmissions'] = 'ఆలస్యంగా వచ్చిన  సమర్పణలు';
$string['latesubmissions_desc'] = 'గడువు తర్వాత సమర్పణలను అనుమతించండి';
$string['latesubmissions_help'] = 'ప్రారంభించబడితే, ఒక రచయిత వారి సమర్పణ గడువు తర్వాత లేదా అంచనా దశలో వారి పనిని సమర్పించవచ్చు. లేట్ సమర్పణలు అయితే సవరించబడవు.';
$string['latesubmissionsallowed'] = 'లేట్ సమర్పణలు అనుమతించబడతాయి';
$string['maxbytes'] = 'గరిష్ట సమర్పణ అటాచ్మెంట్ పరిమాణం';
$string['modulename'] = 'వర్క్షాప్';
$string['modulename_help'] = 'వర్క్షాప్ సూచించే మాడ్యూల్ సేకరణ, సమీక్ష మరియు విద్యార్థుల పనితీరును అంచనా వేయడానికి అనుమతిస్తుంది.

విద్యార్ధులు ఏవైనా డిజిటల్ కంటెంట్ (ఫైల్స్) ను వర్డ్ ప్రాసెస్డ్ డాక్యుమెంట్స్ లేదా స్ప్రెడ్ షీట్ట్స్ వంటివాటిని సమర్పించవచ్చు మరియు టెక్స్టు ఎడిటర్ని ఉపయోగించి నేరుగా టెక్స్ట్ను టైప్ చేయవచ్చు.

గురువుచే నిర్వచించబడిన బహుళ ప్రమాణ కొలత పద్ధతిని ఉపయోగించి సమర్పణలు అంచనా వేయబడతాయి. పీర్ అంచనా మరియు అవగాహన అవగాహన ప్రక్రియ ముందుగానే ఉపాధ్యాయుడికి అందించిన ఉదాహరణ సమర్పణలతో సాధన చేయవచ్చు, దానితో పాటు సూచన అంచనా ఉంటుంది. విద్యార్ధులు వారి సహచరుల సమర్పణలలో ఒకటి లేదా అంతకంటే ఎక్కువ అంచనా వేయడానికి అవకాశం ఇవ్వబడుతుంది. అవసరమైతే సమర్పణలు మరియు సమీక్షకులు అజ్ఞాతంగా ఉండవచ్చు.

విద్యార్ధులు ఒక వర్క్షాప్ కార్యక్రమంలో రెండు తరగతులను పొందుతారు - వారి సమర్పణకు ఒక గ్రేడ్ మరియు వారి తోటివారి సమర్పణల అంచనా కోసం ఒక గ్రేడ్. రెండు తరగతులను గ్రేడ్బుక్లో నమోదు చేస్తారు.';
$string['modulename_link'] = 'mod/workshop/view';
$string['modulenameplural'] = 'వర్క్';
$string['myassessments'] = 'నా లెక్కింపులు';
$string['mysubmission'] = 'నా సమర్పణ';
$string['nattachments'] = 'సమర్పణ జోడింపుల గరిష్ట సంఖ్య';
$string['noexamples'] = 'ఈ వర్క్షాప్లో ఇంకా ఉదాహరణలు ఏవీ లేవు';
$string['noexamplesformready'] = 'మీరు ఉదాహరణకు సమర్పణలను అందించే ముందు అంచనా రూపాన్ని నిర్వచించాలి';
$string['nogradeyet'] = 'ఇంకా గ్రేడ్ లేదు';
$string['nosubmissionfound'] = 'ఈ యూజర్ కోసం సమర్పణ ఏదీ కనుగొనబడలేదు';
$string['nosubmissions'] = 'ఈ వర్క్ షాప్లో ఇంకా సమర్పణలు లేవు';
$string['notassessed'] = 'ఇంకా అంచనా వేయలేదు';
$string['nothingfound'] = 'ప్రదర్శించడానికి ఏమీ లేదు';
$string['nothingtoreview'] = 'సమీక్షించడానికి ఏమీ లేదు';
$string['notoverridden'] = 'విస్మరించలేదు';
$string['noyoursubmission'] = 'మీరు ఇంకా మీ పనిని సమర్పించలేదు';
$string['nullgrade'] = '-';
$string['overallfeedback'] = 'మొత్తం అభిప్రాయం';
$string['overallfeedbackfiles'] = 'మొత్తం చూడు జోడింపుల గరిష్ట సంఖ్య';
$string['overallfeedbackmaxbytes'] = 'గరిష్ట మొత్తం అభిప్రాయ జోడింపు పరిమాణం';
$string['overallfeedbackmode'] = 'మొత్తం అభిప్రాయ మోడ్';
$string['overallfeedbackmode_0'] = 'డిసేబుల్ చేయబడింది';
$string['overallfeedbackmode_1'] = 'ప్రారంభించబడింది మరియు ఐచ్ఛికం';
$string['overallfeedbackmode_2'] = 'ప్రారంభించబడింది మరియు అవసరం';
$string['overallfeedbackmode_help'] = 'ప్రారంభించబడితే, అంచనా ఫారమ్ దిగువన ఒక టెక్స్ట్ ఫీల్డ్ ప్రదర్శించబడుతుంది. సమీక్షకులు అక్కడ సమర్పణ మొత్తం అంచనా ఉంచవచ్చు, లేదా వారి అంచనా అదనపు వివరణ అందిస్తుంది.';
$string['page-mod-workshop-x'] = 'ఏ వర్క్షాప్ మాడ్యూల్ పేజీ';
$string['participant'] = 'పార్టిసిపెంట్';
$string['participantrevierof'] = 'పాల్గొనేవారు విమర్శకుడు';
$string['participantreviewedby'] = 'పాల్గొనేవారు సమీక్షించారు';
$string['phaseassessment'] = 'అసెస్మెంట్ దశ';
$string['phaseclosed'] = 'ముగించబడినది';
$string['phaseevaluation'] = 'గ్రేడింగ్ మూల్యాంకన దశ';
$string['phasesetup'] = 'దశను సెటప్ చేయండి';
$string['phasesoverlap'] = 'సమర్పణ దశ మరియు అంచనా దశలు పోలిక లేదు';
$string['phasesubmission'] = 'సమర్పణ దశ';
$string['pluginadministration'] = 'వర్క్ షాప్ పరిపాలన';
$string['pluginname'] = 'వర్క్ షాప్';
$string['prepareexamples'] = 'ఉదాహరణ సమర్పణలను సిద్ధం చేయండి';
$string['previewassessmentform'] = 'ప్రివ్యూ';
$string['privacy:metadata:aggregatedgradinggrade'] = 'ఇచ్చిన వర్క్ షాప్ కార్యక్రమంలో వినియోగదారు చేసిన అన్ని అసెస్మెంట్ల కోసం సమగ్ర గ్రేడ్';
$string['privacy:metadata:assessmentgrade'] = 'ఈ అంచనాచే సమర్పించబడిన సమర్పణకు సమగ్ర గ్రేడ్';
$string['privacy:metadata:assessmentgradinggrade'] = 'ఈ అంచనా కోసం గ్రేడ్';
$string['privacy:metadata:assessmentgradinggradeover'] = 'ఈ అంచనాను అందించడానికి గ్రేడ్ యొక్క మాన్యువల్గా అతిక్రమించిన విలువ';
$string['privacy:metadata:assessmentid'] = 'అంచనా యొక్క ఐడెంటిఫైయర్';
$string['privacy:metadata:authorid'] = 'సమర్పణ రచయిత యొక్క ఐడెంటిఫైయర్';
$string['privacy:metadata:dimensiongrade'] = 'ఇవ్వబడిన అంచనా కొలతలో గ్రేడ్';
$string['privacy:metadata:dimensionid'] = 'అంచనా కొలత యొక్క ఐడెంటిఫైయర్';
$string['privacy:metadata:example'] = 'ఈ రికార్డ్ ఉదాహరణ సమర్పణకు ప్రాతినిధ్యం వహిందా?';
$string['privacy:metadata:feedbackauthor'] = 'రచయిత కోసం అభిప్రాయం';
$string['privacy:metadata:feedbackauthorformat'] = 'రచయిత యొక్క అభిప్రాయాల యొక్క టెక్స్ట్ ఫార్మాట్';
$string['privacy:metadata:feedbackreviewer'] = 'వినియోగదారుని అభిప్రాయం అందించే అభిప్రాయం';
$string['privacy:metadata:feedbackreviewerformat'] = 'వినియోగదారుకు అభిప్రాయాన్ని అందించే టెక్స్ట్ ఫార్మాట్ అంచనాను అందిస్తుంది';
$string['privacy:metadata:late'] = 'గడువు ముగిసిన తర్వాత సమర్పణ సమర్పించాలా వద్దా';
$string['privacy:metadata:peercomment'] = 'అంచనా ఇచ్చే యూజర్ ఇచ్చిన గ్రేడ్ మీద వ్యాఖ్యానించండి';
$string['privacy:metadata:peercommentformat'] = 'ఇచ్చిన గ్రేడ్పై వ్యాఖ్య యొక్క టెక్స్ట్ ఫార్మాట్';
$string['privacy:metadata:preference:perpage'] = 'సమర్పణల సంఖ్య వినియోగదారు ఒక పేజీలో చూడటానికి ఇష్టపడుతుంది';
$string['privacy:metadata:published'] = 'వర్క్ షాప్ మూసివేయబడిన తర్వాత సమర్పణదారులందరికీ సమర్పించాలా వద్దా';
$string['privacy:metadata:reviewerid'] = 'వినియోగదారుని యొక్క గుర్తింపును అంచనా వేయడం';
$string['privacy:metadata:strategy'] = 'రికార్డింగ్ విలువలను వివరించే శ్రేణీకరణ వ్యూహం సబ్ ప్లగిన్ పేరు';
$string['privacy:metadata:submissioncontent'] = 'సమర్పణ యొక్క కంటెంట్';
$string['privacy:metadata:submissioncontentformat'] = 'సమర్పణ కంటెంట్ యొక్క టెక్స్ట్ ఫార్మాట్';
$string['privacy:metadata:submissiongrade'] = 'విరామం నుండి దశాంశ సంఖ్య రాసిన సమర్పణ కోసం సమగ్ర గ్రేడ్ 0.100';
$string['privacy:metadata:submissiongradeover'] = 'సమగ్ర గ్రేడ్ యొక్క మాన్యువల్గా ఓవర్రైడ్ విలువ';
$string['privacy:metadata:submissionid'] = 'సమర్పణ యొక్క ఐడెంటిఫైయర్';
$string['privacy:metadata:submissiontitle'] = 'సమర్పణ శీర్షిక';
$string['privacy:metadata:subsystem:corefiles'] = 'వర్క్ షాప్ మాడ్యూల్ దుకాణాలు ఫైళ్లు / లో సమర్పించిన టెక్స్ట్ జత';
$string['privacy:metadata:subsystem:coreplagiarism'] = 'వర్క్ షాప్ మాడ్యూల్ plagiarism నివారణ వ్యవస్థలకు భాగంగా నిర్మిచబడిన మద్దతును కలిగి ఉంది';
$string['privacy:metadata:timeaggregated'] = 'సమగ్ర గ్రేడ్ గత లెక్కించినప్పుడు';
$string['privacy:metadata:timecreated'] = 'ఈ రికార్డ్ డేటాబేస్లో సృష్టించబడినప్పుడు';
$string['privacy:metadata:timemodified'] = 'ఈ రికార్డు గత డేటాబేస్లో సవరించబడినప్పుడు';
$string['privacy:metadata:userid'] = 'సంకలిత గ్రేడ్ లెక్కించిన యూజర్ యొక్క ఐడెంటిఫైయర్';
$string['privacy:metadata:weight'] = 'అంచనా యొక్క బరువు';
$string['privacy:metadata:workshopaggregations'] = 'అంచనా కోసం సమగ్ర తరగతులు కలిగి ఉంటుంది';
$string['privacy:metadata:workshopassessments'] = 'వర్క్ షాప్ మాడ్యూల్ సమర్పణల కేటాయింపుల గురించి సమాచారాన్ని కలిగి ఉంటుంది';
$string['privacy:metadata:workshopgrades'] = 'అంచనా రూపాలు తరగతులు మరియు వ్యాఖ్యానాలతో ఎలా నిండివున్నాయనే దాని గురించి సమాచారాన్ని కలిగి ఉంటుంది';
$string['privacy:metadata:workshopid'] = 'వర్క్ షాప్ సూచించే ఐడెంటిఫైయర్';
$string['privacy:metadata:workshopsubmissions'] = 'వర్క్ షాప్ మాడ్యూల్ సమర్పణల గురించి సమాచారాన్ని కలిగి ఉంటుంది';
$string['privacy:request:delete:content'] = 'వినియోగదారు అభ్యర్థన మేరకు కంటెంట్ తొలగించబడింది.';
$string['privacy:request:delete:title'] = '[తొలగించబడిన]';
$string['publishedsubmissions'] = 'ప్రచురణ సమర్పణలు';
$string['publishsubmission'] = 'సమర్పణను ప్రచురించండి';
$string['publishsubmission_help'] = 'వర్క్ షాప్ మూసివేయబడినప్పుడు ప్రచురించిన సమర్పణలు ఇతరులకు అందుబాటులో ఉంటాయి.';
$string['reassess'] = 'తిరిగి అంచనా';
$string['receivedgrades'] = 'స్వీకరించిన తరగతులు';
$string['recentassessments'] = 'వర్క్షాప్ లెక్కింపులు:';
$string['recentsubmissions'] = 'వర్క్షాప్ సమర్పణలు:';
$string['resetassessments'] = 'అన్ని అసెస్మెంట్లను తొలగించండి';
$string['resetassessments_help'] = 'మీరు సమర్పణలను ప్రభావితం చేయకుండా కేటాయించిన లెక్కలను తొలగించడాన్ని ఎంచుకోవచ్చు. సమర్పణలు తొలగించబడితే, వారి మదింపులు పరిపూర్ణంగా తొలగించబడతాయి మరియు ఈ ఐచ్చికం విస్మరించబడుతుంది. ఇది ఉదాహరణ సమర్పణల యొక్క మదింపులను కూడా కలిగి ఉంటుంది.';
$string['resetphase'] = 'సెటప్ దశకు మారండి';
$string['resetphase_help'] = 'ప్రారంభించబడితే, అన్ని వర్క్ షాప్ ప్రారంభ సెటప్ దశలో ఉంచబడతాయి.';
$string['resetsubmissions'] = 'అన్ని సమర్పణలను తొలగించండి';
$string['resetsubmissions_help'] = 'అన్ని సమర్పణలు మరియు వారి లెక్కింపులు తొలగించబడతాయి. ఇది ఉదాహరణ సమర్పణలను ప్రభావితం చేయదు.';
$string['saveandclose'] = 'సేవ్ చేసి మూసివేయి';
$string['saveandcontinue'] = 'సేవ్ చేసి సవరణను కొనసాగించండి';
$string['saveandpreview'] = 'సేవ్ చేసి పరిదృశ్యం చేయండి';
$string['saveandshownext'] = 'సేవ్ చేసి తదుపరి చూపు';
$string['search:activity'] = 'వర్క్ షాప్ - సూచించే సమాచారం';
$string['selfassessmentdisabled'] = 'స్వీయ అంచనా డిసేబుల్';
$string['showingperpage'] = 'పేజీకి {$a} అంశాలను చూపుతోంది';
$string['showingperpagechange'] = 'మార్చు ...';
$string['someuserswosubmission'] = 'వారి పని ఇంకా సమర్పించని ఒక రచయిత కూడా ఉంది';
$string['sortasc'] = 'ఆరోహణ విధమైన';
$string['sortdesc'] = 'అవరోహణ విధమైనది';
$string['strategy'] = 'గ్రేడింగ్ వ్యూహం';
$string['strategy_help'] = 'గ్రేడింగ్ వ్యూహం ఉపయోగించిన అంచనా రూపం మరియు గ్రేడింగ్ సమర్పణల పద్ధతిని నిర్ణయిస్తుంది. 4 ఎంపికలు ఉన్నాయి:

* సంచిత గ్రేడింగ్ - వ్యాఖ్యలు మరియు ఒక గ్రేడ్ పేర్కొన్న అంశాలను గురించి ఇవ్వబడ్డాయి
* వ్యాఖ్యలు - పేర్కొన్న అంశాలకు సంబంధించి వ్యాఖ్యలు ఇవ్వబడ్డాయి, కానీ గ్రేడ్ ఇవ్వబడలేదు
* లోపాల సంఖ్య - వ్యాఖ్యలు మరియు పేర్కొన్న ప్రకటనలకు సంబంధించి yes / no అంచనా ఇవ్వబడ్డాయి
* రబ్బర్ - పేర్కొన్న ప్రమాణం గురించి ఒక స్థాయి అంచనా ఇవ్వబడుతుంది';
$string['strategyhaschanged'] = 'సవరణ కోసం రూపం తెరిచినప్పటి నుండి వర్క్ షాప్ గ్రేడింగ్ వ్యూహం మార్చబడింది.';
$string['submission'] = 'సమర్పణ';
$string['submissionattachment'] = 'జోడింపు';
$string['submissionby'] = '{$a} ద్వారా సమర్పించడం';
$string['submissioncontent'] = 'సమర్పణ కంటెంట్';
$string['submissiondeleteconfirm'] = 'మీరు ఖచ్చితంగా క్రింది సమర్పణను తొలగించాలనుకుంటున్నారా?';
$string['submissiondeleteconfirmassess'] = 'మీరు ఖచ్చితంగా క్రింది సమర్పణను తొలగించాలనుకుంటున్నారా? ఈ సమర్పణతో అనుబంధించబడిన {$a->count} లెక్కింపులను కూడా తొలగించవచ్చని గమనించండి, ఇది సమీక్షకుల తరగతులుపై ప్రభావం చూపుతుంది.';
$string['submissionend'] = 'సమర్పణ గడువు';
$string['submissionendbeforestart'] = 'సమర్పణల తేదీకి తెరిచే ముందు సమర్పణ గడువు పేర్కొనబడదు';
$string['submissionenddatetime'] = 'సమర్పణ గడువు: {$a->daydatetime} ({$a->distanceday)}';
$string['submissionendevent'] = 'సమర్పణల కోసం {$a} గడువు';
$string['submissionendswitch'] = 'సమర్పణ గడువు తర్వాత తదుపరి దశకు మారండి';
$string['submissionendswitch_help'] = 'సమర్పణలు గడువు పేర్కొనబడితే మరియు ఈ పెట్టె తనిఖీ చేయబడితే, వర్క్ షాప్ స్వయంచాలకంగా సమర్పణ గడువు తర్వాత అంచనా దశకు మారుతుంది.

మీరు ఈ లక్షణాన్ని ప్రారంభిస్తే, షెడ్యూల్ కేటాయింపు పద్ధతిని సెటప్ చేయడానికి ఇది సిఫార్సు చేయబడింది. సమర్పణలు కేటాయించబడక పోతే, వర్క్ షాప్ కూడా అంచనా దశలో ఉన్నప్పటికీ, అంచనా వేయలేము.';
$string['submissiongrade'] = 'సమర్పణ కోసం గ్రేడ్';
$string['submissiongrade_help'] = 'ఈ సెట్టింగు సమర్పించిన పని కోసం గరిష్ట గ్రేడ్ను పొందవచ్చు.';
$string['submissiongradeof'] = 'సమర్పణ కోసం గ్రేడ్ ({$a})';
$string['submissionlastmodified'] = 'చివరిసారిగా మార్పు చేయబడిన';
$string['submissionrequiredcontent'] = 'మీరు కొంత వచనాన్ని ఎంటర్ చెయ్యాలి లేదా ఫైల్ను జోడించాలి.';
$string['submissionrequiredfile'] = 'మీరు ఫైల్ను జోడించాలి లేదా కొంత వచనాన్ని నమోదు చేయాలి.';
$string['submissionsettings'] = 'సమర్పణ సెట్టింగులు';
$string['submissionsreport'] = 'వర్క్ షాప్ సమర్పణ నివేదిక';
$string['submissionstart'] = 'సమర్పణల కోసం తెరవండి';
$string['submissionstartdatetime'] = '{$a->daydatetime} ({$a->distanceday)} నుండి సమర్పణల కోసం తెరవండి';
$string['submissionstartevent'] = 'సమర్పణల కోసం {$a} తెరుచుకుంటుంది';
$string['submissiontitle'] = 'శీర్షిక';
$string['submittednotsubmitted'] = 'సమర్పించిన ({$a->submitted}) / సమర్పించబడలేదు ({$a->notsubmitted})';
$string['subplugintype_workshopallocation'] = 'సమర్పణ కేటాయింపు పద్ధతి';
$string['subplugintype_workshopallocation_plural'] = 'సమర్పణ కేటాయింపు పద్ధతులు';
$string['subplugintype_workshopeval'] = 'గ్రేడింగ్ మూల్యాంకన పద్ధతి';
$string['subplugintype_workshopeval_plural'] = 'గ్రేడింగ్ మూల్యాంకన పద్ధతులు';
$string['subplugintype_workshopform'] = 'గ్రేడింగ్ వ్యూహం';
$string['subplugintype_workshopform_plural'] = 'గ్రేడింగ్ వ్యూహాలు';
$string['switchingphase'] = 'దశ మారడం';
$string['switchphase'] = 'దశ మారండి';
$string['switchphase10'] = 'సెటప్ దశకు మారండి';
$string['switchphase10info'] = 'మీరు <strong>సెటప్ దశ </strong> లోకి వర్క్ షాప్ని మార్చబోతున్నారు. ఈ దశలో, వినియోగదారులు తమ సమర్పణలను లేదా వారి అంచనాలను సవరించలేరు. ఉపాధ్యాయులు ఈ దశను వర్క్ షాప్ సెట్టింగులను మార్చవచ్చు, గ్రేడింగ్ స్ట్రాటజీని సవరించవచ్చు లేదా సర్దుబాటు అంచనా రూపాలను సవరించవచ్చు.';
$string['switchphase20'] = 'సమర్పణ దశకు మారండి';
$string['switchphase20info'] = 'మీరు వర్క్ షాప్ని <strong>సబ్మిషన్ ఫేజ్</strong> కు మారబోతున్నారు. ఈ దశలో విద్యార్ధులు తమ పనిని సమర్పించవచ్చు (సబ్మిషన్ యాక్సెస్ కంట్రోల్ తేదీలలో, సెట్ చేస్తే). ఉపాధ్యాయులు తోటి వారి సమీక్ష కోసం సమర్పణలను కేటాయించవచ్చు.';
$string['switchphase30'] = 'అంచనా దశకు మారండి';
$string['switchphase30auto'] = 'వర్క్ షాప్ స్వయంచాలకంగా అంచనా దశలోకి మారుతుంది {$a->daydatetime} ({$a->distanceday)}';
$string['switchphase30info'] = 'మీరు <strong>అసెస్మెంట్ ఫేజ్</strong> లో వర్క్ షాప్ని మార్చడానికి ప్రయత్నిస్తున్నారు. ఈ దశలో, సమీక్షకులు వారు కేటాయించిన సమర్పణలను అంచనా వేయవచ్చు (అంచనా యాక్సెస్ నియంత్రణ తేదీలలో, సెట్ చేస్తే).';
$string['switchphase40'] = 'మూల్యాంకన దశకు మారండి';
$string['switchphase40info'] = 'మీరు వర్క్ షాప్ని <strong>Grading Evaluation Phase</strong> లోకి మార్చబోతున్నారు. ఈ దశలో, వినియోగదారులు తమ సమర్పణలను లేదా వారి అంచనాలను సవరించలేరు. ఉపాధ్యాయులు తుది తరగతులు లెక్కించేందుకు మరియు సమీక్షకుల కోసం అభిప్రాయాన్ని అందించడానికి గ్రేడింగ్ మూల్యాంకనం సాధనాలను ఉపయోగించవచ్చు.';
$string['switchphase50'] = 'వర్క్ మూసివేయి';
$string['switchphase50info'] = 'మీరు వర్క్ షాప్ని మూసివేయబోతున్నారు. గ్రేడ్బుక్లో కనిపించే లెక్కించిన తరగతులు దీని ఫలితంగా సంభవిస్తాయి. విద్యార్థులు వారి సమర్పణలను మరియు వారి సమర్పణ పరిశీలనలను చూడవచ్చు.';
$string['switchphaseauto'] = 'స్విచ్చింగ్ షెడ్యూల్ చేయబడింది';
$string['switchphasenext'] = 'తదుపరి దశకు మారండి';
$string['taskassesspeers'] = 'సహచరులను అంచనా వేయండి';
$string['taskassesspeersdetails'] = 'మొత్తం: {$a->total}<br />పెండింగ్: {$a->todo}';
$string['taskassessself'] = 'మీరే అంచనా వేయండి';
$string['taskconclusion'] = 'సూచించే ముగింపును అందించండి';
$string['taskdone'] = 'విధి పూర్తయింది';
$string['taskfail'] = 'విధి విఫలమైంది';
$string['taskinfo'] = 'టాస్క్ సమాచారం';
$string['taskinstructauthors'] = 'సమర్పణకు సూచనలను అందించండి';
$string['taskinstructreviewers'] = 'అంచనా కోసం సూచనలు అందించండి';
$string['taskintro'] = 'వర్క్ వివరణను సెట్ చేయండి';
$string['tasksubmit'] = 'మీ పనిని సమర్పించండి';
$string['tasktodo'] = 'చేయవలసిన పని';
$string['toolbox'] = 'వర్క్షాప్ టూల్బాక్స్';
$string['undersetup'] = 'వర్క్ షాప్ ప్రస్తుతం ఏర్పాటు చేయబడుతోంది. తదుపరి దశకు మారడం వరకు దయచేసి వేచి ఉండండి.';
$string['useexamples'] = 'ఉదాహరణలు ఉపయోగించండి';
$string['useexamples_desc'] = 'ఉదాహరణ సమర్పణలు మదింపులో అభ్యాసానికి అందించబడ్డాయి';
$string['useexamples_help'] = 'ప్రారంభించబడితే, వినియోగదారులు ఒకటి లేదా అంతకంటే ఎక్కువ ఉదాహరణ సమర్పణలను అంచనా వేయడానికి ప్రయత్నించవచ్చు మరియు సూచన అంచనాతో వారి అంచనాను సరిపోల్చవచ్చు. గ్రేడ్ అంచనా కోసం లెక్కించబడదు.';
$string['usepeerassessment'] = 'తోటి వారి అంచనాను ఉపయోగించండి';
$string['usepeerassessment_desc'] = 'విద్యార్థులు ఇతరుల పనిని అంచనా వేయవచ్చు';
$string['usepeerassessment_help'] = 'ఎనేబుల్ చేస్తే, ఒక వినియోగదారుడు ఇతర వినియోగదారుల నుండి సమర్పణలు కేటాయించబడవచ్చు మరియు వారి స్వంత సమర్పణకు అదనంగా అంచనా కోసం ఒక గ్రేడ్ను అంచనా వేయవచ్చు.';
$string['userdatecreated'] = '<span>{$a}</span> పై సమర్పించబడింది';
$string['userdatemodified'] = '<span>{$a}</span> పై సవరించబడింది';
$string['userplan'] = 'వర్క్ షాప్ ప్లానర్';
$string['userplan_help'] = 'వర్క్ షాప్ ప్లానర్ సూచించే అన్ని దశలను ప్రదర్శిస్తుంది మరియు ప్రతి దశకు సంబంధించిన విధులను జాబితా చేస్తుంది. ప్రస్తుత దశ హైలైట్ మరియు పని పూర్తి ఒక టిక్ తో సూచించబడుతుంది.';
$string['userplanaccessibilityskip'] = 'ప్రస్తుత విధులకు దాటవేయి';
$string['userplanaccessibilitytitle'] = '{$a} దశల్లో వర్క్ షాప్ కాలక్రమం';
$string['userplancurrentphase'] = 'ప్రస్తుత దశ';
$string['useselfassessment'] = 'స్వీయ-అంచనాను ఉపయోగించండి';
$string['useselfassessment_desc'] = 'విద్యార్ధులు తమ పనిని అంచనా వేయవచ్చు';
$string['useselfassessment_help'] = 'ప్రారంభించబడితే, ఒక వినియోగదారుడు వారి సమర్పణకు కేటాయించబడవచ్చు మరియు వారి సమర్పణకు అదనంగా అంచనా కోసం ఒక గ్రేడ్ను అంచనా వేయవచ్చు.';
$string['viewworkshopsummary'] = 'వర్క్ షాప్ సారాంశం చూడండి';
$string['weightinfo'] = 'బరువు: {$a}';
$string['withoutsubmission'] = 'సొంత సమర్పణ లేకుండా సమీక్షకుడు';
$string['workshop:addinstance'] = 'కొత్త వర్క్ షాప్ జోడించండి';
$string['workshop:allocate'] = 'సమీక్ష కోసం సమర్పణలను కేటాయించండి';
$string['workshop:deletesubmissions'] = 'సమర్పణలను తొలగించండి';
$string['workshop:editdimensions'] = 'అంచనా రూపాలను సవరించండి';
$string['workshop:exportsubmissions'] = 'సమర్పణలను ఎగుమతి చేయండి';
$string['workshop:ignoredeadlines'] = 'సమయ పరిమితులను విస్మరించండి';
$string['workshop:manageexamples'] = 'ఉదాహరణకు సమర్పణలను నిర్వహించండి';
$string['workshop:overridegrades'] = 'లెక్కించిన తరగతులు భర్తీ';
$string['workshop:peerassess'] = 'తోటి వారి అంచనా';
$string['workshop:publishsubmissions'] = 'సమర్పణలను ప్రచురించండి';
$string['workshop:submit'] = 'సమర్పించండి';
$string['workshop:switchphase'] = 'దశ మారండి';
$string['workshop:view'] = 'వర్క్ షాప్ చూడండి';
$string['workshop:viewallassessments'] = 'అన్ని పరిశీలనలను వీక్షించండి';
$string['workshop:viewallsubmissions'] = 'అన్ని సమర్పణలను వీక్షించండి';
$string['workshop:viewauthornames'] = 'రచయిత పేర్లను వీక్షించండి';
$string['workshop:viewauthorpublished'] = 'ప్రచురించిన సమర్పణల రచయితలను వీక్షించండి';
$string['workshop:viewpublishedsubmissions'] = 'ప్రచురించిన సమర్పణలను వీక్షించండి';
$string['workshop:viewreviewernames'] = 'సమీక్షకుల పేర్లను వీక్షించండి';
$string['workshopname'] = 'వర్క్ షాప్ పేరు';
$string['yourassessmentfor'] = '{$a} కోసం మీ అంచనా';
$string['yourgrades'] = 'మీ తరగతులు';
$string['yoursubmission'] = 'మీ సమర్పణ';
