<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'block_coupon', language 'te', version '4.3'.
 *
 * @package     block_coupon
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action:coupon:delete'] = 'కూపన్ను తొలగించు';
$string['action:coupon:delete:confirm'] = 'మీరు ఈ కూపన్ను ఖచ్చితంగా తొలగించాలనుకుంటున్నారా? ఒకసారి తొలగించాకా తిరిగి పొందలేము!';
$string['action:error:delete'] = 'లోపాన్ని తొలగించండి';
$string['and'] = 'మరియు';
$string['blockname'] = 'కూపన్';
$string['button:next'] = 'తరువాత';
$string['button:save'] = 'కూపన్లు రూపొందించండి';
$string['button:submit_coupon_code'] = 'కూపన్ను సమర్పించండి';
$string['cohort'] = 'సామరస్యం';
$string['confirm_coupons_sent_body'] = 'హలో, <br /> <br />

{$ A-> సమయముచేసిన} మీచే సృష్టించబడిన అన్ని కూపన్లు పంపించామని మీకు తెలియజేస్తున్నాము. <br /> <br />

<br /> <br /> కరుణతో, <br /> <br />

Moodle నిర్వాహకుడు';
$string['confirm_coupons_sent_subject'] = 'అన్ని కూపన్లు పంపించబడ్డాయి';
$string['coupon:addinstance'] = 'క్రొత్త కూపన్ బ్లాక్ను జోడించండి';
$string['coupon:administration'] = 'కూపన్ బ్లాక్ను నిర్వహించండి';
$string['coupon:claim:wronguser'] = 'ఈ వ్యక్తిగతీకరించిన కూపన్ <i> కాదు </ i> దావా మీదే';
$string['coupon:cleanup:heading'] = 'క్లీన్ కూపన్లు';
$string['coupon:cleanup:info'] = 'సిస్టమ్ నుండి తొలగించడానికి కూపన్లు కాన్ఫిగర్ చేయడానికి ఈ ఫారమ్ను ఉపయోగించండి. <br/>
<b> హెచ్చరిక: </ b> ఈ విధానం సిస్టమ్ నుండి కూపన్లను <i> తీసివేస్తుంది </ i>, ఈ శుభ్రపరచడం పూర్తయినప్పుడు వాటిని తిరిగి పొందటానికి మార్గం లేదు';
$string['coupon:deleted'] = 'కూపన్ తొలగించబడింది';
$string['coupon:extendenrol'] = 'నమోదు పొడిగింపు కూపన్లు';
$string['coupon:extendenrolments'] = 'కోర్సు నమోదులను విస్తరించడానికి కూపన్లు రూపొందించండి';
$string['coupon:extenrol:summary'] = 'కూపన్ రకం: {$ a-> coupontype} <br/>
ఉత్పత్తి చేయడానికి కూపన్ల మొత్తం: {$ a-> మొత్తం} <br/>
కూపన్ (ల) ను ఉత్పత్తి చేయడానికి ఉపయోగించే నేపథ్యం: {$ a-> లోగో} <br/>
కూపన్లు ఉత్పత్తి చేయబడ్డాయి: {$ a-> యజమాని} <br/>
ఎంచుకున్న కోర్సు (లు): {$ a-> కోర్సులు} <br/>
పొడిగింపు వ్యవధి: {$ a-> వ్యవధి} <br/>
కూపన్ (లు) పై: {$ a-> senddate} <br/> పంపండి
కూపన్ (లు) కి: {$ a-> స్వీకర్త} <br/> <br/> కు పంపండి
ఇమెయిల్-బాడీ: {$ a-> emailbody} <br/>';
$string['coupon:generatecoupons'] = 'క్రొత్త కూపన్ని సృష్టించండి';
$string['coupon:inputcoupons'] = 'చందా కోసం కూపన్ను ఉపయోగించండి';
$string['coupon:myaddinstance'] = 'నా మూడ్ల పేజీకి క్రొత్త కూపన్ బ్లాక్ను జోడించండి';
$string['coupon:send:fail'] = 'ఇ-మెయిల్ పంపడం విఫలమైంది! కారణం: {$a}';
$string['coupon:senddate:instant'] = 'తక్షణ';
$string['coupon:timeframe'] = 'రకం';
$string['coupon:type'] = 'Type';
$string['coupon:type:all'] = 'అన్ని';
$string['coupon:type:cohort'] = 'కోహోర్ట్ నమోదు';
$string['coupon:type:course'] = 'కోర్సు నమోదు';
$string['coupon:type:enrolext'] = 'నమోదు పొడిగింపు';
$string['coupon:used'] = 'తొలగింపు';
$string['coupon:used:all'] = 'అన్ని కూపన్లు';
$string['coupon:used:no'] = 'ఉపయోగించని కూపన్లు మాత్రమే';
$string['coupon:used:yes'] = 'వాడిన కూపన్లు మాత్రమే';
$string['coupon:viewallreports'] = 'కూపన్ నివేదికలను వీక్షించండి (అన్ని కూపన్ల కోసం)';
$string['coupon:viewreports'] = 'కూపన్ నివేదికలను వీక్షించండి (నా యాజమాన్య కూపన్ల కోసం)';
$string['coupon_mail_content'] = 'ప్రియమైన {$ a->to_name}, <br /> <br />

కొత్తగా రూపొందించిన కూపన్లు ఉన్నందున మీరు ఈ సందేశాన్ని స్వీకరిస్తున్నారు. ఈ సందేశానికి అటాచ్మెంట్లో కూపన్లు చేర్చబడ్డాయి. <br /> <br />

<br /> <br /> కరుణతో, <br /> <br />

{$ A-> FROM_NAME}';
$string['coupon_mail_csv_content'] = '<br /> ## to_gender ## ## to_name ## ప్రియమైన, <br /> <br /> ప్రియమైన

మీరు ఇటీవలే మా శిక్షణ కోసం ## కోర్సు_ఫుల్స్మెంట్స్ ## కోసం చేరాడు.
<br/> <br/> <br/> <br/> <br/> <br/> <br/> <br /> <br /> <br /> మీరు మా ఆన్లైన్ నేర్చుకోవడం ఎన్విరాన్మెంట్కు ప్రాప్యత కలిగి ఉన్నారు: ## site_name ##

ఈ వాతావరణంలో, కోర్సు పదార్థాలు కాకుండా, మీరు తోటి విద్యార్థులతో నెట్వర్క్ అవకాశం ఉంటుంది.
ఈ కోర్సు అనేక తయారీ పనులతో ప్రారంభమవుతుంది, మేము వాటిని పరిశీలించమని కోరసాము
కోర్సు మొదలవుతుంది ముందు తాజా 3 (పని) రోజులలో.
<br /> <br /> మీరు మరియు ఉపాధ్యాయుడు రెండూ కూడా కోర్సు కోసం సిద్ధం చేయవచ్చు. <br /> <br />

కోర్సు మొదలవుతుంది ముందు 4 రోజులలో, అన్ని కోర్సు పదార్థాలు మీకు అందుబాటులో ఉంటాయి.
తరువాతి కాలంలో, ఉదాహరణకు, ఉపాధ్యాయుని అదనపు పదార్ధాలను జతచేయాలని ఇది ఎల్లప్పుడూ జరుగుతుంది
భౌతిక సెషన్ తర్వాత. ఇది జరిగితే, మీరు నేర్చుకోవడం వాతావరణంలో దీన్ని చూడడానికి అబే ఉంటుంది
సమావేశాల సమయంలో మీరు ఏదైనా ముద్రిత పాఠం పదార్థాలను అందుకోరు, మేము ల్యాప్టాప్ మరియు / లేదా టాబ్లెట్ను తీసుకురామని మీకు సలహా ఇస్తాము.

మీరు జోడించిన కోర్సులోకి ప్రవేశించడానికి కూపన్ను కనుగొనవచ్చు. ఈ కూపన్ వ్యక్తిగత మరియు ప్రత్యేకమైనది, మరియు మీ విద్య కోసం తగిన కోర్సులకు యాక్సెస్ ఇస్తుంది.
<br /> <br /> కూపన్లోని సూచనలను జాగ్రత్తగా చదవండి. <br /> <br />

మీరు ఒక ఖాతాను సృష్టించడం గురించి ఏవైనా ప్రశ్నలు ఉంటే లేదా ఏదైనా ఇతర సమస్యలను కనుగొంటే, మీరు helpdesk ను సంప్రదించవచ్చు.
నేర్చుకోవడం పర్యావరణం పై సమాచారాన్ని కనుగొనవచ్చు.
మీ ప్రశ్నకు సమాధానమివ్వటానికి ఎవరూ అందుబాటులో లేనప్పుడు, దయచేసి మీ పేరు, ఇ-మెయిల్మెట్రెస్ మరియు ఫోనేంబర్ వెనుక వదిలివేసి,
వీలైనంత త్వరగా. <br /> <br />

<br /> <br /> మీరు కోర్సులో అదృష్టం అనుకుంటున్నారా. <br /> <br />

<br /> <br /> కరుణతో, <br /> <br />

## ను SITE_NAME ##';
$string['coupon_mail_csv_content_cohorts'] = '<br /> ## to_gender ## ## to_name ## ప్రియమైన, <br /> <br /> ప్రియమైన

మీరు ఇటీవలే మా శిక్షణ కోసం చేరాబడ్డారు ** మానవీయంగా ** నింపండి.
<br/> <br/> <br/> <br/> <br/> <br/> <br/> <br /> <br /> <br /> మీరు మా ఆన్లైన్ నేర్చుకోవడం ఎన్విరాన్మెంట్కు ప్రాప్యత కలిగి ఉన్నారు: ## site_name ##

ఈ వాతావరణంలో, కోర్సు పదార్థాలు కాకుండా, మీరు తోటి విద్యార్థులతో నెట్వర్క్ అవకాశం ఉంటుంది.
ఈ కోర్సు అనేక తయారీ పనులతో ప్రారంభమవుతుంది, మేము వాటిని పరిశీలించమని కోరసాము
కోర్సు మొదలవుతుంది ముందు తాజా 3 (పని) రోజులలో.
<br /> <br /> మీరు మరియు ఉపాధ్యాయుడు రెండూ కూడా కోర్సు కోసం సిద్ధం చేయవచ్చు. <br /> <br />

కోర్సు మొదలవుతుంది ముందు 4 రోజులలో, అన్ని కోర్సు పదార్థాలు మీకు అందుబాటులో ఉంటాయి.
తరువాతి కాలంలో, ఉదాహరణకు, ఉపాధ్యాయుని అదనపు పదార్ధాలను జతచేయాలని ఇది ఎల్లప్పుడూ జరుగుతుంది
భౌతిక సెషన్ తర్వాత. ఇది జరిగితే, మీరు నేర్చుకోవడం వాతావరణంలో దీన్ని చూడడానికి అబే ఉంటుంది
సమావేశాల సమయంలో మీరు ఏదైనా ముద్రిత పాఠం పదార్థాలను అందుకోరు, మేము ల్యాప్టాప్ మరియు / లేదా టాబ్లెట్ను తీసుకురామని మీకు సలహా ఇస్తాము.

మీరు జోడించిన కోర్సులోకి ప్రవేశించడానికి కూపన్ను కనుగొనవచ్చు. ఈ కూపన్ వ్యక్తిగత మరియు ఏకైక, మరియు మీ విద్య కోసం తగిన కోర్సులు యాక్సెస్ ఇస్తుంది.
<br /> <br /> కూపన్లోని సూచనలను జాగ్రత్తగా చదవండి. <br /> <br />

మీరు ఒక ఖాతాను సృష్టించడం గురించి ఏవైనా ప్రశ్నలు ఉంటే లేదా ఏదైనా ఇతర సమస్యలను కనుగొంటే, మీరు helpdesk ను సంప్రదించవచ్చు.
సమాచారం మా నేర్చుకోవడం పర్యావరణంలో చూడవచ్చు.
మీ ప్రశ్నకు సమాధానమివ్వటానికి ఎవరూ అందుబాటులో లేనప్పుడు, దయచేసి మీ పేరు, ఇ-మెయిల్మెట్రెస్ మరియు ఫోనేంబర్ వెనుక వదిలివేసి,
వీలైనంత త్వరగా. <br /> <br />

<br /> <br /> మీరు కోర్సులో అదృష్టం అనుకుంటున్నారా. <br /> <br />

<br /> <br /> కరుణతో, <br /> <br />

## ను SITE_NAME ##';
$string['coupon_mail_extend_content'] = '<br /> ## to_gender ## ## to_name ## ప్రియమైన, <br /> <br /> ప్రియమైన

మీరు మా శిక్షణ ## course_fullnames ## కోసం నమోదు చేయబడ్డారు మరియు మంజూరు మరియు పొడిగింపు జరిగింది.
<br /> <br /> మీ ఆన్లైన్ నేర్చుకోవడం ఎన్విరాన్మెంట్కు మీకు ఇప్పటికే ఆక్సెస్ ఉంది: ## site_name ##. <br /> <br />
<br /> <br /> మీ పొడిగింపు ## పొడిగింపు ##. <br /> <br />

మీరు జోడించిన కోర్సుకు యాక్సెస్ను విస్తరించడానికి కూపన్ కనుగొనవచ్చు. ఈ కూపన్ వ్యక్తిగత మరియు ఏకైక, మరియు మీ విద్య కోసం తగిన కోర్సులు యాక్సెస్ విస్తరించింది.
<br /> <br /> కూపన్లోని సూచనలను జాగ్రత్తగా చదవండి. <br /> <br />

మీకు ఏవైనా సమస్యలు ఉంటే ఏవైనా ప్రశ్నలు ఉంటే, మీరు helpdesk ను సంప్రదించవచ్చు.
సమాచారం మా నేర్చుకోవడం పర్యావరణంలో చూడవచ్చు.
మీ ప్రశ్నకు సమాధానమివ్వటానికి ఎవరూ అందుబాటులో లేనప్పుడు, దయచేసి మీ పేరు, ఇ-మెయిల్మెట్రెస్ మరియు ఫోనేంబర్ వెనుక వదిలివేసి,
వీలైనంత త్వరగా. <br /> <br />

<br /> <br /> కరుణతో, <br /> <br />

## ను SITE_NAME ##';
$string['coupon_mail_subject'] = 'మూడ్లె కూపన్ సృష్టించబడింది';
$string['coupon_recipients_desc'] = 'E- మెయిల్, లింగం, పేరు. <br/> క్రమం తప్పకుండా ఆర్డర్ చేయకుండా, అప్లోడ్ చేయబడిన CSV లో క్రింది నిలువు వరుసలు ఉండాలి.
CSV లో ఇవ్వబడిన ప్రతి వ్యక్తికి, కూపన్ ఉత్పత్తి చేయబడుతుంది మరియు వినియోగదారుకు ఇమెయిల్ పంపబడుతుంది. <br/>
దయచేసి ఈ కూపన్లు నేపథ్య పని ద్వారా ఒక సమకాలీకరణ సృష్టించబడతాయి గమనించండి; తక్షణం <i> కాదు </ i>.
కూపన్లు ఉత్పన్నమయ్యే ప్రక్రియ ముఖ్యంగా పెద్ద మొత్తంలో వినియోగదారులకు చాలా పొడవుగా ఉంటుంది.';
$string['coupons_ready_to_send'] = 'మీ కూపన్ (లు) ఉత్పత్తి చేయబడ్డాయి మరియు ఎంటర్ చేసిన తేదీలో పంపబడతాయి. <br />
    అన్ని కూపన్లు పంపబడినప్పుడు మీరు నిర్ధారణ ఇమెయిల్ సందేశాన్ని అందుకుంటారు.';
$string['coupons_sent'] = 'మీ కూపన్ (లు) ఉత్పత్తి చేయబడ్డాయి. అనేక నిమిషాలలోనే మీరు జోడింపులలో కూపన్లతో ఒక ఇమెయిల్ను అందుకుంటారు';
$string['course'] = 'కోర్సు';
$string['days_access'] = '{$a} రోజులు';
$string['default-coupon-page-template-botleft'] = '<Ol>
<li> {site_url} వద్ద సైన్ అప్ చేయండి </ li>
<li> నిర్ధారణ url తో మీకు ఇమెయిల్ అందుతుంది. మీ ఖాతాని సక్రియం చేయడానికి url పై క్లిక్ చెయ్యండి. </ Li>
<li> మీ మూడింటి కూపన్ బ్లాక్లో మీ కూపన్ కోడ్ను నమోదు చేయండి </ li>
<li> హ్యాపీ లెర్నింగ్! </ li>
</ Ol>';
$string['default-coupon-page-template-botright'] = '<Ol>
<li> {site_url} వద్ద లాగిన్ అవ్వండి </ li>
<li> మీ మూడింటి కూపన్ బ్లాక్లో మీ కూపన్ కోడ్ను నమోదు చేయండి </ li>
<li> హ్యాపీ లెర్నింగ్! </ li>
</ Ol>';
$string['default-coupon-page-template-main'] = 'ఈ కూపన్తో మీరు ఈ కింది ఇ-లెర్నింగ్ మాడ్యూల్ (లు) యాక్సెస్ సక్రియం చేయవచ్చు: <br/>
{కోర్సులు} ({పాత్ర}) <br/> <br/>
మీరు ఈ మాడ్యూల్కు {accesstime} ప్రాప్యతను కలిగి ఉన్నారు. <br/> <br/>
దయచేసి యాక్సెస్ను సక్రియం చేయడానికి కింది కూపన్ కోడ్ని ఉపయోగించండి <br/>
{కూపన్ కోడ్}';
$string['download-sample-csv'] = 'నమూనా CSV ఫైల్ డౌన్లోడ్';
$string['enrolperiod:extension'] = '{$a} వ్యవధి కోసం';
$string['enrolperiod:indefinite'] = '<I> నిరవధిక </ i>';
$string['error:alternative_email_invalid'] = 'మీరు \'ప్రత్యామ్నాయ ఇమెయిల్ను ఉపయోగించా\' తనిఖీ చేస్తే ఈ ఫీల్డ్లో చెల్లుబాటు అయ్యే ఇమెయిల్ చిరునామా ఉండాలి.';
$string['error:alternative_email_required'] = 'మీరు \'ప్రత్యామ్నాయ ఇమెయిల్ను ఉపయోగించాలని\' ఎంచుకుంటే ఈ ఫీల్డ్ అవసరం.';
$string['error:cohort_sync'] = 'సమూహాలను సమకాలీకరించడానికి ప్రయత్నిస్తున్నప్పుడు లోపం సంభవించింది. దయచేసి మద్దతును సంప్రదించండి';
$string['error:coupon_already_used'] = 'ఈ కోడ్తో కూపన్ ఇప్పటికే ఉపయోగించబడింది.';
$string['error:coupon_amount-recipients-both-set'] = 'దయచేసి గ్రహీతల యొక్క CSV జాబితాను రూపొందించడానికి అనేక కూపన్లు పేర్కొనండి.';
$string['error:coupon_amount-recipients-both-unset'] = 'ఈ ఫీల్డ్ లేదా ఫీల్డ్ గ్రహీతలు సెట్ చేయబడాలి.';
$string['error:coupon_amount_too_high'] = 'దయచేసి {$a->min} మరియు {$a->max} మధ్య అయోనట్ ఎంటర్ చేయండి.';
$string['error:coupon_reserved'] = 'ఈ కోడ్తో కూడిన కూపన్ మరొక వినియోగదారు కోసం కేటాయించబడింది.';
$string['error:course-coupons-not-copied'] = 'క్రొత్త coupon_courses పట్టికకు కూపన్-కోర్సులు కాపీ చేయడానికి ప్రయత్నిస్తున్నప్పుడు లోపం సంభవించింది. దయచేసి మద్దతును సంప్రదించండి.';
$string['error:course-not-found'] = 'కోర్సు కనుగొనబడలేదు.';
$string['error:invalid_coupon_code'] = 'మీరు చెల్లని కూపన్ కోడ్ను నమోదు చేసారు.';
$string['error:invalid_email'] = 'దయచేసి చెల్లుబాటు అయ్యే ఇమెయిల్ చిరునామాను నమోదు చేయండి.';
$string['error:missing_cohort'] = 'ఈ కూపన్తో సంబంధం ఉన్న సామరస్యం (లు) ఇక ఉనికిలో లేవు. దయచేసి మద్దతును సంప్రదించండి.';
$string['error:missing_course'] = 'ఈ కూపన్తో సంబంధం ఉన్న కోర్సు ఇక ఉనికిలో లేదు. దయచేసి మద్దతును సంప్రదించండి.';
$string['error:missing_group'] = 'ఈ కూపన్కు లింక్ చేయబడిన సమూహం (లు) ఇక ఉనికిలో లేవు. దయచేసి మద్దతును సంప్రదించండి';
$string['error:moodledata_not_writable'] = 'మీ మోడ్డేటాటా / కూపన్_లోగోస్ ఫోల్డర్ వ్రాయదగినది కాదు. దయచేసి మీ అనుమతులను పరిష్కరించండి.';
$string['error:no_coupons_submitted'] = 'మీ కూపన్లు ఏవీ ఇంకా ఉపయోగించబడలేదు.';
$string['error:nopermission'] = 'దీన్ని చేయడానికి మీకు అనుమతి లేదు';
$string['error:numeric_only'] = 'ఈ ఫీల్డ్ తప్పనిసరిగా సంఖ్యా సంఖ్యలో ఉండాలి.';
$string['error:plugin_disabled'] = 'Cohort_sync ప్లగిన్ ఆపివేయబడింది. దయచేసి మద్దతును సంప్రదించండి.';
$string['error:recipients-columns-missing'] = 'ఫైల్ సరిదిద్దబడలేదు. మీరు ఖచ్చితంగా నిలువు వరుసలు మరియు seperator ను ఎంటర్ చేసారా?';
$string['error:recipients-email-invalid'] = 'ఇమెయిల్ చిరునామా {$a->email} చెల్లనిది. దయచేసి csv ఫైల్ లో దాన్ని పరిష్కరించండి.';
$string['error:recipients-empty'] = 'దయచేసి కనీసం ఒక వినియోగదారుని నమోదు చేయండి.';
$string['error:recipients-extension'] = 'మీరు .csv ఫైళ్ళను మాత్రమే అప్లోడ్ చేయవచ్చు';
$string['error:recipients-invalid'] = 'ఫైల్ సరిదిద్దబడలేదు. మీరు ఖచ్చితంగా నిలువు వరుసలు మరియు seperator ను ఎంటర్ చేసారా?';
$string['error:recipients-max-exceeded'] = 'మీ csv ఫైల్ గరిష్టంగా 10.000 కూపన్ వినియోగదారులను అధిగమించింది. దయచేసి దీన్ని పరిమితం చేయండి';
$string['error:required'] = 'ఈ ఖాళీని తప్పనిసరిగా పూరించవలెను.';
$string['error:sessions-expired'] = 'మీ సెషన్ గడువు ముగిసింది. దయచేసి మళ్లీ ప్రయత్నించండి.';
$string['error:unable_to_enrol'] = 'క్రొత్త కోర్సులో మిమ్మల్ని నమోదు చేయడానికి ప్రయత్నిస్తున్నప్పుడు లోపం సంభవించింది. దయచేసి మద్దతును సంప్రదించండి.';
$string['error:validate-courses'] = 'కోర్సు ధ్రువీకరణ లోపాలు:
{$a}';
$string['error:wrong_code_length'] = 'దయచేసి 6 మరియు 32 మధ్య సంఖ్యను నమోదు చేయండి.';
$string['error:wrong_doc_page'] = 'మీరు లేని పేజీని ప్రాప్యత చేయడానికి ప్రయత్నిస్తున్నారు.';
$string['error:wrong_image_size'] = 'అప్లోడ్ చేయబడిన నేపథ్యంలో అవసరమైన పరిమాణం లేదు. దయచేసి 210MM నిష్పత్తిని 297 mm ద్వారా ఒక చిత్రాన్ని అప్లోడ్ చేయండి.';
$string['extendaccess'] = '{$a} అదనపు';
$string['extendenrol:abort-no-users'] = 'లోపం: నమోదులు ఎప్పటికప్పుడు పొడిగిస్తాయని ఎటువంటి వినియోగదారులు కనుగొనబడలేదు <br/>
వినియోగదారులందరూ నిరవధికంగా నమోదు చేయబడవచ్చు లేదా ఈ కోర్సు / ఈ కోర్సుల కోసం వినియోగదారులు ఎవరూ కనుగొనబడరు.';
$string['heading:administration'] = 'నిర్వహించడానికి';
$string['heading:amountForm'] = 'మొత్తం సెట్టింగులు';
$string['heading:coupon_type'] = 'కూపన్ రకం';
$string['heading:csvForm'] = 'CSV సెట్టింగ్లు';
$string['heading:general_settings'] = 'చివరి సెట్టింగ్లు';
$string['heading:generatecoupons'] = 'కూపన్లను సృష్టించండి';
$string['heading:imageupload'] = 'చిత్రాన్ని అప్లోడ్ చేయండి';
$string['heading:info'] = 'సమాచారం';
$string['heading:input_cohorts'] = 'కోహోర్ట్లను ఎంచుకోండి';
$string['heading:input_coupon'] = 'ఇన్పుట్ కూపన్';
$string['heading:input_course'] = 'కోర్సు ఎంచుకోండి';
$string['heading:input_groups'] = 'సమూహాలను ఎంచుకోండి';
$string['heading:inputcoupons'] = 'ఇన్పుట్ కూపన్';
$string['heading:label_instructions'] = 'సూచనలను';
$string['heading:manualForm'] = 'మాన్యువల్ సెట్టింగులు';
$string['label:alternative_email'] = 'ప్రత్యామ్నాయ ఇమెయిల్';
$string['label:alternative_email_help'] = 'కూపన్లను డిఫాల్ట్గా ఈ ఇమెయిల్ చిరునామాకు పంపండి';
$string['label:api_enabled'] = 'API ప్రారంభించు';
$string['label:api_enabled_desc'] = 'కూపన్ API బాహ్య వ్యవస్థ నుండి కూపన్లు ఉత్పన్నం చేసే అవకాశం ఇస్తుంది';
$string['label:api_password'] = 'API పాస్వర్డ్';
$string['label:api_password_desc'] = 'API ఉపయోగించి కూపన్ను రూపొందించడానికి ఉపయోగించే పాస్వర్డ్.';
$string['label:api_user'] = 'API వాడుకరి';
$string['label:api_user_desc'] = 'API ఉపయోగించి కూపన్ను రూపొందించడానికి ఉపయోగించే వినియోగదారు పేరు.';
$string['label:cleanupage'] = 'గరిష్ట వయస్సు?';
$string['label:cleanupage_help'] = 'అది తొలగించబడటానికి ముందు ఉపయోగించని కూపన్ యొక్క గరిష్ట వయస్సుని నమోదు చేయండి';
$string['label:cohort'] = 'కోహర్ట్';
$string['label:connected_courses'] = 'కనెక్ట్ చేయబడిన కోర్సు (లు)';
$string['label:coupon_amount'] = 'కూపన్ల మొత్తం';
$string['label:coupon_amount_help'] = 'ఇది కూపన్లు మొత్తం ఉత్పత్తి అవుతుంది. ఈ ఫీల్డ్ లేదా క్షేత్ర గ్రహీతలు ఉపయోగించండి, రెండూ కాదు.';
$string['label:coupon_code'] = 'కూపన్ కోడ్';
$string['label:coupon_code_help'] = 'కూపన్ కోడ్ ప్రతి వ్యక్తి కూపన్తో అనుసంధానించబడిన ఏకైక కోడ్. మీరు ఈ కోడ్ను మీ కూపన్లో కనుగొనవచ్చు.';
$string['label:coupon_code_length'] = 'కోడ్ పొడవు';
$string['label:coupon_cohorts'] = 'కోహర్ట్(లు)';
$string['label:coupon_cohorts_help'] = 'మీ వాడుకరులు/యూజర్లు నమోదు కాబడే ఒకటి లేదా అంతకంటే ఎక్కువ కోహర్ట్లను ఎంచుకోండి.';
$string['label:coupon_connect_course'] = 'కోర్సు (లు) జోడించండి';
$string['label:coupon_connect_course_help'] = 'మీరు కోహోర్ట్ కు జోడించదలచిన అన్ని కోర్సులను ఎంచుకోండి.
    <br /> <b> <i> గమనిక: </ i> </ b> ఇప్పటికే ఎంచుకున్న కోర్సుల్లో ఈ బృందం ఇప్పటికే నమోదు చేయబడిన వినియోగదారులు అందరూ నమోదు చేయబడతారు!';
$string['label:coupon_courses'] = 'కోర్సు (లు)';
$string['label:coupon_courses_help'] = 'మీ వినియోగదారులు సైన్ ఇన్ చేస్తారు కోర్సులు ఎంచుకోండి.';
$string['label:coupon_email'] = 'ఇమెయిల్ చిరునామా';
$string['label:coupon_email_help'] = 'ఇది ఉత్పత్తి చేయబడిన కూపన్లు పంపే ఇమెయిల్ చిరునామా.';
$string['label:coupon_groups'] = 'సమూహం (లు) ను జోడించు';
$string['label:coupon_groups_help'] = 'కోర్సులలో నమోదు చేసుకున్నప్పుడు మీ యూజర్లు నమోదు చేయాలని మీరు కోరుకుంటున్న సమూహాలను ఎంచుకోండి.';
$string['label:coupon_recipients'] = 'గ్రహీతలు';
$string['label:coupon_recipients_help'] = 'ఈ ఫీల్డ్తో మీరు వినియోగదారులతో ఒక csv ఫైల్ను అప్లోడ్ చేయవచ్చు.';
$string['label:coupon_recipients_txt'] = 'గ్రహీతలు';
$string['label:coupon_recipients_txt_help'] = 'ఈ క్షేత్రంలో మీరు అప్లోడ్ చేయబడిన csv ఫైల్కు మీ తుది మార్పులను చేయవచ్చు.';
$string['label:coupon_role'] = 'పాత్ర';
$string['label:coupon_role_help'] = 'కూపన్లు కాన్ఫిగర్ చేయబడిన పాత్రను ఎంచుకోండి లేదా కన్ఫిగర్ డిఫాల్ట్ (సాధారణంగా విద్యార్థి) కోసం ఖాళీగా వదిలివేయండి.';
$string['label:coupon_type'] = 'ఆధారంగా రూపొందించండి';
$string['label:coupon_type_help'] = 'కూపన్లు కోర్సు లేదా ఒకటి లేదా అంతకంటే ఎక్కువ బృందాలు ఆధారంగా రూపొందించబడతాయి.';
$string['label:current_image'] = 'ప్రస్తుత కూపన్ నేపథ్యం';
$string['label:date_send_coupons'] = 'తేదీ పంపండి';
$string['label:date_send_coupons_help'] = 'కూపన్లు గ్రహీత (లు) కి పంపుతారు.';
$string['label:defaultrole'] = 'డిఫాల్ట్ పాత్ర';
$string['label:defaultrole_help'] = 'ఇది కూపన్ క్లెయిమ్ చేసేటప్పుడు వినియోగదారులు కేటాయించబడే డిఫాల్ట్ పాత్ర';
$string['label:email_body'] = 'ఇమెయిల్ సందేశం';
$string['label:email_body_help'] = 'కూపన్లు గ్రహీతలకు పంపే ఇమెయిల్ సందేశం.';
$string['label:enablecleanup'] = 'ఉపయోగించని కూపన్లు శుభ్రపరచడాన్ని ప్రారంభించాలా?';
$string['label:enablecleanup_help'] = 'స్వయంచాలకంగా శుభ్రపరచడానికి (తొలగించు) ఉపయోగించని కూపన్లు ఈ ఎంపికను తనిఖీ చేయండి';
$string['label:enrolment_period'] = 'నమోదు కాలం';
$string['label:enrolment_period_help'] = 'కాలం (రోజుల్లో) యూజర్ కోర్సులు చేరాడు ఉంటుంది. 0 కు సెట్ చేయకపోతే ముగింపు జారీ చేయబడుతుంది.';
$string['label:enter_coupon_code'] = 'దయచేసి ఇక్కడ మీ కూపన్ కోడ్ను నమోదు చేయండి';
$string['label:extendperiod'] = 'నమోదు పొడిగింపు కాలం';
$string['label:extendperiod:desc'] = 'క్రింద ఐచ్ఛిక పొడిగింపు వ్యవధిని కాన్ఫిగర్ చేయండి. <I> కాదు </ i> ఎనేబుల్ లేదా 0 కు సెట్ చేస్తే, నమోదు నిరవధిక నమోదులోకి మారుతుంది';
$string['label:extendusers:desc'] = 'క్రింద ఉన్న ఒకటి లేదా అంతకంటే ఎక్కువ మందిని ఎంచుకోండి. <br/>
మీరు <i> మాన్యువల్ </ i> నమోదును కలిగి ఉన్న వినియోగదారులను మాత్రమే చూస్తారు మరియు వారి నమోదులకు ఎండ్డేట్ సెట్ చేసారు.';
$string['label:generate_pdfs'] = 'Seperate PDF యొక్క ఉత్పత్తి';
$string['label:generate_pdfs_help'] = 'ప్రత్యేక PDF ఫైల్ లో ఒకే ఫైల్లో లేదా ప్రతి కూపన్లో మీ కూపన్ను స్వీకరించాలనుకుంటే ఇక్కడ మీరు ఎంచుకోవచ్చు.';
$string['label:image'] = 'కూపన్ నేపథ్యం';
$string['label:image_desc'] = 'ఉత్పత్తి చేయబడిన కూపన్లలో నేపధ్యం ఉంచబడుతుంది';
$string['label:info_coupon_cohort_courses'] = 'పేజీలో సమాచారం: కాహర్ట్ కోర్సులు';
$string['label:info_coupon_cohorts'] = 'పేజీలో సమాచారం: ఎంచుకోండి కొహోర్ట్స్';
$string['label:info_coupon_confirm'] = 'పేజీలో సమాచారం: కూపన్ను నిర్ధారించండి';
$string['label:info_coupon_course'] = 'పేజీలో సమాచారం: కోర్సు ఎంచుకోండి';
$string['label:info_coupon_course_groups'] = 'పేజీలో సమాచారం: కోర్సు గుంపులను ఎంచుకోండి';
$string['label:info_coupon_type'] = 'పేజీలో సమాచారం: కూపన్ రకాన్ని ఎంచుకోండి';
$string['label:info_desc'] = 'రూపం పైన చూపిన సమాచారం.';
$string['label:info_imageupload'] = 'పేజీలో సమాచారం: బొమ్మను అప్లోడ్ చేయండి';
$string['label:mailusers'] = 'ఎంచుకున్న కోర్సు పాల్గొనేవారికి ఇ-మెయిల్ ద్వారా కూపన్లు పంపండి.';
$string['label:max_coupons'] = 'గరిష్ఠ కూపన్లు';
$string['label:max_coupons_desc'] = 'ఒక సమయంలో సృష్టించగల కూపన్ల మొత్తం.';
$string['label:no_courses_connected'] = 'ఈ బృందంతో ఏ కోర్సులు కలవు.';
$string['label:no_groups_selected'] = 'ఇంకా ఈ కోర్సులకు అనుసంధానించబడిన సమూహాలు ఏవీ లేవు.';
$string['label:redirect_url'] = 'రీడైరెక్ట్ URL';
$string['label:redirect_url_help'] = 'గమ్య వినియోగదారులు వారి కూపన్ కోడ్ను నమోదు చేసిన తర్వాత పంపవచ్చు.';
$string['label:renderqrcode'] = 'QR కోడ్ ఉపయోగించాలా?';
$string['label:renderqrcode_help'] = 'ఉత్పత్తి చేయబడిన PDF లో QR కోడ్లను చేర్చడానికి ఈ ఎంపికను ప్రారంభించండి లేదా నిలిపివేయండి.';
$string['label:selected_cohort'] = 'ఎంచుకున్న సామరస్యం (లు)';
$string['label:selected_courses'] = 'ఎంచుకున్న కోర్సులు';
$string['label:selected_groups'] = 'ఎంచుకున్న సమూహం (లు)';
$string['label:showform'] = 'జనరేటర్ ఎంపికలు';
$string['label:type_cohorts'] = 'సామరస్యం (లు)';
$string['label:type_course'] = 'కోర్సు';
$string['label:use_alternative_email'] = 'ప్రత్యామ్నాయ ఇమెయిల్ ఉపయోగించండి';
$string['label:use_alternative_email_help'] = 'తనిఖీ చేసినప్పుడు ఇది ప్రత్యామ్నాయ ఇమెయిల్ ఫీల్డ్లో అందించిన ఇమెయిల్ చిరునామాను డిఫాల్ట్గా ఉపయోగిస్తుంది.';
$string['label:users'] = 'వినియోగదారు (లు)';
$string['logo:default'] = 'డిఫాల్ట్ లోగో';
$string['logo:none'] = 'లోగోను ఉపయోగించవద్దు';
$string['logomanager:desc'] = 'కూపన్ PDF లలో ఉపయోగించే లోగోలను నిర్వహించడానికి దిగువ logomanager ను ఉపయోగించండి. <br/>
మీరు ఏ రకమైన చిత్రాలను అప్లోడ్ చేస్తారో జాగ్రత్త వహించండి! <br/>
మీరు <i> తప్పక </ i> A4 ఫార్మాట్ (2480 x 3508 పిక్సల్స్) లో 300 DPI చిత్రాలను మాత్రమే ఉపయోగించాలి. <br/>
<i> ఏదైనా </ i> ఇతర చిత్ర పరిమాణాలు బహుశా అవాంఛిత దుష్ప్రభావాలకు దారి తీస్తుంది.';
$string['missing_config_info'] = 'మీ అదనపు సమాచారం ఇక్కడ ఉంచండి - బ్లాక్ యొక్క గ్లోబల్ కన్ఫిగరేషన్ లో సెటప్ చేయాలి.';
$string['page:generate_coupon.php:title'] = 'కూపన్లను సృష్టించండి';
$string['page:generate_coupon_step_five.php:title'] = 'కూపన్లను సృష్టించండి';
$string['page:generate_coupon_step_four.php:title'] = 'కూపన్లను సృష్టించండి';
$string['page:generate_coupon_step_three.php:title'] = 'కూపన్లను సృష్టించండి';
$string['page:generate_coupon_step_two.php:title'] = 'కూపన్లను సృష్టించండి';
$string['page:unused_coupons.php:title'] = 'ఉపయోగించని కూపన్లు';
$string['pdf:titlename'] = 'మూడుల్  కూపన్';
$string['pdf_generated'] = '<br /> <br /> PDF ఫైల్లో కూపన్లు ఈ ఇమెయిల్కు జోడించబడ్డాయి. <br /> <br />';
$string['pluginname'] = 'కూపన్';
$string['privacy:metadata:block_coupon:claimed'] = 'కూపన్ క్లెయిమ్ చేయబడిందా లేదా లేదో';
$string['privacy:metadata:block_coupon:email_body'] = 'ఒకవేళ ఒకవేళ (వ్యక్తిగత) కూపన్ పంపిన ఇమెయిల్ యొక్క కంటెంట్, అన్నింటిలో ఉంటే';
$string['privacy:metadata:block_coupon:for_user_email'] = 'ఏ వ్యక్తికి అయినా (వ్యక్తిగత) కూపన్ పంపిన వ్యక్తి యొక్క ఇమెయిల్ చిరునామా';
$string['privacy:metadata:block_coupon:for_user_gender'] = 'ఒక వ్యక్తి (వ్యక్తి) కూపన్ పంపిన వ్యక్తి యొక్క లింగం, అన్నింటిలో ఉంటే';
$string['privacy:metadata:block_coupon:for_user_name'] = 'ఒక వ్యక్తి (వ్యక్తి) కూపన్ పంపిన వ్యక్తి యొక్క పేరు, అన్నింటిలో ఉంటే';
$string['privacy:metadata:block_coupon:roleid'] = 'కేటాయించిన కూపన్ యొక్క / కేటాయింపు పాత్ర ఐడి';
$string['privacy:metadata:block_coupon:submission_code'] = 'కూపన్ చందా కోడ్';
$string['privacy:metadata:block_coupon:timecreated'] = 'కూపన్ సృష్టించిన సమయం';
$string['privacy:metadata:block_coupon:timeexpired'] = 'కూపన్ కోసం గడువు తేదీ';
$string['privacy:metadata:block_coupon:timemodified'] = 'కూపన్ సవరించిన సమయం';
$string['privacy:metadata:block_coupon:userid'] = 'Moodle వినియోగదారు యొక్క ప్రాథమిక డేటాబేస్ కీ';
$string['promo'] = 'మూడ్లె కోసం కూపన్ ప్లగిన్';
$string['promodesc'] = 'ఈ ప్లగ్ఇన్ Sebsoft మేనేజ్డ్ హోస్టింగ్ & సాఫ్ట్వేర్ డెవలప్మెంట్ రాసిన
(<a href=\'http://www.sebsoft.nl/\' target=\'_new\'> http://sebsoft.nl </a>). <br />
<br /> <br />';
$string['recipient:none'] = 'గమనిక';
$string['recipient:selected:users'] = 'ఎంచుకున్న వినియోగదారులు';
$string['report:cohorts'] = 'సామరస్యం';
$string['report:coupon_code'] = 'చందా కోడ్';
$string['report:dateformat'] = '%d-%m-%Y %H:%M:%S';
$string['report:dateformatymd'] = '%d-%m-%Y';
$string['report:download-excel'] = 'ఉపయోగించని కూపన్లు డౌన్లోడ్ చేయండి';
$string['report:enrolperiod'] = 'యజమాని';
$string['report:for_user_email'] = 'కోసం ప్రణాళిక';
$string['report:for_user_name'] = 'గ్రహీత పేరు';
$string['report:heading:action'] = 'యాక్షన్ (లు)';
$string['report:heading:cohortname'] = 'సామరస్యం (లు)';
$string['report:heading:coupon'] = 'కూపన్';
$string['report:heading:couponcode'] = 'వాడిన కోడ్';
$string['report:heading:coursename'] = 'కోర్సు పేరు';
$string['report:heading:coursetype'] = 'కోర్సు రకం';
$string['report:heading:datecomplete'] = 'తేదీ పూర్తయింది';
$string['report:heading:datestart'] = 'ప్రారంబపు తేది';
$string['report:heading:errormessage'] = 'లోపం';
$string['report:heading:errortype'] = 'రకం';
$string['report:heading:grade'] = 'గ్రేడ్';
$string['report:heading:status'] = 'స్థితి';
$string['report:heading:timecreated'] = 'తేదీ';
$string['report:heading:type'] = 'రకం';
$string['report:heading:user'] = 'వాడుకరి';
$string['report:immediately'] = 'తక్షణమే';
$string['report:issend'] = 'పంపబడింది';
$string['report:owner'] = 'యజమాని';
$string['report:senddate'] = 'తేదీ పంపండి';
$string['report:status_completed'] = 'కోర్సు పూర్తయింది';
$string['report:status_not_started'] = 'కోర్సు ఇంకా ప్రారంభించబడలేదు';
$string['report:status_started'] = 'కోర్సు ప్రారంభించబడింది';
$string['report:timeexpired'] = 'గడువు ముగిసేది';
$string['select:logo'] = 'టెంప్లేట్ లోగోని ఎంచుకోండి';
$string['select:logo:desc'] = 'టెంప్లేట్ చిహ్నాన్ని ఎంచుకోండి. <br/> కూపన్ల కోసం PDF ను ఉత్పత్తి చేసినప్పుడు మాత్రమే ఇది ఉపయోగించబడుతుంది.';
$string['showform-amount'] = 'నేను కూపన్ల యొక్క ఏకపక్ష మొత్తాన్ని సృష్టించాలనుకుంటున్నాను';
$string['showform-csv'] = 'నేను గ్రహీతలతో ఒక CSV ను ఉపయోగించి కూపన్లను సృష్టించాలనుకుంటున్నాను';
$string['showform-manual'] = 'నేను గ్రహీతలని మానవీయంగా ఆకృతీకరించాలనుకుంటున్నాను';
$string['signup:login'] = 'నాకు ఇప్పటికే ఖాతా ఉంది మరియు లాగిన్ చేయాలనుకుంటున్నాను';
$string['signup:success'] = 'మీరు సైన్ అప్ చేసి, ఇప్పుడు లాగిన్ పేజీకి మళ్ళించబడతారు. <br/>
దయచేసి లాగ్ ఇన్ చేసిన తర్వాత కోర్సుకు మీరు ప్రాప్యతను మంజూరు చేసారు.
Mīru sain ap cēsi';
$string['str:mandatory'] = 'తప్పనిసరి';
$string['str:optional'] = 'ఐచ్ఛికము';
$string['success:coupon_used'] = 'ఉపయోగించిన కూపన్ - మీరు ఇప్పుడు కోర్సు (లు)';
$string['success:uploadimage'] = 'మీ క్రొత్త కూపన్ చిత్రం అప్లోడ్ చేయబడింది.';
$string['tab:apidocs'] = 'API డాక్స్';
$string['tab:cleaner'] = 'శుబ్రం చేయి';
$string['tab:errors'] = 'లోపం నివేదికలు';
$string['tab:report'] = 'పురోగతి నివేదిక';
$string['tab:unused'] = 'ఉపయోగించని కూపన్లు';
$string['tab:used'] = 'వాడిన కూపన్లు';
$string['tab:wzcouponimage'] = 'మూస చిత్రం';
$string['tab:wzcoupons'] = 'కూపన్ (లు) రూపొందించండి';
$string['task:cleanup'] = 'ఉపయోగించని పాత కూపన్లు శుభ్రం';
$string['task:sendcoupons'] = 'షెడ్యూల్డ్ కూపన్లు పంపు';
$string['tasksettings'] = 'టాస్క్ సెట్టింగ్లు';
$string['textsettings'] = 'వచన సెట్టింగ్లు';
$string['textsettings_desc'] = 'ఇక్కడ కూపన్ జెనరేటర్ కోసం వివిధ విజర్డ్ తెరల ద్వారా ప్రదర్శించబడే కస్టమ్ పాఠాన్ని మీరు కన్ఫిగర్ చేయవచ్చు';
$string['th:action'] = 'యాక్షన్ (లు)';
$string['th:cohorts'] = 'సామరస్యం';
$string['th:course'] = 'కోర్సు';
$string['th:enrolperiod'] = 'Enrolperiod';
$string['th:for_user_email'] = 'కోసం ప్రణాళిక';
$string['th:groups'] = 'గ్రూప్ (లు)';
$string['th:immediately'] = 'తక్షణమే';
$string['th:issend'] = 'పంపిన?';
$string['th:owner'] = 'యజమాని';
$string['th:roleid'] = 'పాత్ర';
$string['th:senddate'] = 'తేదీ పంపండి';
$string['th:submission_code'] = 'చందా కోడ్';
$string['th:usedby'] = 'దావా వేశారు';
$string['timeafter'] = 'తర్వాత సృష్టించబడింది';
$string['timebefore'] = 'ముందు సృష్టించబడింది';
$string['unlimited_access'] = 'అపరిమిత';
$string['url:api_docs'] = 'API డాక్యుమెంటేషన్';
$string['url:couponsignup'] = 'కూపన్ కోడ్తో సైన్అప్ చేయండి';
$string['url:generate_coupons'] = 'కూపన్ని సృష్టించండి';
$string['url:input_coupon'] = 'ఇన్పుట్ కూపన్';
$string['url:managelogos'] = 'కూపన్ చిత్రాలను నిర్వహించండి';
$string['url:uploadimage'] = 'కూపన్ చిత్రాన్ని మార్చండి';
$string['url:view_reports'] = 'నివేదికలని చూడండి';
$string['url:view_unused_coupons'] = 'ఉపయోగించని కూపన్లు వీక్షించండి';
$string['view:api:heading'] = 'కూపన్ API';
$string['view:api:title'] = 'కూపన్ API';
$string['view:api_docs:heading'] = 'కూపన్ API డాక్యుమెంటేషన్';
$string['view:api_docs:title'] = 'కూపన్ API డాక్యుమెంటేషన్';
$string['view:cleanup:heading'] = 'క్లీన్ కూపన్లు';
$string['view:cleanup:title'] = 'క్లీన్ కూపన్లు';
$string['view:errorreport:heading'] = 'నివేదించండి - కూపన్ లోపాలు';
$string['view:errorreport:title'] = 'నివేదించండి - కూపన్ లోపాలు';
$string['view:extendenrolment:heading'] = 'కూపన్: నమోదు పొడిగింపులు';
$string['view:extendenrolment:title'] = 'కూపన్: నమోదు పొడిగింపులు';
$string['view:extendenrolment_step1:heading'] = 'నమోదులను విస్తరించు: కోర్సు (లు) ఎంచుకోండి';
$string['view:extendenrolment_step1:title'] = 'నమోదులను విస్తరించు: కోర్సు (లు) ఎంచుకోండి';
$string['view:extendenrolment_step2:heading'] = 'నమోదులను విస్తరించండి: యూజర్లు ఎంచుకోండి';
$string['view:extendenrolment_step2:title'] = 'నమోదులను విస్తరించండి: యూజర్లు ఎంచుకోండి';
$string['view:extendenrolment_step3:heading'] = 'నమోదులను పొడిగించండి: నిర్ధారించండి';
$string['view:extendenrolment_step3:title'] = 'నమోదులను పొడిగించండి: నిర్ధారించండి';
$string['view:generate_coupon:heading'] = 'కూపన్ని సృష్టించండి';
$string['view:generate_coupon:title'] = 'కూపన్ని సృష్టించండి';
$string['view:input_coupon:heading'] = 'ఇన్పుట్ కూపన్';
$string['view:input_coupon:title'] = 'ఇన్పుట్ కూపన్';
$string['view:reports-unused:heading'] = 'నివేదించు - ఉపయోగించని కూపన్లు';
$string['view:reports-unused:title'] = 'నివేదించు - ఉపయోగించని కూపన్లు';
$string['view:reports-used:heading'] = 'నివేదించు - వాడిన కూపన్లు';
$string['view:reports-used:title'] = 'నివేదించు - వాడిన కూపన్లు';
$string['view:reports:heading'] = 'నివేదించు - కూపన్ ఆధారిత పురోగతి';
$string['view:reports:title'] = 'నివేదించు - కూపన్ ఆధారిత పురోగతి';
$string['view:request:heading'] = 'కూపన్లు అభ్యర్థించండి';
$string['view:request:title'] = 'కూపన్లు అభ్యర్థించండి';
$string['view:uploadimage:heading'] = 'క్రొత్త కూపన్ నేపథ్యాన్ని అప్లోడ్ చేయండి';
$string['view:uploadimage:title'] = 'కూపన్ నేపథ్యాన్ని అప్లోడ్ చేయండి';
