<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'bigbluebuttonbn', language 'te', version '4.3'.
 *
 * @package     bigbluebuttonbn
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'మీకు రాబోయే పెద్దబ్లూబట్టాన్ సెషన్లు ఉన్నాయి';
$string['bbbduetimeoverstartingtime'] = 'ఈ కార్యాచరణకు తగిన సమయం ప్రారంభ సమయం కంటే ఎక్కువగా ఉండాలి';
$string['bbbdurationwarning'] = 'ఈ సెషన్కు గరిష్ట వ్యవధి% వ్యవధి% నిమిషాలు.';
$string['bbbrecordwarning'] = 'ఈ సెషన్ రికార్డ్ చేయబడవచ్చు.';
$string['bigbluebuttonbn'] = 'BigBlueButton';
$string['bigbluebuttonbn:addinstance'] = 'కొత్త పెద్దబ్లూబట్టన్ గది / కార్యాచరణను జోడించండి';
$string['bigbluebuttonbn:join'] = 'పెద్దబ్లూబ్యూటన్న్ సమావేశంలో చేరండి';
$string['bigbluebuttonbn:managerecordings'] = 'పెద్దబ్లూబట్టాన్ రికార్డింగ్లు నిర్వహించండి';
$string['config_extended_capabilities'] = 'పొడిగించిన సామర్థ్యాల కోసం ఆకృతీకరణ';
$string['config_extended_capabilities_description'] = 'BigBlueButton సర్వర్ వాటిని అందిస్తున్నప్పుడు పొడిగించిన సామర్థ్యాల కోసం ఆకృతీకరణ.';
$string['config_general'] = 'సాధారణ ఆకృతీకరణ';
$string['config_general_description'] = 'ఈ సెట్టింగ్లు <b> ఎల్లప్పుడూ </ b> ఉపయోగించబడతాయి';
$string['config_importrecordings'] = '"దిగుమతి రికార్డింగ్" లక్షణం కోసం కాన్ఫిగరేషన్';
$string['config_importrecordings_description'] = 'ఈ సెట్టింగులు ఫీచర్ ప్రత్యేకమైనవి';
$string['config_importrecordings_enabled'] = 'దిగుమతి రికార్డింగ్ ప్రారంభించబడింది';
$string['config_importrecordings_enabled_description'] = 'ఈ మరియు రికార్డింగ్ ఫీచర్ ఎనేబుల్ అయినప్పుడు, విభిన్న కోర్సుల నుండి ఒక కార్యాచరణలో రికార్డింగ్లను దిగుమతి చేసుకోవడం సాధ్యమవుతుంది.';
$string['config_importrecordings_from_deleted_enabled'] = 'తొలగించిన కార్యాచరణల నుండి రికార్డింగ్లను ప్రారంభించండి';
$string['config_importrecordings_from_deleted_enabled_description'] = 'ఈ మరియు దిగుమతి రికార్డింగ్ ఫీచర్ ఎనేబుల్ అయినప్పుడు, కోర్సులో లేని కార్యకలాపాల నుండి రికార్డింగ్లను దిగుమతి చేసుకోవడం సాధ్యపడుతుంది.';
$string['config_meetingevents_enabled'] = 'సమావేశం ఈవెంట్స్ నమోదు';
$string['config_meetingevents_enabled_description'] = 'సమావేశం ఈవెంట్స్ ఫీచర్ ఎనేబుల్ చెయ్యి.';
$string['config_participant'] = 'పాల్గొనే కాన్ఫిగరేషన్';
$string['config_participant_description'] = 'ఒక సమావేశంలో పాల్గొనే వారికి ఈ అమరికలు డిఫాల్ట్గా పాత్రను నిర్వచిస్తాయి.';
$string['config_participant_moderator_default'] = 'డిఫాల్ట్గా మోడరేటర్';
$string['config_participant_moderator_default_description'] = 'ఒక కొత్త గది జోడించినప్పుడు ఈ నిబంధన డిఫాల్ట్గా ఉపయోగించబడుతుంది.';
$string['config_preuploadpresentation'] = '"ముందు అప్లోడ్ ప్రదర్శన" ఫీచర్ కోసం ఆకృతీకరణ';
$string['config_preuploadpresentation_description'] = 'ఈ సెట్టింగులు UI లో ఎనేబుల్ లేదా డిసేబుల్ చేస్తాయి మరియు ఈ ఐచ్చికముల కొరకు డిఫాల్ట్ విలువలను కూడా నిర్వచించును. ఈ లక్షణం బిగ్బ్లేబటన్కు Moodle సర్వర్ అందుబాటులో ఉంటే మాత్రమే పనిచేస్తుంది.';
$string['config_recording'] = '"రికార్డ్ సమావేశం" లక్షణం కోసం ఆకృతీకరణ';
$string['config_recording_default'] = 'రికార్డింగ్ ఫీచర్ డిఫాల్ట్గా ప్రారంభించబడింది';
$string['config_recording_default_description'] = 'ప్రారంభించబడి ఉంటే బిగ్బ్లీబటన్లో సృష్టించిన సెషన్లు రికార్డింగ్ సామర్ధ్యాలను కలిగి ఉంటాయి.';
$string['config_recording_description'] = 'ఈ సెట్టింగులు ఫీచర్ ప్రత్యేకమైనవి';
$string['config_recording_editable'] = 'రికార్డింగ్ ఫీచర్ సవరించవచ్చు';
$string['config_recording_editable_description'] = 'తనిఖీ చేస్తే ఇంటర్ఫేస్ రికార్డింగ్ ఫీచర్ ఎనేబుల్ మరియు డిసేబుల్ కోసం ఒక ఎంపికను కలిగి ఉంటుంది.';
$string['config_recordingready_enabled'] = 'రికార్డింగ్ సిద్ధంగా ఉన్నప్పుడు ఎనేబుల్ నోటిఫికేషన్లు';
$string['config_recordingready_enabled_description'] = 'సిద్ధంగా ఫీచర్ రికార్డింగ్ ఎనేబుల్ చేసినప్పుడు ప్రకటనలు.';
$string['config_recordings'] = '"రికార్డింగ్లను చూపు" ఫీచర్ కోసం కాన్ఫిగరేషన్';
$string['config_recordings_deleted_default'] = 'డిఫాల్ట్గా తొలగించిన కార్యాచరణల నుండి రికార్డింగ్లను చేర్చండి';
$string['config_recordings_deleted_default_description'] = 'ప్రారంభించబడితే, రికార్డింగ్ పట్టిక ఏవైనా ఉంటే తొలగించబడిన కార్యాచరణలకు సంబంధించిన రికార్డింగ్లను కలిగి ఉంటుంది.';
$string['config_recordings_deleted_editable'] = 'తొలగించిన కార్యాచరణల నుండి రికార్డింగ్లను చేర్చడం ఫీచర్ సవరించవచ్చు';
$string['config_recordings_deleted_editable_description'] = 'తొలగించిన కార్యక్రమాల నుండి డిఫాల్ట్గా రికార్డింగ్లను జోడించడం ఉదాహరణకు లేదా జోడించినప్పుడు సవరించవచ్చు.';
$string['config_recordings_description'] = 'ఈ సెట్టింగులు ఫీచర్ ప్రత్యేకమైనవి';
$string['config_recordings_general'] = 'రికార్డింగ్ సెట్టింగ్లను చూపు';
$string['config_recordings_general_description'] = 'రికార్డింగ్లను చూపించేటప్పుడు మాత్రమే ఈ సెట్టింగ్లు ఉపయోగించబడతాయి';
$string['config_recordings_imported_default'] = 'డిఫాల్ట్గా ప్రారంభించిన దిగుమతి లింక్లను మాత్రమే చూపించు';
$string['config_recordings_imported_default_description'] = 'ప్రారంభించబడితే, రికార్డింగ్ పట్టిక రికార్డింగ్లకు మాత్రమే దిగుమతి చేయబడిన లింక్లను కలిగి ఉంటుంది.';
$string['config_recordings_imported_editable'] = 'మాత్రమే దిగుమతి లింకులు ఫీచర్ సవరించవచ్చు చూపు';
$string['config_recordings_imported_editable_description'] = 'డిఫాల్ట్గా మాత్రమే దిగుమతి చేయబడిన లింక్లను ఉదాహరణకు జోడించినప్పుడు లేదా అప్డేట్ చేసినప్పుడు సవరించవచ్చు.';
$string['config_recordings_preview_default'] = 'ప్రివ్యూ డిఫాల్ట్గా ప్రారంభించబడింది';
$string['config_recordings_preview_default_description'] = 'ప్రారంభించబడితే పట్టికలో ప్రదర్శన యొక్క పరిదృశ్యం ఉంటుంది.';
$string['config_recordings_preview_editable'] = 'ప్రివ్యూ ఫీచర్ సవరించవచ్చు';
$string['config_recordings_preview_editable_description'] = 'ఉదాహరణకు జోడించబడిన లేదా అప్డేట్ అయినప్పుడు పరిదృశ్యం ఫీచర్ సవరించవచ్చు.';
$string['config_scheduled'] = '"షెడ్యూల్డ్ సెషన్ల" కోసం ఆకృతీకరణ';
$string['config_scheduled_description'] = 'ఈ సెట్టింగులు షెడ్యూల్ చేయబడిన సెషన్ల కోసం డిఫాల్ట్గా కొన్ని ప్రవర్తనను నిర్వచిస్తాయి.';
$string['config_scheduled_pre_opening'] = 'సమయం తెరిచే ముందు ప్రాప్యత (నిమిషాలు)';
$string['config_scheduled_pre_opening_description'] = 'షెడ్యూల్ ప్రారంభ సమయం ముందే సెషన్ కోసం సెకనులలో సమయం అయ్యేది.';
$string['config_server_url'] = 'BigBlueButton సర్వర్ URL';
$string['config_server_url_description'] = 'మీ BigBlueButton సర్వర్ యొక్క URL తప్పనిసరిగా / bigbluebutton / తో ముగియాలి. (ఈ డిఫాల్ట్ URL బ్లాండ్సైడ్ నెట్వర్క్స్ అందించిన BigBlueButton సర్వర్ కోసం మీరు పరీక్ష కోసం ఉపయోగించగలది.)';
$string['config_shared_secret'] = 'బిగ్బ్లిబట్టన్ షేర్డ్ సీక్రెట్';
$string['config_shared_secret_description'] = 'మీ BigBlueButton సర్వర్ యొక్క భద్రతా ఉప్పు. (ఈ డిఫాల్ట్ ఉప్పు బ్లైండ్సైడ్ నెట్వర్క్స్ అందించిన BigBlueButton సర్వర్కు మీరు పరీక్ష కోసం ఉపయోగించుకోవచ్చు.)';
$string['config_uidelegation_enabled'] = 'UI ప్రతినిధి బృందం ప్రారంభించబడింది';
$string['config_uidelegation_enabled_description'] = 'ఈ సెట్టింగులు BigBlueButton సర్వర్కు UI ప్రతినిధిని ఎనేబుల్ లేదా డిసేబుల్ చేస్తుంది.';
$string['config_userlimit'] = '"వినియోగదారు పరిమితి" లక్షణం కోసం ఆకృతీకరణ';
$string['config_userlimit_default'] = 'వినియోగదారు పరిమితి డిఫాల్ట్గా ప్రారంభించబడింది';
$string['config_userlimit_default_description'] = 'ఒక కొత్త గది లేదా సమావేశం జోడించినప్పుడు డిఫాల్ట్గా సెషన్లో అనుమతించిన వినియోగదారుల సంఖ్య. సంఖ్య 0 కి అమర్చబడితే, పరిమితి ఏదీ ఏర్పాటు చేయబడదు';
$string['config_userlimit_description'] = 'ఈ సెట్టింగులు UI లో ఎనేబుల్ లేదా డిసేబుల్ చేస్తాయి మరియు ఈ ఐచ్చికముల కొరకు డిఫాల్ట్ విలువలను కూడా నిర్వచించును.';
$string['config_userlimit_editable'] = 'యూజర్ పరిమితి ఫీచర్ సవరించవచ్చు';
$string['config_userlimit_editable_description'] = 'గది లేదా సమావేశం జోడించబడిన లేదా అప్డేట్ చేసినప్పుడు డిఫాల్ట్గా వినియోగదారు పరిమితి విలువ సవరించవచ్చు.';
$string['config_voicebridge'] = '"వాయిస్ బ్రిడ్జ్" ఫీచర్ కోసం ఆకృతీకరణ';
$string['config_voicebridge_description'] = 'ఈ సెట్టింగులు UI లో ఎనేబుల్ లేదా డిసేబుల్ చేస్తాయి మరియు ఈ ఐచ్చికముల కొరకు డిఫాల్ట్ విలువలను కూడా నిర్వచించును.';
$string['config_voicebridge_editable'] = 'కాన్ఫరెన్స్ వాయిస్ వంతెనను సవరించవచ్చు';
$string['config_voicebridge_editable_description'] = 'కాన్ఫరెన్స్ వాయిస్ బ్రిడ్జ్ నంబర్ను ఒక గది సమావేశానికి శాశ్వతంగా కేటాయించవచ్చు. కేటాయించినప్పుడు, ఆ సంఖ్యను ఏ ఇతర గది లేదా సమావేశంలో ఉపయోగించకూడదు';
$string['config_waitformoderator'] = '"మోడరేటర్ కోసం వేచి ఉండండి" లక్షణం కోసం కాన్ఫిగరేషన్';
$string['config_waitformoderator_cache_ttl'] = 'మోడరేటర్ కాష్ TTL (సెకన్లు) కోసం వేచి ఉండండి';
$string['config_waitformoderator_cache_ttl_description'] = 'ఖాతాదారుల భారీ లోడ్ మద్దతు ఈ ప్లగ్ఇన్ ఒక కాష్ ఉపయోగం చేస్తుంది. ఈ పారామితి బిగ్ బ్లూస్బటన్ సర్వర్కు తదుపరి అభ్యర్థన పంపబడుతుంది ముందు కాష్ ఉంచబడుతుంది సమయం నిర్వచిస్తుంది.';
$string['config_waitformoderator_default'] = 'డిఫాల్ట్గా మోడరేటర్ కోసం వేచి ఉండండి';
$string['config_waitformoderator_default_description'] = 'ఒక కొత్త గది లేదా సమావేశం జోడించబడినప్పుడు మోడరేటర్ ఫీచర్ కోసం వేచి ఉండండి.';
$string['config_waitformoderator_description'] = 'ఈ సెట్టింగులు ఫీచర్ ప్రత్యేకమైనవి';
$string['config_waitformoderator_editable'] = 'మోడరేటర్ ఫీచర్ కోసం సవరించవచ్చు';
$string['config_waitformoderator_editable_description'] = 'గది లేదా సమావేశం జోడించబడి లేదా అప్డేట్ చేసినప్పుడు డిఫాల్ట్గా మోడరేటర్ విలువ కోసం వేచి ఉండండి.';
$string['config_waitformoderator_ping_interval'] = 'మోడరేటర్ పింగ్ కోసం వేచి ఉండండి (సెకన్లు)';
$string['config_waitformoderator_ping_interval_description'] = 'మోడరేటర్ ఫీచర్ కోసం వేచి ఉన్నప్పుడు ఎనేబుల్, ప్రతి సెషన్ యొక్క సెషన్ కోసం క్లయింట్ పింగ్స్ ప్రతి. ఈ పారామిటర్ Moodle సర్వర్కు చేసిన అభ్యర్థనల కోసం విరామంని నిర్వచిస్తుంది';
$string['config_warning_bigbluebuttonbn_cfg_deprecated'] = 'BigBlueButtonBN ఖచ్ఛితమైన ప్రపంచ వేరియబుల్ తో config.php ఉపయోగించుకుంటోంది. దయచేసి భవిష్యత్తులో సంస్కరణలకు మద్దతివ్వని కారణంగా ఫైల్ను మార్చండి';
$string['config_warning_curl_not_installed'] = 'ఈ లక్షణానికి php ఇన్స్టాల్ మరియు ఎనేబుల్ కోసం వలయములుగా పొడిగింపు అవసరం. ఈ పరిస్థితి నెరవేరితే మాత్రమే సెట్టింగులు అందుబాటులో ఉంటాయి.';
$string['ends_at'] = 'ఎండ్స్';
$string['event_activity_created'] = 'BigBlueButtonBN కార్యాచరణ సృష్టించబడింది';
$string['event_activity_deleted'] = 'BigBlueButtonBN కార్యాచరణ తొలగించబడింది';
$string['event_meeting_created'] = 'BigBlueButtonBN సమావేశం సృష్టించబడింది';
$string['event_meeting_ended'] = 'BigBlueButtonBN సమావేశం బలవంతంగా ముగిసింది';
$string['event_meeting_joined'] = 'BigBlueButtonBN సమావేశం చేరింది';
$string['event_meeting_left'] = 'BigBlueButtonBN సమావేశం మిగిలి ఉంది';
$string['event_recording_deleted'] = 'రికార్డింగ్ తొలగించబడింది';
$string['event_recording_imported'] = 'రికార్డింగ్ దిగుమతి చేయబడింది';
$string['event_recording_published'] = 'రికార్డింగ్ ప్రచురించబడింది';
$string['event_recording_unpublished'] = 'రికార్డింగ్ ప్రచురించలేదు';
$string['general_error_unable_connect'] = 'అందుకోలేక పోతున్నాము. BigBlueButton సర్వర్ యొక్క url ను తనిఖీ చేసి, BigBlueButton సర్వర్ అమలు అవుతుందో లేదో తనిఖీ చేయండి.';
$string['index_confirm_end'] = 'వర్చ్యువల్ తరగతిని మీరు ముగించాలనుకుంటున్నారా?';
$string['index_disabled'] = 'వికలాంగ';
$string['index_enabled'] = 'ఎనేబుల్';
$string['index_ending'] = 'వర్చ్యువల్ తరగతిలో ఎండింగ్ ... దయచేసి వేచి ఉండండి';
$string['index_error_checksum'] = 'చెక్సమ్ లోపం సంభవించింది. మీరు సరైన ఉప్పులో ఉందని నిర్ధారించుకోండి.';
$string['index_error_forciblyended'] = 'ఈ సమావేశంలో చేరడం సాధ్యం కాదు ఎందుకంటే అది మాన్యువల్గా ముగిసింది.';
$string['index_error_unable_display'] = 'సమావేశాలను ప్రదర్శించడం సాధ్యం కాలేదు. BigBlueButton సర్వర్ యొక్క url ను తనిఖీ చేసి, BigBlueButton సర్వర్ అమలు అవుతుందో లేదో తనిఖీ చేయండి.';
$string['index_heading'] = 'బిగ్ బ్లూస్బటన్ రూములు';
$string['index_heading_actions'] = 'చర్యలు';
$string['index_heading_group'] = 'గ్రూప్';
$string['index_heading_moderator'] = 'మధ్యవర్తులు';
$string['index_heading_name'] = 'గది';
$string['index_heading_recording'] = 'రికార్డింగ్';
$string['index_heading_users'] = 'వినియోగదారులు';
$string['index_heading_viewer'] = 'వీక్షకులు';
$string['instance_type_default'] = 'రికార్డింగ్లతో రూమ్ / కార్యాచరణ';
$string['instance_type_recording_only'] = 'రికార్డింగ్లు మాత్రమే';
$string['instance_type_room_only'] = 'గది / కార్యాచరణ మాత్రమే';
$string['mod_form_block_general'] = 'సాధారణ సెట్టింగులు';
$string['mod_form_block_participants'] = 'పాల్గొనేవారు';
$string['mod_form_block_presentation'] = 'ప్రెజెంటేషన్ కంటెంట్';
$string['mod_form_block_record'] = 'రికార్డ్ సెట్టింగ్లు';
$string['mod_form_block_recordings'] = 'రికార్డింగ్ సెట్టింగ్లు';
$string['mod_form_block_room'] = 'కార్యాచరణ / గది అమరికలు';
$string['mod_form_block_schedule'] = 'సెషన్ కోసం షెడ్యూల్';
$string['mod_form_field_closingtime'] = 'మూసివేయండి చేరండి';
$string['mod_form_field_conference_name'] = 'కాన్ఫరెన్స్ పేరు';
$string['mod_form_field_duration'] = 'వ్యవధి';
$string['mod_form_field_duration_help'] = 'సమావేశానికి వ్యవధిని ఏర్పాటు చేయడం వలన రికార్డింగ్ ముగింపుకు ముందు సజీవంగా ఉంచడానికి సమావేశానికి గరిష్ట సమయం ఏర్పడుతుంది';
$string['mod_form_field_instanceprofiles'] = 'ఇన్స్టాన్స్ రకం';
$string['mod_form_field_instanceprofiles_help'] = 'ఈ BigBlueButtonBN ఉదాహరణ కోసం రకాన్ని ఎంచుకోండి.';
$string['mod_form_field_intro'] = 'వివరణ';
$string['mod_form_field_intro_help'] = 'గది లేదా సమావేశానికి ఒక చిన్న వివరణ.';
$string['mod_form_field_name'] = 'వర్చువల్ తరగతిలో పేరు';
$string['mod_form_field_openingtime'] = 'ఓపెన్ చేరండి';
$string['mod_form_field_participant_add'] = 'పాల్గొనేవారిని జోడించండి';
$string['mod_form_field_participant_bbb_role_moderator'] = 'మోడరేటర్';
$string['mod_form_field_participant_bbb_role_viewer'] = 'వ్యూయర్';
$string['mod_form_field_participant_list'] = 'పాల్గొనే జాబితా';
$string['mod_form_field_participant_list_action_add'] = 'చేర్చు';
$string['mod_form_field_participant_list_action_remove'] = 'తొలగించు';
$string['mod_form_field_participant_list_text_as'] = 'వంటి';
$string['mod_form_field_participant_list_type_all'] = 'అన్ని వినియోగదారులు చేరాడు';
$string['mod_form_field_participant_list_type_owner'] = 'యజమాని';
$string['mod_form_field_participant_list_type_role'] = 'పాత్ర';
$string['mod_form_field_participant_list_type_user'] = 'వాడుకరి';
$string['mod_form_field_record'] = 'సెషన్ రికార్డ్ చేయబడుతుంది';
$string['mod_form_field_recordings_deleted'] = 'తొలగించిన కార్యాచరణల నుండి రికార్డింగ్లను చేర్చండి';
$string['mod_form_field_recordings_html'] = 'సాదా html లో పట్టికను చూపించు';
$string['mod_form_field_recordings_imported'] = 'దిగుమతి చేసిన లింక్లను మాత్రమే చూపించు';
$string['mod_form_field_recordings_preview'] = 'రికార్డింగ్ పరిదృశ్యాన్ని చూపు';
$string['mod_form_field_room_name'] = 'గది పేరు';
$string['mod_form_field_userlimit'] = 'వాడుకరి పరిమితి';
$string['mod_form_field_userlimit_help'] = 'సమావేశంలో అనుమతించిన వినియోగదారుల గరిష్ట పరిమితి. పరిమితి 0 కు సెట్ చేయబడితే వినియోగదారుల సంఖ్య అపరిమితంగా ఉంటుంది.';
$string['mod_form_field_voicebridge'] = 'వాయిస్ బ్రిడ్జ్ [####]';
$string['mod_form_field_voicebridge_format_error'] = 'ఫార్మాట్ లోపం. మీరు 1 మరియు 9999 మధ్య సంఖ్యను ఇన్పుట్ చేయాలి.';
$string['mod_form_field_voicebridge_help'] = 'వాయిస్ కాన్ఫరెన్స్ నంబర్, పాల్గొనేవారు వాయిస్ సమావేశంలో చేరడానికి ప్రవేశిస్తారు. 1 మరియు 9999 మధ్య ఉన్న సంఖ్యను టైప్ చేయాలి. విలువ 0 ఉంటే స్టాటిక్ వాయిస్బ్రిడ్జ్ సంఖ్య విస్మరించబడుతుంది మరియు ఒక యాదృచ్ఛిక సంఖ్య బిగ్బ్లూబటన్ ద్వారా ఉత్పత్తి అవుతుంది. సంఖ్య 7 టైప్ చేసిన నాలుగు అంకెలకు ముందు ఉంటుంది';
$string['mod_form_field_voicebridge_notunique_error'] = 'ఒక ప్రత్యేక విలువ కాదు. ఈ సంఖ్య మరొక గది లేదా సమావేశంలో ఉపయోగించబడుతోంది.';
$string['mod_form_field_wait'] = 'మోడరేటర్ కోసం వేచి ఉండండి';
$string['mod_form_field_wait_help'] = 'వారు అలా చేయటానికి ముందు మోడరేటర్ సెషన్లోకి ప్రవేశించే వరకు వీక్షకులు వేచి ఉండాలి';
$string['mod_form_field_welcome'] = 'స్వాగతం సందేశం';
$string['mod_form_field_welcome_default'] = '<br> <b>% CONFNAME %% </ b> కు స్వాగతం! <br> <br> బిగ్బ్లీబటన్ను ఉపయోగించడంలో సహాయం కోసం ఈ (చిన్న) <a href = "ఈవెంట్ చూడండి: http: //www.bigbluebutton.org / content / videos "> <u> ట్యుటోరియల్ వీడియోలు </ u> </a>. <br> <br> ఆడియో వంతెనలో చేరడానికి ఫోన్ చిహ్నం (టాప్ సెంటర్) క్లిక్ చేయండి. <b> ఇతరులకు నేపథ్య శబ్దం కలిగించకుండా ఉండటానికి దయచేసి హెడ్సెట్ను ఉపయోగించండి. </ b>';
$string['mod_form_field_welcome_help'] = 'BigBlueButton సర్వర్ కోసం సెట్ చేయబడిన డిఫాల్ట్ సందేశాన్ని భర్తీ చేస్తుంది. సందేశంలో స్వయంచాలకంగా ప్రత్యామ్నాయం చేయబడే కీలక పదాలను (%% CONFNAME %%, %% DIALNUM %%, %% CONFNUM %%) కలిగి ఉంటుంది మరియు <b> ... </ b> లేదా <i> < / i>';
$string['modulename'] = 'BigBlueButtonBN';
$string['modulename_help'] = 'BigBlueButtonBN మీరు Moodle లింక్ ల నుండి రియల్-ఆన్ ఆన్-లైన్ క్లాస్ రూమ్స్ నుండి BigBlueButton ను ఉపయోగించి, దూర విద్య కోసం ఒక ఓపెన్ సోర్స్ వెబ్ కాన్ఫరెన్సింగ్ వ్యవస్థను రూపొందించడానికి అనుమతిస్తుంది.

BigBlueButtonBN ని ఉపయోగించడం ద్వారా టైటిల్, వివరణ, క్యాలెండర్ ఎంట్రీ (ఇది సెషన్లో చేరడానికి తేదీ పరిధిని ఇస్తుంది), సమూహాలు మరియు ఆన్-లైన్ సెషన్ యొక్క రికార్డింగ్ గురించి వివరాలను మీరు పేర్కొనవచ్చు.

తరువాత రికార్డింగ్లను వీక్షించడానికి, ఈ కోర్సుకు RecordingsBN వనరును జోడించండి.';
$string['modulename_link'] = 'BigBlueButton/view';
$string['modulenameplural'] = 'BigBlueButtonBN';
$string['pluginadministration'] = 'బిగ్ బ్లూస్బటన్ పరిపాలన';
$string['pluginname'] = 'BigBlueButtonBN';
$string['privacy:metadata:bigbluebutton'] = 'BigBlueButton సెషన్లను సృష్టించడానికి మరియు చేరడానికి, యూజర్ డేటా సర్వర్తో మార్పిడి చేయాలి.';
$string['privacy:metadata:bigbluebutton:fullname'] = 'BigBlueButton సర్వర్ యాక్సెస్ యూజర్ యొక్క పూర్తి పేరు.';
$string['privacy:metadata:bigbluebutton:userid'] = 'BigBlueButton సర్వర్ యాక్సెస్ యూజర్ యొక్క వినియోగదారు.';
$string['privacy:metadata:bigbluebuttonbn'] = 'BigBlueButton సెషన్ యొక్క లక్షణాలను మరియు సాధారణ ప్రవర్తనను నిర్వచిస్తున్న గది లేదా కార్యాచరణ కోసం కాన్ఫిగరేషన్ను నిల్వ చేస్తుంది.';
$string['privacy:metadata:bigbluebuttonbn:participants'] = 'పాత్రికేయులు ప్రత్యక్ష సమావేశాల్లో నిర్వచించే నియమాల జాబితా. ఒక్కొక్క పాత్రకు లేదా వినియోగదారుకు అనుమతులను మంజూరు చేయగలిగేటప్పుడు వినియోగదారు ID ని భద్రపరచవచ్చు.';
$string['privacy:metadata:bigbluebuttonbn_logs'] = 'ప్లగ్ఇన్ ఉపయోగించేటప్పుడు దుకాణాలు ఈవెంట్స్ ప్రేరేపించాయి.';
$string['privacy:metadata:bigbluebuttonbn_logs:log'] = 'వినియోగదారుచే ప్రేరేపించబడిన ఈవెంట్ రకం.';
$string['privacy:metadata:bigbluebuttonbn_logs:meetingid'] = 'యూజర్ యాక్సెస్ సమావేశం ID.';
$string['privacy:metadata:bigbluebuttonbn_logs:meta'] = 'సమావేశానికి సంబంధించిన అదనపు సమాచారం లేదా కార్యక్రమంలో కనుగొనబడిన రికార్డింగ్ను చేర్చండి.';
$string['privacy:metadata:bigbluebuttonbn_logs:timecreated'] = 'లాగ్ సృష్టించిన సమయం.';
$string['privacy:metadata:bigbluebuttonbn_logs:userid'] = 'ఈవెంట్ ప్రేరేపించిన యూజర్ యొక్క వినియోగదారు ID.';
$string['started_at'] = 'ప్రారంభ';
$string['starts_at'] = 'ప్రారంభమయ్యేది';
$string['view_conference_action_end'] = 'ముగింపు సెషన్';
$string['view_conference_action_join'] = 'సెషన్లో చేరండి';
$string['view_error_action_not_completed'] = 'చర్య పూర్తి కాలేదు';
$string['view_error_bigbluebutton'] = 'BigBlueButton లోపాలతో స్పందించింది. {$a}';
$string['view_error_create'] = 'BigBlueButton సర్వర్ ఒక దోష సందేశంతో స్పందించింది, సమావేశం సృష్టించబడలేదు.';
$string['view_error_current_state_not_found'] = 'ప్రస్తుత స్థితి కనుగొనబడలేదు. రికార్డింగ్ తొలగించబడి ఉండవచ్చు లేదా BigBlueButton సర్వర్ నిర్వహించిన చర్యతో అనుకూలంగా లేదు.';
$string['view_error_import_no_courses'] = 'రికార్డింగ్ల కోసం వెతకటం లేదు';
$string['view_error_import_no_recordings'] = 'దిగుమతి కోసం ఈ కోర్సులో రికార్డింగ్లు లేవు';
$string['view_error_invalid_session'] = 'సెషన్ గడువు ముగిసింది. కార్యాచరణ ప్రధాన పేజీకి తిరిగి వెళ్లండి.';
$string['view_error_max_concurrent'] = 'అనుమతించిన ఉభయ సభల సంఖ్యను చేరుకున్నారు.';
$string['view_error_meeting_not_running'] = 'ఏదో తప్పు జరిగింది, సమావేశం అమలులో లేదు.';
$string['view_error_no_group'] = 'గుంపులు ఇంకా కన్ఫిగర్ కాలేదు. దయచేసి సమావేశంలో చేరడానికి ప్రయత్నించే ముందు సమూహాలను సెటప్ చేయండి.';
$string['view_error_no_group_student'] = 'మీరు సమూహంలో నమోదు కాలేదు. దయచేసి మీ గురువు లేదా నిర్వాహకుడిని సంప్రదించండి.';
$string['view_error_no_group_teacher'] = 'గుంపులు ఇంకా కన్ఫిగర్ కాలేదు. దయచేసి సమూహాలను సెటప్ చెయ్యండి లేదా నిర్వాహకుడిని సంప్రదించండి.';
$string['view_error_unable_join'] = 'సమావేశంలో చేరడం సాధ్యం కాలేదు. BigBlueButton సర్వర్ యొక్క url ను తనిఖీ చేసి, BigBlueButton సర్వర్ అమలు అవుతుందో లేదో తనిఖీ చేయండి.';
$string['view_error_unable_join_student'] = 'BigBlueButton సర్వర్కు కనెక్ట్ చేయడం సాధ్యం కాలేదు. దయచేసి మీ గురువు లేదా నిర్వాహకుడిని సంప్రదించండి.';
$string['view_error_unable_join_teacher'] = 'BigBlueButton సర్వర్కు కనెక్ట్ చేయడం సాధ్యం కాలేదు. దయచేసి నిర్వాహకుడిని సంప్రదించండి.';
$string['view_error_url_missing_parameters'] = 'ఈ URL లో పారామితులు లేవు';
$string['view_error_userlimit_reached'] = 'సమావేశంలో అనుమతించిన వినియోగదారుల సంఖ్య చేరింది.';
$string['view_groups_nogroups_warning'] = 'గది సమూహాలను ఉపయోగించడం కోసం కాన్ఫిగర్ చేయబడింది కానీ కోర్సులో గారు నిర్వచించబడలేదు.';
$string['view_groups_notenrolled_warning'] = 'గది సమూహాలను ఉపయోగించడం కోసం కాన్ఫిగర్ చేయబడింది కానీ మీరు వాటిలో దేనిలోనూ నమోదు చేయబడలేదు.';
$string['view_groups_selection'] = 'మీరు చేరాలనుకుంటున్న సమూహాన్ని ఎంచుకొని, చర్యను నిర్ధారించండి';
$string['view_groups_selection_join'] = 'చేరండి';
$string['view_groups_selection_warning'] = 'ప్రతి సమూహం కోసం ఒక సమావేశ గది ఉంది మరియు మీకు ఒకటి కంటే ఎక్కువ ప్రాప్యత ఉంది. సరైనదాన్ని ఎంచుకోండి నిర్ధారించుకోండి.';
$string['view_login_moderator'] = 'మోడరేటర్గా లాగింగ్ ...';
$string['view_login_viewer'] = 'వీక్షకునిగా లాగింగ్ ..';
$string['view_message_conference_has_ended'] = 'ఈ సమావేశం ముగిసింది.';
$string['view_message_conference_in_progress'] = 'ఈ సమావేశం జరుగుతోంది.';
$string['view_message_conference_not_started'] = 'ఈ సమావేశం ఇంకా ప్రారంభించబడలేదు.';
$string['view_message_conference_room_ready'] = 'ఈ సమావేశ గది సిద్ధంగా ఉంది. మీరు ఇప్పుడు సెషన్లో చేరవచ్చు.';
$string['view_message_conference_wait_for_moderator'] = 'మోడరేటర్ చేరడానికి వేచి ఉన్నారు.';
$string['view_message_finished'] = 'ఈ చర్య ముగిసింది.';
$string['view_message_has_joined'] = 'చేరారు';
$string['view_message_have_joined'] = 'చేరారు';
$string['view_message_hour'] = 'గంట';
$string['view_message_hours'] = 'గంటల';
$string['view_message_importrecordings_disabled'] = 'ఈ సర్వర్లో దిగుమతి రికార్డింగ్ లింక్ల కోసం ఫీచర్ నిలిపివేయబడింది.';
$string['view_message_minute'] = 'నిమిషం';
$string['view_message_minutes'] = 'నిమిషాల';
$string['view_message_moderator'] = 'మధ్యవర్తి';
$string['view_message_moderators'] = 'మోడరేటర్లు';
$string['view_message_norecordings'] = 'చూపించడానికి రికార్డింగ్ ఏదీ లేదు.';
$string['view_message_notavailableyet'] = 'ఈ సెషన్ ఇంకా అందుబాటులో లేదు.';
$string['view_message_recordings_disabled'] = 'ఈ సర్వర్లో రికార్డింగ్లు నిలిపివేయబడ్డాయి. రికార్డింగ్ల కోసం బిగ్ బ్లూస్బటన్ BN ఉదాహరణలు మాత్రమే ఉపయోగించబడవు.';
$string['view_message_room_closed'] = 'ఈ గది మూసివేయబడింది.';
$string['view_message_room_open'] = 'ఈ గది తెరిచి ఉంది.';
$string['view_message_room_ready'] = 'ఈ గది సిద్ధంగా ఉంది';
$string['view_message_session_for'] = 'కోసం సెషన్';
$string['view_message_session_has_user'] = 'అక్కడ ఉంది';
$string['view_message_session_has_users'] = 'ఉన్నాయి';
$string['view_message_session_no_users'] = 'ఈ సెషన్లో వినియోగదారులు లేరు';
$string['view_message_session_running_for'] = 'ఈ సెషన్ కోసం నడుస్తోంది';
$string['view_message_session_started_at'] = 'ఈ సెషన్ ప్రారంభమైంది';
$string['view_message_tab_close'] = 'ఈ టాబ్ / విండో మానవీయంగా మూసివేయాలి';
$string['view_message_times'] = 'సార్లు';
$string['view_message_user'] = 'యూజర్';
$string['view_message_users'] = 'వినియోగదారులు';
$string['view_message_viewer'] = 'వీక్షకుడు';
$string['view_message_viewers'] = 'వీక్షకులు';
$string['view_noguests'] = 'BigBlueButtonBN అతిథులకు తెరవబడదు';
$string['view_nojoin'] = 'మీరు ఈ సెషన్లో చేరడానికి అనుమతి ఉన్న పాత్రలో లేరు.';
$string['view_recording'] = 'రికార్డింగ్';
$string['view_recording_actionbar'] = 'ఉపకరణపట్టీ';
$string['view_recording_activity'] = 'కార్యాచరణ';
$string['view_recording_button_import'] = 'రికార్డింగ్ లింక్లను దిగుమతి చేయండి';
$string['view_recording_button_return'] = 'వెనక్కి వెళ్ళు';
$string['view_recording_course'] = 'కోర్సు';
$string['view_recording_date'] = 'తేదీ';
$string['view_recording_delete_confirmation'] = 'మీరు దీన్ని {$a} ని ఖచ్చితంగా తొలగించాలా?';
$string['view_recording_delete_confirmation_warning_p'] = 'ఈ రికార్డింగ్ విభిన్న కోర్సులు లేదా కార్యకలాపాలలో దిగుమతి చేయబడిన {$ a} లింక్లను కలిగి ఉంది. రికార్డింగ్ తొలగించబడితే ఆ లింకులు తొలగించబడతాయి';
$string['view_recording_delete_confirmation_warning_s'] = 'ఈ రికార్డింగ్ వేరే కోర్సు లేదా కార్యాచరణలో దిగుమతి అయిన {$ a} లింక్ అనుబంధం ఉంది. రికార్డింగ్ తొలగించబడినట్లయితే ఆ లింక్ కూడా తీసివేయబడుతుంది';
$string['view_recording_description'] = 'వివరణ';
$string['view_recording_duration'] = 'వ్యవధి';
$string['view_recording_duration_min'] = 'min';
$string['view_recording_format_presentation'] = 'ప్రదర్శన';
$string['view_recording_format_statistics'] = 'గణాంకాలు';
$string['view_recording_format_video'] = 'వీడియో';
$string['view_recording_import_confirmation'] = 'మీరు ఈ రికార్డింగ్ను ఖచ్చితంగా దిగుమతి చేస్తున్నారా?';
$string['view_recording_length'] = 'పొడవు';
$string['view_recording_link_warning'] = 'వేరొక కోర్సు లేదా కార్యాచరణలో సృష్టించబడిన రికార్డింగ్కు ఇది లింక్';
$string['view_recording_list_action_delete'] = 'తొలగిస్తోంది';
$string['view_recording_list_action_edit'] = 'నవీకరిస్తోంది';
$string['view_recording_list_action_play'] = 'ప్లే';
$string['view_recording_list_action_process'] = 'ప్రోసెసింగ్';
$string['view_recording_list_action_protect'] = 'పరిరక్షించటం';
$string['view_recording_list_action_publish'] = 'ప్రచురణ';
$string['view_recording_list_action_unprotect'] = 'Unprotecting';
$string['view_recording_list_action_unpublish'] = 'ప్రచురణ తీసివేయడం';
$string['view_recording_list_action_update'] = 'నవీకరిస్తోంది';
$string['view_recording_list_actionbar'] = 'ఉపకరణపట్టీ';
$string['view_recording_list_actionbar_delete'] = 'తొలగించు';
$string['view_recording_list_actionbar_edit'] = 'మార్చు';
$string['view_recording_list_actionbar_hide'] = 'దాచు';
$string['view_recording_list_actionbar_import'] = 'దిగుమతి';
$string['view_recording_list_actionbar_protect'] = 'దీన్ని ప్రైవేట్గా చేయండి';
$string['view_recording_list_actionbar_publish'] = 'ప్రచురించు';
$string['view_recording_list_actionbar_show'] = 'షో';
$string['view_recording_list_actionbar_unprotect'] = 'దీన్ని పబ్లిక్గా చేయండి';
$string['view_recording_list_actionbar_unpublish'] = 'ప్రచురించని';
$string['view_recording_list_activity'] = 'కార్యాచరణ';
$string['view_recording_list_course'] = 'కోర్సు';
$string['view_recording_list_date'] = 'తేదీ';
$string['view_recording_list_description'] = 'వివరణ';
$string['view_recording_list_duration'] = 'వ్యవధి';
$string['view_recording_list_recording'] = 'రికార్డింగ్';
$string['view_recording_modal_button'] = 'వర్తించు';
$string['view_recording_modal_title'] = 'రికార్డింగ్ కోసం విలువలను సెట్ చేయండి';
$string['view_recording_name'] = 'పేరు';
$string['view_recording_playback'] = 'ప్లేబ్యాక్';
$string['view_recording_preview'] = 'ప్రివ్యూ';
$string['view_recording_preview_help'] = 'పూర్తి పరిమాణంలో వీక్షించడానికి ఒక చిత్రంపై కర్సర్ ఉంచండి';
$string['view_recording_publish_link_deleted'] = 'ఈ లింక్ ప్రస్తుత ప్రచురణ సాధ్యం కాదు ఎందుకంటే ప్రస్తుత బిగ్బ్లేబటన్ సర్వర్లో అసలు రికార్డింగ్ ఉనికిలో లేదు. లింక్ తీసివేయబడాలి.';
$string['view_recording_publish_link_not_published'] = 'అసలైన రికార్డింగ్ ప్రచురించబడనందున ఈ లింక్ మళ్లీ ప్రచురించబడదు';
$string['view_recording_recording'] = 'రికార్డింగ్';
$string['view_recording_tags'] = 'టాగ్లు';
$string['view_recording_unprotect_link_deleted'] = 'ప్రస్తుత లింక్ పెద్ద BlueButton సర్వర్లో అసలు రికార్డింగ్ ఉండనందున ఈ లింక్ను రక్షించబడలేదు. లింక్ తీసివేయబడాలి.';
$string['view_recording_unprotect_link_not_unprotected'] = 'అసలు లింక్ భద్రపరచబడినందున ఈ లింక్ను రక్షించబడలేదు';
$string['view_recording_unpublish_confirmation'] = 'మీరు దీన్ని {$a} ప్రచురించడాన్ని ఖచ్చితంగా ప్రచురించుకుంటున్నారా?';
$string['view_recording_unpublish_confirmation_warning_p'] = 'ఈ రికార్డింగ్ విభిన్న కోర్సులు లేదా కార్యకలాపాలలో దిగుమతి చేయబడిన {$ a} లింక్లను కలిగి ఉంది. రికార్డింగ్ ప్రచురించబడకపోతే ఆ లింకులు కూడా ప్రచురించబడవు';
$string['view_recording_unpublish_confirmation_warning_s'] = 'ఈ రికార్డింగ్ వేరే కోర్సు లేదా కార్యాచరణలో దిగుమతి అయిన {$ a} లింక్ అనుబంధం ఉంది. రికార్డింగ్ ప్రచురించబడనట్లయితే ఆ లింక్ కూడా ప్రచురించబడదు';
$string['view_section_title_presentation'] = 'ప్రెజెంటేషన్ ఫైల్';
$string['view_section_title_recordings'] = 'రికార్డింగ్స్';
$string['view_warning_default_server'] = 'ఈ మూడ్ల సర్వర్ అప్రమేయంగా ముందే కాన్ఫిగర్ చేయబడిన BigBlueButton పరీక్ష సర్వర్ని ఉపయోగిస్తుంది. ఇది ఉత్పత్తి కోసం భర్తీ చేయాలి.';
