<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'backup', language 'te', version '4.3'.
 *
 * @package     backup
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['autoactivedescription'] = 'స్వయంచాలక బ్యాకప్ చేయవలెనో లేదో ఎంచుకోండి. మాన్యువల్ ఎంపిక చేస్తే స్వయంచాలక బ్యాకప్ లు  స్వయంచాలక బ్యాకప్ CLI స్క్రిప్ట్ ద్వారా మాత్రమే సాధ్యమవుతుంది. ఈ కమాండ్ లైన్ లేదా క్రాన్ ద్వారా గాని మాన్యువల్ గా చేయవచ్చు.';
$string['autoactivedisabled'] = 'డిసేబుల్';
$string['autoactiveenabled'] = 'ప్రారంభించబడింది';
$string['autoactivemanual'] = '';
$string['automatedbackupschedule'] = 'వివరాల జాబితా';
$string['automatedbackupschedulehelp'] = 'ఆటోమాటిక్ బ్యాకప్పులు వారంలో ఏయే రోజుల్లో తీయాలో ఎంచుకోండి.';
$string['automatedbackupsinactive'] = 'షెడ్యూల్డు బ్యాకప్పులను సైటు నిర్వాహకుడు చేతనం చెయ్యలేదు';
$string['automatedbackupstatus'] = 'ఆటోమేటెడ్ బ్యాకప్ స్థితి';
$string['automateddeletedays'] = 'పాత కంటే బ్యాకప్లను తొలగించండి';
$string['automatedmaxkept'] = 'గరిష్ట సంఖ్య బ్యాకప్లు ఉంచబడ్డాయి';
$string['automatedmaxkepthelp'] = 'ఇది ప్రతి కోర్సు కోసం ఇటీవలి ఆటోమేటెడ్ బ్యాకప్ యొక్క గరిష్ట సంఖ్యను ఉంచడానికి నిర్దేశిస్తుంది. పాత బ్యాకప్లు స్వయంచాలకంగా తొలగించబడతాయి.';
$string['automatedminkept'] = 'బ్యాకప్ల కనీస సంఖ్య ఉంచబడింది';
$string['automatedminkepthelp'] = 'నిర్దిష్ట రోజుల సంఖ్య కంటే పాత బ్యాకప్లు తొలగించబడితే, అది బ్యాక్ అప్ తో నిష్క్రియాత్మక కోర్సు ముగుస్తుంది. దీనిని నివారించడానికి, కనీస బ్యాక్ అప్లను ఉంచాలి.';
$string['automatedsettings'] = 'ఆటోమేటెడ్ బ్యాకప్ సెట్టింగులు';
$string['automatedsetup'] = 'ఆటోమేటెడ్ బ్యాకప్ సెటప్';
$string['automatedstorage'] = 'ఆటోమేటెడ్ బ్యాకప్ స్టోరేజ్';
$string['automatedstoragehelp'] = 'ఆటొమేటిక్ గా జరిగే బ్యాకప్ లు నిల్వ ఉంచు స్థానమును ఎంచుకోండి';
$string['backupactivity'] = 'బ్యాకప్ కార్యాచరణ: {$a}';
$string['backupcourse'] = 'బ్యాకప్ కోర్సు : {$a}';
$string['backupcoursedetails'] = 'కోర్సు యొక్క వివరాలు';
$string['backupcoursesection'] = 'విభాగం: {$ a}';
$string['backupcoursesections'] = 'కోర్సు విభాగాలు';
$string['backupdate'] = 'తీసుకున్న తేదీ';
$string['backupdetails'] = 'Backup details';
$string['backupdetailsnonstandardinfo'] = 'ఎంచుకున్న ఫైల్ ప్రామాణిక మూడుల్ బ్యాకప్ ఫైల్ కాదు. పునరుద్ధరణ ప్రక్రియ బ్యాకప్ ఫైల్ ను ప్రామాణిక ఫార్మాట్ లోకి మార్చుటకు ప్రయత్నిస్తుంది
మరియు తరువాత ఆ ఫైలు పునరుద్ధరణకు ప్రయత్నం చేస్తుంది';
$string['backupformat'] = 'ఫార్మాట్';
$string['backupformatimscc1'] = 'IMS సామాన్య కాట్రిడ్జ్ 1.0';
$string['backupformatimscc11'] = 'IMS సామాన్య కాట్రిడ్జ్ 1.1';
$string['backupformatmoodle1'] = 'మూడుల్ 1';
$string['backupformatmoodle2'] = 'మూడుల్ 2';
$string['backupformatunknown'] = 'తెలియని ఫార్మాట్';
$string['backuplog'] = 'సాంకేతిక సమాచారం మరియు హెచ్చరికలు';
$string['backupmode'] = '';
$string['backupmode10'] = 'సాధారణంగా';
$string['backupmode20'] = 'దిగుమతి';
$string['backupmode30'] = 'స్థావరంలో';
$string['backupmode40'] = 'ఒకే సైట్';
$string['backupmode50'] = 'ఆటోమేటెడ్';
$string['backupmode60'] = 'మార్పిడి చేయబడిన';
$string['backupsection'] = 'బ్యాకప్ కోర్సు విభాగం: {$ a}';
$string['backupsettings'] = 'బ్యాకప్ సెట్టింగులు';
$string['backupsitedetails'] = 'సైట్ వివరాలు';
$string['backupstage16action'] = 'కొనసాగించు';
$string['backupstage1action'] = 'తర్వాత';
$string['backupstage2action'] = 'తర్వాత';
$string['backupstage4action'] = 'బ్యాకప్ జరుపుటకు';
$string['backupstage8action'] = 'కొనసాగించు';
$string['backuptype'] = 'రకము';
$string['backuptypeactivity'] = 'యాక్టివిటీ';
$string['backuptypecourse'] = 'కోర్సు';
$string['backuptypesection'] = 'విభాగము';
$string['backupversion'] = 'బ్యాకప్ వెర్షన్';
$string['cannotfindassignablerole'] = 'బ్యాకప్ ఫైల్ లో {$ a}  పాత్రను మీరు మ్యాప్ చేయుటకు అనుమతించబడే  ఏ పాత్రలకు మ్యాప్ చేయబడదు.';
$string['choosefilefromactivitybackup'] = 'యాక్టివిటీ బ్యాకప్ ఏరియ';
$string['choosefilefromactivitybackup_help'] = 'బ్యాకప్ కార్యకలాపాలు డిఫాల్ట్ అమర్పులను ఉపయోగించి ఉన్నప్పుడు, బ్యాకప్ ఫైళ్లు ఇక్కడ నిల్వ చేయబడతాయి';
$string['choosefilefromautomatedbackup'] = 'స్వయంచాలక బ్యాకప్ లు';
$string['choosefilefromautomatedbackup_help'] = 'స్వయంచాలకంగా రూపొందించబడిన బ్యాకప్ లు ఉంటాయి.';
$string['choosefilefromcoursebackup'] = 'కోర్సు బ్యాకప్ ఏరియ';
$string['choosefilefromcoursebackup_help'] = 'బ్యాకప్  కోర్సులు డిఫాల్ట్ అమర్పులను ఉపయోగించి ఉన్నప్పుడు, బ్యాకప్ ఫైళ్లు ఇక్కడ నిల్వ చేయబడతాయి';
$string['choosefilefromuserbackup'] = 'వాడుకరి ప్రైవేట్ బ్యాకప్ ఏరియ';
$string['choosefilefromuserbackup_help'] = 'బ్యాకప్ కోర్సుల్లో "అజ్ఞాతంగా యూజర్ సమాచారం" ఎంపిక tick ఉన్నప్పుడు, బ్యాకప్ ఫైళ్లను ఇక్కడ నిల్వ చేస్తుంది';
$string['config_keep_groups_and_groupings'] = 'అప్రమేయంగా ప్రస్తుత సమూహాలు మరియు సమూహాలను ఉంచండి.';
$string['config_keep_roles_and_enrolments'] = 'అప్రమేయంగా ప్రస్తుత పాత్రలు మరియు నమోదులను ఉంచండి.';
$string['config_overwrite_conf'] = 'ప్రస్తుత కోర్సు ఆకృతీకరణను ఓవర్రైట్ చేయడానికి యూజర్ని అనుమతిస్తుంది';
$string['config_overwrite_course_fullname'] = 'అప్రమేయంగా కోర్సు పూర్తి పేరును బ్యాకప్ ఫైల్ నుండి ఒకదానితో భర్తీ చేస్తుంది. దీనికి "ఓవర్రైట్ కోర్సు కాన్ఫరెన్స్" తనిఖీ చేయాలి మరియు ప్రస్తుత యూజర్ కోర్సు పూర్తి పేరు మార్చడానికి సామర్ధ్యం కలిగి ఉండాలి (moodle / course: changefullname)';
$string['config_overwrite_course_shortname'] = 'బ్యాకప్ ఫైల్ నుండి ఒకదానితో డిఫాల్ట్ గా కోర్సు చిన్న పేరును భర్తీ చేస్తుంది. దీనికి "ఓవర్రైట్ కోర్సు కాన్ఫరెన్స్" చెక్ చేయాలి మరియు ప్రస్తుత యూజర్ కోర్సు పేరు మార్చడానికి సామర్ధ్యం కలిగి ఉండాలి (moodle / course: changeshortname)';
$string['config_overwrite_course_startdate'] = 'అప్రమేయంగా తిరిగి వ్రాసే కోర్సు ప్రారంభ తేదీ నుండి బ్యాకప్ ఫైల్ నుండి. దీని కోసం "ఓవర్రైట్ కోర్సు కాన్ఫిగరేషన్" తనిఖీ చేయబడాలి మరియు ప్రస్తుత యూజర్ పునరుద్ధరణపై కోర్సు తేదీలను రోల్ చేయగల సామర్థ్యాన్ని కలిగి ఉండాలి (మూడ్ / పునరుద్ధరణ: రోల్డెటెస్)';
$string['configgeneralactivities'] = 'ఒక బ్యాకప్ లో యాక్టివిటీలతో సహా డిఫాల్ట్  గా అమర్చుతుంది.';
$string['configgeneralanonymize'] = 'ప్రారంభించబడినట్లయితే వినియోగదారులకు సంబంధించిన అన్ని సమాచారం అప్రమేయంగా anonymised అవుతుంది.';
$string['configgeneralbadges'] = 'ఒక బాకప్ లో బ్యాడ్జ్లను కలిపి డిఫాల్ట్ అమర్చుతుంది.';
$string['configgeneralblocks'] = 'ఒక బ్యాకప్ లో బ్లాక్లను కూడా కలిపి డిఫాల్ట్  గా అమర్చుతుంది.';
$string['configgeneralcalendarevents'] = 'బ్యాకప్లో క్యాలెండర్ ఈవెంట్లతో సహా డిఫాల్ట్ను సెట్ చేస్తుంది';
$string['configgeneralcomments'] = 'ఒక బ్యాకప్ లో వ్యాఖ్యలను కూడా కలిపి డిఫాల్ట్  గా అమర్చుతుంది.';
$string['configgeneralcompetencies'] = 'బ్యాకప్లో ఉన్న సామర్థ్యాలతో సహా డిఫాల్ట్ను సెట్ చేస్తుంది.';
$string['configgeneralfilters'] = 'ఒక బ్యాకప్ లో ఫిల్టర్లను కూడా కలిపి డిఫాల్ట్  గా అమర్చుతుంది.';
$string['configgeneralgroups'] = '';
$string['configgeneralhistories'] = 'ఒక బ్యాకప్ లోపల వినియోగదారు హిస్టరీ కూడా కలిపి డిఫాల్ట్  గా అమర్చుతుంది.';
$string['configgenerallogs'] = 'ఎనేబుల్ చేసినచో లాగ్లను అప్రమేయంగా బ్యాకప్ లో చేర్చబడుతాయి.';
$string['configgeneralquestionbank'] = 'ప్రారంభించబడితే ప్రశ్నాపత్రాలు అప్రమేయంగా బ్యాకప్ లో చేర్చబడుతుంది. NOTE: ఈ సెట్టింగ్ని ఆపివేయడం ద్వార క్విజ్ వంటి ప్రశ్నాపత్రాల ఉపయోగిస్తున్న కార్యకలాపాలు, యొక్క బ్యాకప్ ఆపివేస్తుంది.';
$string['configgeneralroleassignments'] = 'ఎనేబుల్ చేసినచో రొల్స్ అసైన్మెంట్స్ అప్రమేయంగా బ్యాకప్ లో చేర్చబడుతాయి.';
$string['configgeneralusers'] = 'బ్యాకప్ లో వినియోగదారులు ఉంటాయి లేదో  డిఫాల్ట్  అమర్చుతుంది.';
$string['configgeneraluserscompletion'] = 'ప్రారంభించబడిన వినియోగదారు పూర్తి సమాచారం డిఫాల్ట్ గా బ్యాకప్ లు లో ఉంచబడుతుంది .';
$string['configloglifetime'] = 'మీ బ్యాకప్ లాగ్ల సమాచారం ను ఎంత సమయం ఉంచాలో ఇది నిర్దేశిస్తుంది. ఈ వయస్సు పైబడిన లాగ్లను స్వయంచాలకంగా తొలగించబడతాయి. బ్యాకప్ లాగ్ల సమాచారం భారీగా ఉంటుంది కాబట్టి , ఈ సంఖ్యను చిన్నది ఉంచండి.';
$string['configrestoreactivities'] = 'కార్యకలాపాలు పునరుద్ధరించడానికి డిఫాల్ట్ అమర్చుతుంది.';
$string['configrestorebadges'] = 'బ్యాడ్జ్లను పునరుద్ధరించడానికి డిఫాల్ట్ను సెట్ చేస్తుంది';
$string['configrestoreblocks'] = 'బ్లాక్లను పునరుద్ధరించడానికి డిఫాల్ట్ను సెట్ చేస్తుంది.';
$string['configrestorecalendarevents'] = 'క్యాలెండర్ ఈవెంట్లను పునరుద్ధరించడానికి డిఫాల్ట్ను సెట్ చేస్తుంది.';
$string['configrestorecomments'] = 'వ్యాఖ్యలను పునరుద్ధరించడానికి డిఫాల్ట్ను సెట్ చేస్తుంది.';
$string['configrestorecompetencies'] = 'సామర్ధ్యాలను పునరుద్ధరించడానికి డిఫాల్ట్గా సెట్ చేస్తుంది.';
$string['configrestoreenrolments'] = 'నమోదు పద్ధతులను పునరుద్ధరించడానికి డిఫాల్ట్ను సెట్ చేస్తుంది.';
$string['configrestorefilters'] = 'ఫిల్టర్లను పునరుద్ధరించడానికి డిఫాల్ట్గా సెట్ చేస్తుంది.';
$string['configrestoregroups'] = 'బ్యాకప్లో చేర్చబడితే సమూహాలను మరియు సమూహాలను పునరుద్ధరించడానికి డిఫాల్ట్గా సెట్ చేస్తుంది.';
$string['configrestorehistories'] = 'బ్యాకప్లో చేర్చబడితే వినియోగదారు చరిత్రను పునరుద్ధరించడానికి డిఫాల్ట్ను సెట్ చేస్తుంది.';
$string['configrestorelogs'] = 'ప్రారంభించబడిన లాగ్లు బ్యాకప్లో చేర్చబడితే డిఫాల్ట్గా పునరుద్ధరించబడతాయి.';
$string['configrestoreroleassignments'] = 'డిఫాల్ట్ పాత్రలు కేటాయించినట్లయితే అవి బ్యాకప్లో చేర్చబడినట్లయితే పునరుద్ధరణ చేయబడతాయి.';
$string['configrestoreusers'] = 'బ్యాకప్లో చేర్చబడితే వినియోగదారులను పునరుద్ధరించాలో లేదో అప్రమేయంగా సెట్ చేస్తుంది.';
$string['configrestoreuserscompletion'] = 'ప్రారంభించబడిన వినియోగదారు పూర్తి సమాచారం బ్యాకప్లో చేర్చబడి ఉంటే డిఫాల్ట్గా పునరుద్ధరించబడుతుంది.';
$string['confirmcancel'] = 'బ్యాకప్ రద్దు';
$string['confirmcancelno'] = 'స్టే';
$string['confirmcancelquestion'] = 'మీరు ఖచ్చితంగా రద్దు చేయ్యాలనుకుంటున్నారా? మీరు నమోదు చేసిన సమాచారం మొత్తం కోల్పోతారు.';
$string['confirmcancelyes'] = 'రద్దు';
$string['confirmnewcoursecontinue'] = 'కొత్త కోర్సు వార్నింగ్';
$string['confirmnewcoursecontinuequestion'] = 'ఒక తాత్కాలిక (దాగి) కోర్సు, కోర్సు పునరుద్ధరణ ప్రక్రియ ద్వారా సృష్టించబడుతుంది. పునరుద్ధరణ ను ఆపాలంటే రద్దు ను క్లిక్ చేయండి. పునరుద్ధరించేటప్పుడు బ్రౌజర్ ను మూసివేయకండి.';
$string['coursecategory'] = 'కేటగిరీ కోర్సు లోకి నిల్వ చెయ్యబడుతుంది';
$string['courseid'] = 'Original ID';
$string['coursesettings'] = 'కోర్సు సెట్టింగులు';
$string['coursetitle'] = 'శీర్షిక';
$string['currentstage1'] = 'ప్రారంభ సెట్టింగులు';
$string['currentstage16'] = 'పూర్తి';
$string['currentstage2'] = 'స్కీమా సెట్టింగులు';
$string['currentstage4'] = 'నిర్ధారణ మరియు సమీక్ష';
$string['currentstage8'] = 'బ్యాకప్ జరుపుము';
$string['enterasearch'] = 'ఒక శోధన ఎంటర్ చెయ్యండి';
$string['error_block_for_module_not_found'] = 'ఆర్ఫన్ బ్లాక్ ఉదాహరణ (id: {$a->bid}) కోర్సు మాడ్యూల్ కోసం  (id: {$a->mid}) దొరికింది. ఈ బ్లాక్  బ్యాకప్ కాదు';
$string['error_course_module_not_found'] = 'ఆర్ఫన్ కోర్స్ మాడ్యూల్ (ID: {$ a}) కనుగొనబడింది. ఈ మాడ్యూల్ బ్యాకప్ చెయ్యబడదు';
$string['errorcopyingbackupfile'] = 'పునరుద్ధరణకు ముందు బ్యాకప్ ఫైల్ను తాత్కాలిక ఫోల్డర్కు కాపీ చేయడం విఫలమైంది.';
$string['errorfilenamemustbezip'] = 'మీరు  ఎంటర్ చెసిన  ఫైల్ పేరు జిప్ ఫైల్. Mbz పొడిగింపు కలిగి ఉండాలి';
$string['errorfilenamerequired'] = 'మీరు ఈ బ్యాకప్ కోసం చెల్లుబాటు అయ్యే ఫైల్ పేరును నమోదు చేయాలి';
$string['errorfilenametoolong'] = 'ఫైల్పేరు తప్పక 255 అక్షరాల పొడవు ఉండాలి.';
$string['errorinvalidformat'] = 'తెలియని బ్యాకప్ ఫార్మాట్';
$string['errorinvalidformatinfo'] = 'ఎంచుకున్న ఫైల్ చెల్లదు మూడుల్ బ్యాకప్ ఫైల్ మరియు పునరుద్ధరించే అవకాశం ఉండదు.';
$string['errorminbackup20version'] = 'ఈ బ్యాకప్ ఫైల్ మూడిల్ బ్యాకప్ ({$a->backup}) యొక్క ఒక వెర్షన్ తో సృష్టించబడింది. అవసరమైన కనీస సమయం {$a->min}. పునరుద్దరించబడదు.';
$string['errorrestorefrontpagebackup'] = 'మీరు మొదటి పేజీలో మొదటి పేజీ బ్యాకప్ మాత్రమే పునరుద్ధరించవచ్చు';
$string['executionsuccess'] = 'బ్యాకప్ ఫైల్ విజయవంతంగా సృష్టించబడింది.';
$string['filealiasesrestorefailures'] = 'మారుపేర్ల వైఫల్యాలు పునరుద్ధరించడానికి';
$string['filealiasesrestorefailures_help'] = 'మారుపేర్లు ఇతర ఫైళ్లకు సింబాలిక్ లింకులు, సహా నిక్షేపస్థానాల్లో నిల్వ  ఉంచబడ్డాయి. కొన్ని సందర్భాల్లో, మూడిల్ వాటిని పునరుద్ధరించ లేదు - ఉదాహరణకు మరొక సైట్ లో బ్యాకప్ పునరుద్ధరించడానికి ఉన్నప్పుడు లేదా ప్రస్తావించిన ఫైల్ ఉనికిలో లేనప్పుడు.

మరిన్ని వివరాలు మరియు వైఫల్యం అసలు కారణం పునరుద్ధరించ లాగ్ ఫైల్ లో చూడవచ్చు.';
$string['filealiasesrestorefailures_link'] = 'restore/filealiases';
$string['filealiasesrestorefailuresinfo'] = 'బ్యాకప్ ఫైల్ చేర్చబడిన కొన్ని మారుపేర్లు  పునరుద్ధరించబడలేదు. క్రింది జాబితా వారి అంచనా నగర మరియు వారి మూలం ఫైల్ అసలు సైట్ వద్ద సూచిస్తుంది.';
$string['filename'] = 'ఫైల్ పేరు';
$string['filereferencesincluded'] = 'బాహ్య విషయాలను కలిగి ఉన్న ఫైల్ సూచనలు బ్యాకప్ ప్యాకేజీలో చేర్పిస్తే, ఇతర సైట్లలో పనిచేయదు.';
$string['filereferencesnotsamesite'] = 'బ్యాక్అప్ మరొక సైట్ నుంచి ఫైలు సిఫార్సులను పునరుద్ధరించే అవకాశం ఉండదు.';
$string['filereferencessamesite'] = 'బ్యాకప్ అదే సైట్ నుండి, ఫైలు సిఫార్సులు పునరుద్ధరించబడతాయి';
$string['generalactivities'] = 'కార్యాచరణలను చేర్చు';
$string['generalanonymize'] = 'Anonymise సమాచారం';
$string['generalbackdefaults'] = 'సాధారణ బ్యాకప్ డిఫాల్ట్ విలువలు';
$string['generalbadges'] = 'బాడ్జ్లను చేర్చండి';
$string['generalblocks'] = 'బ్లాకులను చేర్చండి';
$string['generalcalendarevents'] = 'క్యాలెండర్ ఈవెంట్లను చేర్చండి';
$string['generalcomments'] = 'వ్యాఖ్యలను చేర్చు';
$string['generalcompetencies'] = 'సామర్ధ్యాలను చేర్చండి';
$string['generalenrolments'] = 'నమోదు విధానాలను చేర్చండి';
$string['generalfilters'] = 'ఫిల్టర్లను చేర్చండి';
$string['generalgradehistories'] = 'చరిత్రలను చేర్చండి';
$string['generalgroups'] = '';
$string['generalhistories'] = 'చరిత్రలను చేర్చండి';
$string['generallogs'] = 'లాగ్లను చేర్చండి';
$string['generalquestionbank'] = 'ప్రశ్నాపత్రాలు ను చేర్చుట';
$string['generalrestoredefaults'] = 'సాధారణ డిఫాల్ట్లను పునరుద్ధరించండి';
$string['generalrestoresettings'] = 'జనరల్ పునరుద్ధరణ సెట్టింగులు';
$string['generalroleassignments'] = 'పాత్ర పనులను చేర్చండి';
$string['generalsettings'] = 'సాధారణ బ్యాకప్ సెట్టింగులు';
$string['generalusers'] = 'వినియోగదారులను చేర్చండి';
$string['generaluserscompletion'] = 'యూజర్ పూర్తి చేయవలసిన సమాచారం చేర్చండి';
$string['hidetypes'] = 'ఎంపికల రకం దాచుట';
$string['importbackupstage16action'] = 'కొనసాగించు';
$string['importbackupstage1action'] = 'తదుపరి';
$string['importbackupstage2action'] = 'తదుపరి';
$string['importbackupstage4action'] = 'దిగుమతి జరుపుము';
$string['importbackupstage8action'] = 'కొనసాగించు';
$string['importcurrentstage0'] = 'కోర్సు ఎంపిక';
$string['importcurrentstage1'] = 'ప్రారంభ సెట్టింగులు';
$string['importcurrentstage16'] = 'పూర్తయింది';
$string['importcurrentstage2'] = 'స్కీమా సెట్టింగులు';
$string['importcurrentstage4'] = 'నిర్ధారణ మరియు సమీక్ష';
$string['importcurrentstage8'] = 'దిగుమతి జరుపుము';
$string['importfile'] = 'ఒక బ్యాకప్ ఫైలును దిగుమతి చెయ్యండి';
$string['importgeneralduplicateadminallowed'] = 'నిర్వాహక సంఘర్షణ రిజల్యూషన్ని అనుమతించండి';
$string['importgeneralduplicateadminallowed_desc'] = 'సైట్ \'నిర్వాహకుడి\' పేరుతో ఒక ఖాతాను కలిగి ఉన్నట్లయితే, \'నిర్వాహకుడి\' పేరుతో ఒక ఖాతాను కలిగి ఉన్న బ్యాకప్ ఫైల్ను పునరుద్ధరించడానికి ప్రయత్నిస్తే సంఘర్షణకు దారి తీస్తుంది. ఈ సెట్టింగ్ ప్రారంభించబడితే, బ్యాకప్ ఫైల్ లో వినియోగదారు పేరును \'admin_xyz\' కు మార్చడం ద్వారా వైరుధ్యం పరిష్కరించబడుతుంది.';
$string['importgeneralmaxresults'] = 'దిగుమతి చేయుటకు కోర్సుల జాబితా గరిష్ట సంఖ్యను చేరుకుంది';
$string['importgeneralmaxresults_desc'] = 'ఇది దిగుమతి ప్రాసెస్ యొక్క మొదటి దశ సమయంలో ఇవ్వబడ్డ ఆ కోర్సుల సంఖ్యను నియంత్రిస్తుంది';
$string['importgeneralsettings'] = 'సాధారణ బ్యాకప్ డిఫాల్ట్ విలువలు';
$string['importsettings'] = 'సాధారణ దిగుమతి సెట్టింగ్లు';
$string['importsuccess'] = 'పూర్తి దిగుమతి అయిపోయింది. కోర్సుకు తిరిగి కొనసాగించుటకు క్లిక్ చేయండి.';
$string['includeactivities'] = 'చేర్చండి:';
$string['includeditems'] = 'చేర్చబడిన అంశాలు:';
$string['includefilereferences'] = 'బాహ్య విషయాలకు ఫైలు సూచనలు';
$string['includesection'] = '{$a} విభాగం';
$string['includeuserinfo'] = 'వినియోగదారుని డేటా';
$string['jumptofinalstep'] = 'చివరి దశకు దూకడం';
$string['keep'] = 'ఉంచండి';
$string['locked'] = 'లాక్ చెయ్యబడింది';
$string['lockedbyconfig'] = 'ఈ సెట్టింగ్ డిఫాల్ట్ బ్యాకప్ సెట్టింగ్ల ద్వారా లాక్ చేయబడింది';
$string['lockedbyhierarchy'] = 'డిపెండెన్సీస్ ద్వారా లాక్ చెయ్యబడింది';
$string['lockedbypermission'] = 'మీరు ఈ సెట్టింగ్ని మార్చడానికి అవసరమైన అనుమతులు లేవు';
$string['loglifetime'] = 'సంబంధించిన లాగ్లను ఉంచండి';
$string['managefiles'] = 'బ్యాకప్ ఫైళ్లు నిర్వహించేందుకు';
$string['mergerestoredefaults'] = 'మరొక కోర్సులో విలీనం చేస్తే డిఫాల్ట్లను పునరుద్ధరించండి';
$string['missingfilesinpool'] = 'కొన్ని ఫైళ్లు బ్యాకప్ సమయంలో సేవ్ కాలేదు, ఇది వాటిని పునరుద్ధరించడానికి సాధ్యం కాదు.';
$string['module'] = 'Module';
$string['moodleversion'] = 'మూడుల్ వెర్షన్';
$string['morecoursesearchresults'] = '{$ a} కంటే ఎక్కువ కోర్సులు కనుగొనబడ్డాయి, మొదటి {$ a} ఫలితాలు చూపబడుతున్నాయి';
$string['moreresults'] = 'చాలా ఫలితాలు ఉన్నాయి, మరింత నిర్దిష్టమైన శోధనను ఎంటర్ చెయ్యండి.';
$string['nomatchingcourses'] = 'ప్రదర్శించడానికి కోర్సులు లేవు';
$string['norestoreoptions'] = 'మీరు పునరుద్ధరించడానికి కేటగిరీలు గాని లేదా ఇప్పటికే ఉన్న విద్యా కోర్సులు గాని లేవు.';
$string['originalwwwroot'] = 'బ్యాకప్ యొక్క URL';
$string['overwrite'] = 'తిరిగి రాస్తుంది';
$string['preparingdata'] = 'డేటా సిద్దమవటం';
$string['preparingui'] = 'పేజీని ప్రదర్శించడానికి సిద్దమవటం';
$string['previousstage'] = 'ముందు';
$string['qcategory2coursefallback'] = 'ప్రశ్నలు వర్గం "{$a->name}", నిజానికి బ్యాకప్ ఫైల్ లో వ్యవస్థ / కోర్సు వర్గం విషయానికి, పునరుద్ధరించడం ద్వారా కోర్సు విషయాన్ని సృష్టించబడుతుంది';
$string['qcategorycannotberestored'] = 'ప్రశ్నలు వర్గం "{$ a-> పేరు}" ను పునరుద్ధరణతో తిరిగి సృష్టించడం సాధ్యం కాదు';
$string['question2coursefallback'] = 'ప్రశ్నలు వర్గం "{$a->name}", నిజానికి బ్యాకప్ ఫైల్ లో వ్యవస్థ / కోర్సు వర్గం విషయానికి, పునరుద్ధరించడం ద్వారా కోర్సు విషయాన్ని సృష్టించబడుతుంది';
$string['questioncannotberestored'] = 'ప్రశ్నలు "{$ a-> name}"ను పునరుద్ధరణతో తిరిగి సృష్టించడం సాధ్యం కాదు';
$string['replacerestoredefaults'] = 'మరొక కోర్సు విషయాలను తొలగిస్తున్నప్పుడు డిఫాల్ట్లను పునరుద్ధరించండి';
$string['restoreactivity'] = 'యాక్టివిటీను పునరుద్దరించు';
$string['restorecourse'] = 'కోర్సును పునరుద్దరించు';
$string['restorecoursesettings'] = 'కోర్సు సెట్టింగులు';
$string['restoreexecutionsuccess'] = 'కోర్సు విజయవంతంగా పునరుద్ధరించబడింది, క్రింద కొనసాగింపు బటన్ ను క్లిక్ చేస్తే మీరు పునరుద్ధరించిన కోర్సు వీక్షించడానికి వీలు పడుతుంది.';
$string['restorefileweremissing'] = 'కొన్ని ఫైళ్ళు పునరుద్దరించుటకు సాధ్యం కాలేదు ఎందుకంటే అవి బ్యాకప్ లొ లేవు';
$string['restorenewcoursefullname'] = 'కొత్త కోర్సు పేరు';
$string['restorenewcourseshortname'] = 'కొత్త కోర్సు లఘు నామము';
$string['restorenewcoursestartdate'] = 'నూతన ప్రారంభ తేదీ';
$string['restorerolemappings'] = 'రోల్ మ్యాపింగ్ లను పునరుద్ధరించడానికి';
$string['restorerootsettings'] = 'సెట్టింగులను పునరుద్ధరించడానికి';
$string['restoresection'] = 'విభాగం పునరుద్ధరించడానికి';
$string['restorestage1'] = 'నిర్ధారించు';
$string['restorestage16'] = 'సమీక్ష';
$string['restorestage16action'] = 'పునరుద్ధరణను జరుపుము';
$string['restorestage1action'] = 'తదుపరి';
$string['restorestage2'] = 'గమ్యం';
$string['restorestage2action'] = 'తదుపరి';
$string['restorestage32'] = 'ప్రక్రియ';
$string['restorestage32action'] = 'కొనసాగించు';
$string['restorestage4'] = 'సెట్టింగులు';
$string['restorestage4action'] = 'తదుపరి';
$string['restorestage64'] = 'పూర్తయ్యింది';
$string['restorestage64action'] = 'కొనసాగించు';
$string['restorestage8'] = 'స్కీమా';
$string['restorestage8action'] = 'తదుపరి';
$string['restoretarget'] = 'టార్గెట్ పునరుద్ధరించు';
$string['restoretocourse'] = 'కోర్సుకు  పునరుద్ధరించండి';
$string['restoretocurrentcourse'] = 'ఈ కోర్సు లోకి పునరుద్ధరించు';
$string['restoretocurrentcourseadding'] = 'బ్యాకప్ ను ఈ కోర్సులోకి విలీనం చెయ్యండి';
$string['restoretocurrentcoursedeleting'] = 'ఈ కోర్సు యొక్క కంటెంట్లను తొలగించు ఆపై పునరుద్దరించు';
$string['restoretoexistingcourse'] = 'ఇప్పటికే ఉన్న కోర్సు లోకి పునరుద్ధరించు';
$string['restoretoexistingcourseadding'] = 'ఇప్పటికే కోర్సు లోకి బ్యాకప్ కోర్సును విలీనం చెయ్యండి';
$string['restoretoexistingcoursedeleting'] = 'ఇప్పటికే ఉన్న కోర్సు యొక్క కంటెంట్లను తొలగించు ఆపై పునరుద్దరించు';
$string['restoretonewcourse'] = 'ఒక కొత్త కోర్సు వలె పునరుద్ధరించు';
$string['restoringcourse'] = 'కోర్సు పునరుద్ధరణ జరుగుతున్నది';
$string['restoringcourseshortname'] = 'పునరుద్దరించబడుతున్నది';
$string['rootenrolmanual'] = 'మానవీయ ఎన్రోల్మెంట్ గా పునరుద్ధరించు';
$string['rootsettingactivities'] = 'కార్యాచరణలను చేర్చు';
$string['rootsettinganonymize'] = 'యూజర్ సమాచారం అజ్ఞాతంగా చేయి';
$string['rootsettingbadges'] = 'బ్యాడ్జ్లను చేర్చండి';
$string['rootsettingblocks'] = 'బ్లాక్లను చేర్చండి';
$string['rootsettingcalendarevents'] = 'క్యాలెండర్ ఈవెంట్లు చేర్చండి';
$string['rootsettingcomments'] = 'వ్యాఖ్యలను చేర్చు';
$string['rootsettingcompetencies'] = 'సామర్ధ్యాలను చేర్చండి';
$string['rootsettingenrolments'] = 'నమోదు విధానాలను చేర్చండి';
$string['rootsettingenrolments_always'] = 'అవును ఎల్లప్పుడూ';
$string['rootsettingenrolments_never'] = 'లేదు, మాన్యువల్ నమోదుల వలె వినియోగదారులను పునరుద్ధరించండి';
$string['rootsettingenrolments_withusers'] = 'అవును, కానీ వినియోగదారులు చేర్చబడితే';
$string['rootsettingfilters'] = 'ఫిల్టర్లు చేర్చు';
$string['rootsettinggradehistories'] = 'గ్రేడ్ చరిత్ర చేర్చు';
$string['rootsettinggroups'] = '';
$string['rootsettingimscc1'] = 'IMS Common Cartridge 1.0 కు మార్చు';
$string['rootsettingimscc11'] = 'IMS Common Cartridge 1.1 కు మార్చు';
$string['rootsettinglogs'] = 'కోర్సు లాగ్లను చేర్చండి';
$string['rootsettingquestionbank'] = 'ప్రశ్నాపత్రాలు ను చేర్చుట';
$string['rootsettingroleassignments'] = 'యూజర్ పాత్ర పనులను చేర్చండి';
$string['rootsettings'] = 'బ్యాకప్ సెట్టింగులు';
$string['rootsettingusers'] = 'నమోదుచేసుకున్న వినియోగదారులను చేర్చండి';
$string['rootsettinguserscompletion'] = 'యూజర్ పూర్తి చేసిన వివరాలు చేర్చండి';
$string['sectionactivities'] = 'కార్యకలాపాలు';
$string['sectioninc'] = 'బ్యాకప్ చేర్చబడుతుంది ( ఏ యూజర్ సమాచారం వుండదు)';
$string['sectionincanduser'] = 'వినియోగదారుని ఇన్ఫర్మేషన్ తో పాటు బ్యాక్అప్ లోనే ఉంటుంది';
$string['selectacategory'] = 'ఒక వర్గాన్ని ఎంచుకుని';
$string['selectacourse'] = 'ఒక కోర్సును ఎంచుకోండి';
$string['setting_course_fullname'] = 'కోర్సు పేరు';
$string['setting_course_shortname'] = 'కోర్సు చిన్న పేరు';
$string['setting_course_startdate'] = 'కోర్సు ప్రారంభ తేదీ';
$string['setting_keep_groups_and_groupings'] = 'గ్రూపులు మరియు గ్రూపింగ్ ఉంచండి';
$string['setting_keep_roles_and_enrolments'] = 'ప్రస్తుత పాత్రలు మరియు  ఎన్రొల్మెంత్స్ ఉంచండి';
$string['setting_overwrite_conf'] = 'కోర్సు ఆకృతీకరణను ఓవర్రైట్ చేయండి';
$string['setting_overwrite_course_fullname'] = 'కోర్సు పూర్తి పేరును ఓవర్రైట్ చేయండి';
$string['setting_overwrite_course_shortname'] = 'కోర్సు చిన్న పేరును ఓవర్రైట్ చేయండి';
$string['setting_overwrite_course_startdate'] = 'కోర్సు ప్రారంభ తేదీని ఓవర్రైట్ చెయ్యి';
$string['showtypes'] = 'ఎంపికల రకం చూపుట';
$string['sitecourseformatwarning'] = 'ఈ ఒక ముందు పేజీ బ్యాకప్ వారు మాత్రమే మొదటి పేజీలో పునరుద్ధరించబడతాయి అని గమనించండి';
$string['skiphidden'] = 'దాగి ఉన్న కోర్సులు దాటవేయి';
$string['skiphiddenhelp'] = 'దాచిపెట్టిన కోర్సులను  దాటు వెయ్యలొ  లేదో ఎంచుకోండి';
$string['skipmodifdays'] = 'మార్పుచెయ్యని కోర్సులను దాటవేయండి';
$string['skipmodifdayshelp'] = 'కొన్ని రోజులు సంఖ్య నుండి మార్పు చెయ్యబడని కోర్సులను దాట వేయడానికి ఎంచుకోండి';
$string['skipmodifprev'] = 'గతంలో బ్యాక్అప్  చెయ్యని   కోర్సులను తప్పించండి';
$string['skipmodifprevhelp'] = 'గతంలో  బ్యాక్అప్ చెయ్యని  కోర్సులను దాట వేయడానికి లేదో ఎంచుకోండి';
$string['storagecourseandexternal'] = 'కోర్స్ బ్యాక్అప్ filearea మరియు సూచించిన డైరెక్టరీ';
$string['storagecourseonly'] = 'కోర్స్ బ్యాక్ అప్ ఫిలేర్య';
$string['storageexternalonly'] = 'పేర్కొనబడిన డైరెక్టరీ';
$string['timetaken'] = 'సమయాన్ని తీసుకున్నారు.';
$string['title'] = 'పేరు';
$string['totalcategorysearchresults'] = 'మొత్తం కేతగిరీలు : {$a}';
$string['totalcoursesearchresults'] = 'మొత్తం కోర్సులు: {$a}';
$string['unnamedsection'] = 'పేరులేని విభాగం';
$string['userinfo'] = 'యూజర్ సమాచారం';
