<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'offlinequiz', language 'te', version '4.3'.
 *
 * @package     offlinequiz
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['add'] = 'చేర్చు';
$string['addarandomquestion'] = 'యాదృచ్చికంగా ప్రశ్నలు';
$string['addarandomquestion_help'] = 'ప్రస్తుత ఆఫ్లైన్ క్విజ్ సమూహంలో బహుళ ఎంపిక ప్రశ్నల (లేదా అన్ని-లేదా-ఏదీ కాదు-బహుళ ఎంపిక ప్రశ్నలకు) యాదృచ్చిక ఎంపికను Moodle జతచేస్తుంది. జోడించిన ప్రశ్నల సంఖ్య అమర్చవచ్చు. ప్రశ్నలు ప్రస్తుత ప్రశ్న వర్గం (మరియు, ఎంచుకున్నట్లయితే, దాని ఉప కేతగిరీలు) నుండి ఎంపిక చేయబడతాయి.';
$string['addarandomselectedquestion'] = 'యాదృచ్ఛిక ఎంపిక ప్రశ్నని జోడించండి ...';
$string['addlist'] = 'జాబితాను జోడించండి';
$string['addnewpagesafterselected'] = 'ఎంచుకున్న ప్రశ్నలకు తర్వాత పేజీ బ్రేక్లను జోడించండి';
$string['addnewquestion'] = 'ఒక కొత్త ప్రశ్న';
$string['addnewquestionsqbank'] = 'వర్గం {$a->catname} కు ప్రశ్నలను జోడించండి: {$a->link}';
$string['addnewuseroverride'] = 'వినియోగదారు ఓవర్రైడ్ను జోడించండి';
$string['addpagebreak'] = 'పేజీ విరామం జోడించండి';
$string['addpagehere'] = 'ఇక్కడ పేజీని జోడించండి';
$string['addparts'] = 'పాల్గొనేవారిని జోడించండి';
$string['addquestionfrombankatend'] = 'చివరిలో ప్రశ్న బ్యాంకు నుండి జోడించు';
$string['addquestionfrombanktopage'] = 'ప్రశ్న బ్యాంకు నుండి పేజీకి {$a} పేజీకి జోడించండి';
$string['addrandom'] = 'యాదృచ్చికంగా {$a} బహుళ ఎంపిక ప్రశ్న (లు)';
$string['addrandomfromcategory'] = 'యాదృచ్చికంగా ప్రశ్నలు';
$string['addrandomquestion'] = 'యాదృచ్చికంగా ప్రశ్నలు';
$string['addrandomquestiontoofflinequiz'] = 'ఆఫ్లైన్క్విజ్ {$a->name} కు గుంపులను జతచేయడం (సమూహం {$a->group})';
$string['addrandomquestiontopage'] = 'పేజీకి యాదృచ్ఛిక ప్రశ్నని జోడించండి {$a}';
$string['addtoofflinequiz'] = 'ఆఫ్లైన్ క్విజ్కు జోడించు';
$string['addtoqueue'] = 'క్యూకు జోడించు';
$string['allinone'] = 'అపరిమిత';
$string['alllists'] = 'అన్ని జాబితాలు';
$string['allornothing'] = 'అన్నీ లేదా ఏవీ వద్దు';
$string['allresults'] = 'అన్ని ఫలితాలను చూపించు';
$string['allstudents'] = 'అన్ని విద్యార్థులను చూపించు';
$string['alwaysavailable'] = 'ఎల్లప్పుడూ అందుబాటులో ఉంది';
$string['analysis'] = 'అంశం విశ్లేషణ';
$string['answerform'] = 'సమాధానాల కోసం ఫారమ్';
$string['answerformforgroup'] = 'గుంపుకు {$ a}';
$string['answerforms'] = 'జవాబులు రూపాలు';
$string['answerpdfxy'] = 'సమాధానాల కోసం రూపం ({$a} ->maxquestions ప్రశ్నలు / {$a} ->maxanswers ఎంపికలు)';
$string['areyousureremoveselected'] = 'మీరు ఎంచుకున్న అన్ని ప్రశ్నలను తొలగించాలని నిశ్చయించుకున్నారా?';
$string['attemptexists'] = 'ప్రయత్నం ఉంది';
$string['attemptsexist'] = 'మీరు ఇకపై ప్రశ్నలను జోడించలేరు లేదా తొలగించలేరు.';
$string['attemptsnum'] = 'ఫలితాలు: {$a}';
$string['attemptsonly'] = 'ఫలితాలతో విద్యార్థులు మాత్రమే చూపించు';
$string['attendances'] = 'హాజరు';
$string['basicideasofofflinequiz'] = 'ఆఫ్ లైన్ క్విజ్-మేకింగ్ యొక్క ప్రాథమిక ఆలోచనలు';
$string['bulksavegrades'] = 'తరగతులు సేవ్';
$string['calibratescanner'] = 'స్కానర్ను కొలవగలదు';
$string['cannoteditafterattempts'] = 'ఇప్పటికే పూర్తి ఫలితాలు ఉన్నందున మీరు ప్రశ్నలను జోడించలేరు లేదా తొలగించలేరు. ({$a})';
$string['category'] = 'వర్గం';
$string['changed'] = 'ఫలితం మార్చబడింది.';
$string['checkparts'] = 'ప్రస్తుతం పాల్గొన్నవారిని గుర్తించండి';
$string['checkuserid'] = 'సమూహం / వినియోగదారు ఐడిని తనిఖీ చేయండి';
$string['chooseagroup'] = 'ఒక గుంపును ఎంచుకోండి ...';
$string['closebeforeopen'] = 'ఆఫ్లైన్ క్విజ్ని అప్డేట్ చేయలేకపోయాము. మీరు బహిరంగ తేదీకి ముందు ఉన్న తేదీని పేర్కొన్నారు.';
$string['closestudentview'] = 'విద్యార్థి వీక్షణను మూసివేయండి';
$string['closewindow'] = 'విండో మూసివేయి';
$string['cmmissing'] = 'ID {$a} తో ఆఫ్లైన్ క్విజ్ కోసం కోర్సు మాడ్యూల్ లేదు';
$string['configdecimalplaces'] = 'ఆఫ్లైన్ క్విజ్ కోసం తరగతులు ప్రదర్శించేటప్పుడు దశాంశ బిందువు తర్వాత చూపించవలసిన అంకెల సంఖ్య.';
$string['configdisableimgnewlines'] = 'ఈ ఐచ్ఛికం pdf ప్రశ్న షీట్లలో చిత్రాల ముందు మరియు తర్వాత క్రొత్త పంక్తులను ఆపివేస్తుంది. హెచ్చరిక: ఇది ఫార్మాటింగ్ సమస్యలకు దారి తీయవచ్చు.';
$string['configintro'] = 'మీరు ఇక్కడ సెట్ చేసిన విలువలు కొత్త ఆఫ్లైన్ క్విజెస్ యొక్క సెట్టింగ్ల కోసం డిఫాల్ట్ విలువలుగా ఉపయోగించబడతాయి.';
$string['configkeepfilesfordays'] = 'అప్లోడ్ చేసిన చిత్ర ఫైల్లు తాత్కాలిక నిల్వలో ఎన్ని రోజులు ఉంచాలో నిర్ణయించండి. ఈ సమయంలో ఆఫ్ లైన్ ఫైల్స్ ఆఫ్లైన్ క్విజ్ నిర్వాహక నివేదికలో అందుబాటులో ఉన్నాయి.';
$string['configonlylocalcategories'] = 'భాగస్వామ్యం చేసిన ప్రశ్న వర్గాలు అనుమతించబడవు.';
$string['configpapergray'] = 'కాగితం యొక్క తెలుపు-విలువ, జవాబు-షీట్లు అంచనా కోసం ఉపయోగించబడుతుంది';
$string['configshuffleanswers'] = 'సమాధానాలు షఫుల్ చేయండి';
$string['configshufflequestions'] = 'మీరు ఈ ఎంపికను ఎనేబుల్ చేస్తే, ఆఫ్లైన్ క్విజ్ సమూహంలోని ప్రశ్నల క్రమాన్ని యాదృచ్ఛికంగా "సృష్టించు రూపాలు" ట్యాబ్లో ప్రివ్యూను పునఃప్రారంభించే ప్రతిసారి మార్చబడుతుంది.';
$string['configshufflewithin'] = 'మీరు ఈ ఐచ్చికాన్ని ఎనేబుల్ చేస్తే, ప్రశ్నలను మరియు జవాబు రూపాలు సృష్టించబడినప్పుడు వ్యక్తిగత ప్రశ్నలను తయారు చేసే భాగాలు యాదృచ్చికంగా మార్చబడతాయి.';
$string['configuseridentification'] = 'వినియోగదారు గుర్తింపును వివరించే ఒక ఫార్ములా. ఈ సూత్రం వ్యవస్థలోని వినియోగదారులకు సమాధానం రూపాలను కేటాయించడానికి ఉపయోగిస్తారు. సమీకరణం యొక్క కుడి వైపున తప్పనిసరిగా Moodle యొక్క వినియోగదారు పట్టికలో ఒక ఫీల్డ్ను సూచించాలి';
$string['confirmremovequestion'] = 'మీరు ఖచ్చితంగా ఈ {$ a} ప్రశ్నని తీసివేయాలనుకుంటున్నారా?';
$string['copy'] = 'కాపీ';
$string['copyright'] = '<strong> హెచ్చరిక: ఈ పేజీలోని పాఠాలు మీ వ్యక్తిగత సమాచారం కోసం మాత్రమే. ఏవైనా ఇతర గ్రంథాలవలె ఈ ప్రశ్నలు కాపీరైట్ ఆంక్షలు క్రింద ఉన్నాయి. మీరు వారిని కాపీ చేయడానికి లేదా ఇతరులకు చూపించడానికి మీకు అనుమతి లేదు! </ Strong>';
$string['copyselectedtogroup'] = 'ఎంచుకున్న ప్రశ్నలను గుంపుకు చేర్చండి: {$a}';
$string['copytogroup'] = 'అన్ని ప్రశ్నలను గుంపుకు చేర్చండి: {$a}';
$string['correct'] = 'సరైన';
$string['correcterror'] = 'పరిష్కరించడానికి';
$string['correctforgroup'] = 'సమూహం {$a} కోసం సరైన సమాధానాలు';
$string['correctionform'] = 'దిద్దుబాటు';
$string['correctionforms'] = 'దిద్దుబాటు రూపాలు';
$string['correctionoptionsheading'] = 'సవరణ ఎంపికలు';
$string['correctupdated'] = 'సమూహం {$a} కోసం నవీకరించబడిన దిద్దుబాటు రూపం.';
$string['couldnotgrab'] = 'చిత్రం {$a} ను పట్టుకోవడం సాధ్యం కాలేదు';
$string['couldnotregister'] = 'వినియోగదారుని {$a}';
$string['createcategoryandaddrandomquestion'] = 'వర్గాన్ని సృష్టించండి మరియు యాదృచ్ఛిక ప్రశ్నని జోడించండి';
$string['createlistfirst'] = 'పాల్గొనేవారిని జోడించండి';
$string['createofflinequiz'] = 'రూపాలను సృష్టించండి';
$string['createpartpdferror'] = 'పాల్గొనేవారి జాబితాకు PDF రూపం {$a} సృష్టించబడలేదు. జాబితా ఖాళీగా ఉండవచ్చు.';
$string['createpdf'] = 'ఫారం';
$string['createpdferror'] = 'సమూహం {$a} కోసం రూపం సృష్టించబడలేదు. బహుశా గుంపులో ప్రశ్నలు లేవు.';
$string['createpdffirst'] = 'మొదటి PDF జాబితాను సృష్టించండి';
$string['createpdfforms'] = 'రూపాలను సృష్టించండి';
$string['createpdfs'] = 'డౌన్లోడ్ రూపాలు';
$string['createpdfsparticipants'] = 'పాల్గొనేవారి జాబితాకు PDF రూపాలు';
$string['createquestionandadd'] = 'కొత్త ప్రశ్న సృష్టించి క్విజ్కు జోడించు.';
$string['createquiz'] = 'రూపాలను సృష్టించండి';
$string['csvfile'] = 'CSV ఫైల్';
$string['csvformat'] = 'కామాతో వేరు చేయబడిన విలువలు టెక్స్ట్ ఫైల్ (CSV)';
$string['csvplus1format'] = 'ముడి డేటాతో టెక్స్ట్ ఫైల్ (CSV)';
$string['csvpluspointsformat'] = 'పాయింట్లతో టెక్స్ట్ ఫైల్ (CSV)';
$string['darkgray'] = 'ముదురు బూడిద రంగు';
$string['datanotsaved'] = 'సెట్టింగ్లను సేవ్ చేయడం సాధ్యపడలేదు';
$string['decimalplaces'] = 'డెసిమల్ ప్రదేశాలు';
$string['decimalplaces_help'] = 'ఆఫ్లైన్ క్విజ్ కోసం తరగతులు ప్రదర్శించేటప్పుడు దశాంశ బిందువు తర్వాత చూపించవలసిన అంకెల సంఖ్య.';
$string['deletelistcheck'] = 'మీరు నిజంగా ఎంచుకున్న జాబితాను తొలగించాలనుకుంటున్నారా?';
$string['deletepagecheck'] = 'మీరు నిజంగా ఎంచుకున్న పేజీలను తొలగించాలనుకుంటున్నారా?';
$string['deletepagesafterselected'] = 'ఎంచుకున్న ప్రశ్నలకు తర్వాత పేజీ బ్రేక్లను తీసివేయండి';
$string['deletepartcheck'] = 'మీరు నిజంగా పాల్గొన్నవారిని తొలగించాలనుకుంటున్నారా?';
$string['deleteparticipantslist'] = 'పాల్గొనేవారి జాబితాను తొలగించు';
$string['deletepdfs'] = 'పత్రాలను తొలగించండి';
$string['deleteresultcheck'] = 'మీరు నిజంగా ఎంచుకున్న ఫలితాలను తొలగించాలనుకుంటున్నారా?';
$string['deleteselectedpart'] = 'ఎంచుకున్న అభ్యర్థులను తొలగించు';
$string['deleteselectedresults'] = 'ఎంచుకున్న ఫలితాలను తొలగించండి';
$string['deletethislist'] = 'ఈ జాబితాను తొలగించండి';
$string['deleteupdatepdf'] = 'PDF- ఫారమ్లను తొలగించి నవీకరించండి';
$string['difficultytitle'] = 'కఠినత';
$string['difficultytitlea'] = 'కఠినత A';
$string['difficultytitleb'] = 'కఠినత B';
$string['difficultytitlediff'] = 'తేడా';
$string['disableimgnewlines'] = 'చిత్రాల ముందు మరియు తరువాత క్రొత్త పంక్తులను ఆపివేయి';
$string['disableimgnewlines_help'] = 'ఈ ఐచ్ఛికం pdf ప్రశ్న షీట్లలో చిత్రాల ముందు మరియు తర్వాత క్రొత్త పంక్తులను ఆపివేస్తుంది. హెచ్చరిక: ఇది ఫార్మాటింగ్ సమస్యలకు దారి తీయవచ్చు.';
$string['displayoptions'] = 'ప్రదర్శన ఎంపికలు';
$string['done'] = 'పూర్తి';
$string['downloadallzip'] = 'జిప్ గా అన్ని ఫైళ్లను డౌన్లోడ్ చేసుకోండి';
$string['downloadpartpdf'] = 'జాబితా కోసం PDF ఫైల్ను డౌన్లోడ్ చేయండి \'{$a} \\';
$string['downloadpdfs'] = 'పత్రాలను డౌన్లోడ్ చేయండి';
$string['downloadresultsas'] = 'ఫలితాలు ఇలా ఉన్నాయి:';
$string['dragtoafter'] = '{$a} తర్వాత';
$string['dragtostart'] = 'ప్రారంభం వరకు';
$string['editgroupquestions'] = 'సమూహ ప్రశ్నలను సవరించండి';
$string['editgroups'] = 'ఆఫ్లైన్ గుంపులను సవరించండి';
$string['editingofflinequiz'] = 'సమూహ ప్రశ్నలను సవరించడం';
$string['editingofflinequiz_help'] = 'ఆఫ్లైన్ క్విజ్ సృష్టించినప్పుడు, ప్రధాన అంశాలు:
<ul> <li> ఆఫ్లైన్ క్విజ్, ఒకటి లేదా అంతకంటే ఎక్కువ పేజీలపై ప్రశ్నలు ఉంటాయి </ li>
<li> కేతగిరీలుగా నిర్వహించబడే అన్ని ప్రశ్నల కాపీలను నిల్వ చేసే ప్రశ్న బ్యాంక్ </ li> </ ul>';
$string['editingofflinequizx'] = 'ఆఫ్లైన్ క్విజ్ని సవరించండి: {$a}';
$string['editlist'] = 'జాబితాను సవరించండి';
$string['editlists'] = 'జాబితాలను సవరించండి';
$string['editmaxmark'] = 'గరిష్ఠ మార్క్ను సవరించండి';
$string['editofflinequiz'] = 'ఆఫ్లైన్ క్విజ్ని సవరించండి';
$string['editofflinesettings'] = 'ఆఫ్లైన్ సెట్టింగ్లను సవరించండి';
$string['editorder'] = 'క్రమంలో సవరించండి';
$string['editparticipants'] = 'పాల్గొనేవారిని సవరించండి';
$string['editquestion'] = 'ప్రశ్నని సవరించండి';
$string['editquestions'] = 'ప్రశ్నలను సవరించండి';
$string['editscannedform'] = 'స్కాన్ రూపాన్ని సవరించండి';
$string['editthislist'] = 'ఈ జాబితాను సవరించండి';
$string['emptygroups'] = 'కొన్ని ఆఫ్లైన్ క్విజ్ సమూహాలు ఖాళీగా ఉన్నాయి. దయచేసి కొన్ని ప్రశ్నలను జోడించండి.';
$string['enroluser'] = 'యూజర్ని నమోదు చేయండి';
$string['erroraccessingreport'] = 'ఈ నివేదికను వీక్షించడానికి మీకు అనుమతి లేదు.';
$string['errorreport'] = 'దిగుమతి లోపాల నివేదిక';
$string['eventattemptdeleted'] = 'ఆఫ్లైన్ క్విజ్ ప్రయత్నం తొలగించబడింది';
$string['eventattemptpreviewstarted'] = 'ఆఫ్లైన్ క్విజ్ ప్రయత్నం ప్రివ్యూ ప్రారంభమైంది';
$string['eventattemptreviewed'] = 'ఆఫ్లైన్ క్విజ్ ప్రయత్నం సమీక్షించబడింది';
$string['eventattemptsummaryviewed'] = 'ఆఫ్లైన్ క్విజ్ ప్రయత్నం సారాంశం వీక్షించబడింది';
$string['eventattemptviewed'] = 'ఆఫ్లైన్ క్విజ్ ప్రయత్నం చూసింది';
$string['eventdocscreated'] = 'ఆఫ్లైన్ క్విజ్ ప్రశ్న మరియు జవాబు రూపాలు సృష్టించబడ్డాయి';
$string['eventdocsdeleted'] = 'ఆఫ్లైన్ క్విజ్ ప్రశ్న మరియు సమాధానం రూపాలు తొలగించబడ్డాయి';
$string['eventeditpageviewed'] = 'ఆఫ్లైన్ క్విజ్ మార్చు పేజీ చూచుటకు';
$string['eventofflinequizattemptsubmitted'] = 'ఆఫ్లైన్ క్విజ్ ప్రయత్నం సమర్పించబడింది';
$string['eventoverridecreated'] = 'ఆఫ్లైన్ క్విజ్ ఓవర్రైడ్ సృష్టించబడింది';
$string['eventoverridedeleted'] = 'ఆఫ్లైన్ క్విజ్ ఓవర్రైడ్ తొలగించబడింది';
$string['eventoverrideupdated'] = 'ఆఫ్లైన్ క్విజ్ ఓవర్రైడ్ నవీకరించబడింది';
$string['eventparticipantmarked'] = 'ఆఫ్లైన్ క్విజ్ భాగస్వామి మాన్యువల్గా మార్క్ చేయబడింది';
$string['eventquestionmanuallygraded'] = 'ప్రశ్న మానవీయంగా క్రమబద్ధీకరించబడింది';
$string['eventreportviewed'] = 'ఆఫ్లైన్ క్విజ్ నివేదిక వీక్షించబడింది';
$string['eventresultsregraded'] = 'ఆఫ్లైన్ క్విజ్ ఫలితాలు రిగ్రేడ్ చేయబడింది';
$string['everythingon'] = 'ఎనేబుల్';
$string['excelformat'] = 'Excel స్ప్రెడ్షీట్ (XLSX)';
$string['fileformat'] = 'ప్రశ్న షీట్లు కోసం ఫార్మాట్';
$string['fileformat_help'] = 'మీ ప్రశ్న షీట్లు PDF, DOCX లేదా TEX ఆకృతిలో కావాలో ఎంచుకోండి. సమాధానం రూపాలు మరియు దిద్దుబాటు షీట్లు ఎల్లప్పుడూ PDF ఫార్మాట్ లో ఉత్పత్తి అవుతుంది.';
$string['fileprefixanswer'] = 'answer_form';
$string['fileprefixcorrection'] = 'correction_form';
$string['fileprefixform'] = 'question_form';
$string['fileprefixparticipants'] = 'participants_list';
$string['filesizetolarge'] = 'మీ చిత్ర ఫైల్లో కొన్ని చాలా పెద్దవి. వ్యాఖ్యానాలలో కొలతలు మార్చబడతాయి. దయచేసి 200 మరియు 300 dpi మధ్య మరియు నలుపు మరియు తెలుపు మోడ్లో స్పష్టతతో స్కాన్ చేసేందుకు ప్రయత్నించండి. ఇది తరువాతి సమయం వివరణను వేగవంతం చేస్తుంది.';
$string['fontsize'] = 'ఫాంట్ పరిమాణం';
$string['forautoanalysis'] = 'ఆటోమేటిక్ విశ్లేషణ కోసం';
$string['formforcorrection'] = 'సమూహం {$a} కోసం సవరణ రూపం';
$string['formforgroup'] = 'సమూహం {$a} కోసం ప్రశ్న రూపం';
$string['formforgroupdocx'] = 'సమూహం {$a} (DOCX) కోసం ప్రశ్న రూపం';
$string['formforgrouplatex'] = 'సమూహం {$a} (LATEX) కోసం ప్రశ్న రూపం';
$string['formsexist'] = 'రూపాలు ఇప్పటికే సృష్టించబడ్డాయి.';
$string['formsexistx'] = 'రూపాలు ఇప్పటికే సృష్టించబడ్డాయి (<a href="{$a}"> ఫారమ్లను డౌన్లోడ్ చేయండి </a>)';
$string['formsheetsettings'] = 'ఫారం సెట్టింగులు';
$string['formspreview'] = 'రూపాల కోసం పరిదృశ్యం';
$string['formwarning'] = 'నిర్వచించిన జవాబు రూపం లేదు. దయచేసి మీ నిర్వాహకుడిని సంప్రదించండి';
$string['fromquestionbank'] = 'ప్రశ్న బ్యాంకు నుండి';
$string['functiondisabledbysecuremode'] = 'ఆ కార్యాచరణ ప్రస్తుతం నిలిపివేయబడింది';
$string['generalfeedback'] = 'సాధారణ అభిప్రాయం';
$string['generalfeedback_help'] = 'ప్రశ్నకు ప్రయత్నించిన తర్వాత సాధారణ అభిప్రాయం చూపబడిన వచనం. ఇచ్చిన స్పందనపై ఆధారపడి ఉన్న నిర్దిష్ట ప్రశ్నకు కాకుండా, అదే సాధారణ అభిప్రాయం ఎల్లప్పుడూ చూపబడుతుంది.';
$string['generatepdfform'] = 'PDF రూపం రూపొందించండి';
$string['grade'] = 'గ్రేడ్';
$string['gradedon'] = 'గ్రేడ్ ఆన్';
$string['gradedscannedform'] = 'తరగతులు తో స్కాన్ రూపం';
$string['gradeiszero'] = 'గమనిక: ఈ ఆఫ్లైన్ క్విజ్ కోసం గరిష్ట గ్రేడ్ 0 పాయింట్లు!';
$string['gradeswarning'] = 'ప్రశ్న తరగతులు సంఖ్యలు ఉండాలి!';
$string['gradewarning'] = 'ప్రశ్న గ్రేడ్ సంఖ్య ఉండాలి!';
$string['gradingofflinequiz'] = 'తరగతులు';
$string['gradingofflinequizx'] = 'తరగతులు: {$a}';
$string['gradingoptionsheading'] = 'గ్రేడింగ్ ఎంపికలు';
$string['greeniscross'] = 'ఒక క్రాస్ గా లెక్కించారు';
$string['group'] = 'గ్రూప్';
$string['groupoutofrange'] = 'సమూహం పరిధిలో లేదు మరియు సమూహం A. భర్తీ చేయబడింది';
$string['hasresult'] = 'ఫలితం ఉంది';
$string['idnumber'] = 'గుర్తింపు సంఖ్య';
$string['imagefile'] = 'ఇమేజ్ ఫైల్';
$string['imagenotfound'] = 'ఇమేజ్ ఫైల్: {$a} దొరకలేదు!';
$string['imagenotjpg'] = 'చిత్రం jpg లేదా png కాదు: {$a}';
$string['imagickwarning'] = 'Imagemagick లేదు: imagemagick లైబ్రరీని సంస్థాపించుటకు మీ సిస్టమ్ నిర్వాహకుడిని అడగండి మరియు మీ TeX నోటిఫికేషన్ వడపోత అమరికలలోని బైనరీని మార్చటానికి మార్గమును పరిశీలించండి. Imagemagick లేకుండా మీరు TIF ఫైళ్ళను దిగుమతి చెయ్యలేరు!';
$string['import'] = 'దిగుమతి';
$string['importedon'] = 'దిగుమతి చెయ్యబడింది';
$string['importerror11'] = 'ఇతర ఫలితం ఉంది';
$string['importerror12'] = 'వాడుకరి నమోదు కాలేదు';
$string['importerror13'] = 'గుంపు డేటా లేదు';
$string['importerror14'] = 'పట్టుకోలేరు';
$string['importerror15'] = 'అసురక్షిత గుర్తులు';
$string['importerror16'] = 'పేజీ లోపం';
$string['importerror17'] = 'పేజీలు అసంపూర్తిగా ఉన్నాయి';
$string['importerror21'] = 'పట్టుకోలేరు';
$string['importerror22'] = 'అసురక్షిత గుర్తులు';
$string['importerror23'] = 'వినియోగదారు జాబితాలో లేరు';
$string['importerror24'] = 'జాబితా కనుగొనబడలేదు';
$string['importforms'] = 'సమాధానం రూపాలను దిగుమతి చేయండి';
$string['importfromto'] = 'దిగుమతి {$a->from} to {$a->to} of {$a->total}.';
$string['importisfinished'] = 'ఆఫ్లైన్ క్విజ్ కోసం {$a} దిగుమతి పూర్తయింది';
$string['importlinkresults'] = 'ఫలితాలకు లింక్: {$a}';
$string['importlinkverify'] = 'ధృవీకరించడానికి లింక్: {$a}';
$string['importmailsubject'] = 'ఆఫ్లైన్ క్విజ్ దిగుమతి నోటిఫికేషన్';
$string['importnew'] = 'దిగుమతి';
$string['importnew_help'] = '<P>
మీరు సింగిల్ స్కాన్ చేయబడిన ఇమేజ్ ఫైల్స్ లేదా అనేక స్కాన్ చేయబడిన ఇమేజ్ ఫైల్లను ZIP-archive లో దిగుమతి చేసుకోవచ్చు. ఆఫ్లైన్ క్విజ్ మాడ్యూల్ నేపథ్యంలో చిత్ర ఫైల్స్ను ప్రాసెస్ చేస్తుంది.
ఫైలు పేర్లు సంబంధిత కాదు కానీ umlauts వంటి ప్రత్యేక అక్షరాలు కలిగి ఉండకూడదు. చిత్రాలు GIF లు, PNG లు ఉండాలి
లేదా TIF లు. 200 మరియు 300 డిపిల మధ్య ఒక తీర్మానం సిఫార్సు చేయబడింది. </ P>';
$string['importnumberexisting'] = 'డబుల్ రూపాల సంఖ్య: {$a}';
$string['importnumberpages'] = 'విజయవంతంగా దిగుమతి చేసిన పేజీల సంఖ్య: {$a}';
$string['importnumberresults'] = 'దిగుమతి చేసిన సంఖ్య: {$a}';
$string['importnumberverify'] = 'ధృవీకరించాల్సిన రూపాల సంఖ్య: {$a}';
$string['importtimefinish'] = 'ప్రాసెస్ పూర్తయింది: {$a}';
$string['importtimestart'] = 'ప్రాసెస్ ప్రారంభించబడింది: {$a}';
$string['inconsistentdata'] = 'అసంగతమైన డేటా: {$a}';
$string['info'] = 'సమాచారం';
$string['infoshort'] = 'i';
$string['insecuremarkings'] = 'అసురక్షిత గుర్తులు మాన్యువల్ దిద్దుబాట్లు కావాలి';
$string['insecuremarkingsforquestion'] = 'అసురక్షిత గుర్తులు ప్రశ్నకు మాన్యువల్ దిద్దుబాట్లు అవసరం';
$string['insertnumber'] = 'నీలం ఫ్రేమ్ ద్వారా గుర్తించబడిన సరైన గుర్తింపు సంఖ్యను దయచేసి చొప్పించండి';
$string['instruction1'] = 'ఈ సమాధానం రూపం స్వయంచాలకంగా స్కాన్ చేయబడుతుంది. దయచేసి మడవండి లేదా గుర్తించవద్దు. ఖాళీలను గుర్తించడానికి ఒక నలుపు లేదా నీలం పెన్ ఉపయోగించండి:';
$string['instruction2'] = 'స్పష్టమైన గుర్తులు సరిగ్గా అర్థం చేసుకోవచ్చు! మీరు మార్కింగ్ను సరి చేయాలనుకుంటే, పూర్తిగా రంగుతో పెట్టెను పూరించండి. ఈ ఫీల్డ్ ఖాళీ పెట్టెగా వ్యాఖ్యానించబడుతుంది:';
$string['instruction3'] = 'సరిదిద్దబడిన బాక్సులను మళ్ళీ గుర్తించలేము. దయచేసి బాక్సుల వెలుపల ఏదైనా వ్రాయవద్దు.';
$string['introduction'] = 'పరిచయం';
$string['invalidformula'] = 'వినియోగదారు గుర్తింపు కోసం చెల్లని సూత్రం. ఫార్ములా తప్పక <prefix> [<# digits>] <suffix> = <db-field & gt;';
$string['invalidnumberofdigits'] = 'ఉపయోగించిన అంకెలు చెల్లని సంఖ్య. 1 నుండి 9 అంకెల (లు) మాత్రమే అనుమతించబడతాయి.';
$string['invaliduserfield'] = 'ఉపయోగించిన వినియోగదారు పట్టికలో చెల్లని ఫీల్డ్.';
$string['invigilator'] = 'Invigilator';
$string['ischecked'] = 'పాల్గొనడం తనిఖీ చేయబడింది';
$string['isnotchecked'] = 'పాల్గొనడం తనిఖీ చేయబడలేదు';
$string['itemdata'] = 'Itemdata';
$string['keepfilesfordays'] = 'రోజులు ఫైళ్లను ఉంచండి';
$string['letter'] = 'లెటర్';
$string['lightgray'] = 'లేత బూడిద రంగు';
$string['linktoscannedform'] = 'స్కాన్ రూపాన్ని వీక్షించండి';
$string['listnotdetected'] = 'జాబితా కోసం బార్కోడ్ను గుర్తించడం సాధ్యం కాలేదు!';
$string['logdeleted'] = 'లాగ్ ఎంట్రీ {$a} తొలగించబడింది.';
$string['logourl'] = 'లోగో URL';
$string['logourldesc'] = 'జవాబు రూపాల ఎగువ కుడి మూలలో ప్రదర్శించబడే ఒక ఇమేజ్ ఫైల్ యొక్క URL, అంటే <b> http: //www.yoursite.tld/mylogo.png </ b> లేదా <b> .. / path / to / your /logo.png </ b>. గరిష్ఠ పరిమాణ పరిమాణం 520x140 పిక్సెల్స్. చిత్రం గరిష్ట పరిమాణం మించి ఉంటే సమాధానం రూపాలు అంచనా వేయబడవు!';
$string['lowertrigger'] = 'దిగువ రెండవ సరిహద్దు';
$string['lowertriggerzero'] = 'దిగువ రెండవ సరిహద్దు సున్నా';
$string['lowerwarning'] = 'దిగువ మొదటి సరిహద్దు';
$string['lowerwarningzero'] = 'దిగువ మొదటి సరిహద్దు సున్నా';
$string['marginwarning'] = 'దయచేసి అదనపు మార్జిన్ల లేకుండా ఈ క్రింది PDF ఫైళ్ళను ముద్రించండి! <br /> విద్యార్థులకు ఫోటో క్యాప్లను ఇవ్వడం మానుకోండి. మీకు మద్దతు బృందం నుండి ఏవైనా సందేహాలకు కాపీలు ఉంటే.';
$string['marks'] = 'మార్క్స్';
$string['matrikel'] = 'విద్యార్థి సంఖ్య';
$string['maxgradewarning'] = 'గరిష్ట గ్రేడ్ సంఖ్య ఉండాలి!';
$string['maxmark'] = 'గరిష్ట మార్క్';
$string['membersinplist'] = '{$a->name} లో <a href="{$a->url} "> {$a->name} పాల్గొనేవారు </a>';
$string['missingimagefile'] = 'చిత్రం ఫైల్ తప్పిపోయింది';
$string['missingitemdata'] = 'యూజర్ {$a} కోసం సమాధానం ఇవ్వలేదు (లు)';
$string['missinglogdata'] = 'ప్రస్తుత ఫలితం కోసం లాగ్డాటా లేదు.';
$string['missingquestion'] = 'ఈ ప్రశ్న ఇక ఉనికిలో లేదు';
$string['missinguserid'] = 'వినియోగదారు గుర్తింపు సంఖ్య లేదు! బార్కోడ్ను చదువలేదు!';
$string['modulename'] = 'ఆఫ్లైన్ క్విజ్';
$string['modulename_help'] = 'ఈ మాడ్యూల్ ఉపాధ్యాయుడు ఆఫ్ లైన్ క్విజ్లను బహుళఐచ్చిక ప్రశ్నలను కలిగి ఉంటుంది.
ఈ ప్రశ్నలు Moodle ప్రశ్న బ్యాంకులో ఉంచబడతాయి మరియు కోర్సులు మరియు కోర్సుల మధ్య కూడా తిరిగి ఉపయోగించబడతాయి.
ఆఫ్ లైన్ క్విజ్లను PDF, DOCX- లేదా LaTeX-files గా డౌన్లోడ్ చేసుకోవచ్చు. విద్యార్థులు వారి సమాధానాలను రూపం షీట్లలో గుర్తుంచుకుంటారు. రూపం షీట్లను స్కాన్ చేస్తారు మరియు వ్యవస్థలో దిగుమతి చేసిన సమాధానాలు.';
$string['modulenameplural'] = 'ఆఫ్లైన్ క్విజ్లు';
$string['moodleprocessing'] = 'Moodle ప్రాసెస్ డేటాను అనుమతించండి';
$string['movecorners'] = 'మొదట మూలలో గుర్తుల స్థానాలను మార్చండి. డ్రాగ్ మరియు డ్రాప్ ఉపయోగించండి.';
$string['moveselectedonpage'] = 'ఎంచుకున్న ప్రశ్నలను పేజీకి తరలించండి: {$a}';
$string['multianswersforsingle'] = 'ఒకే ఎంపిక ప్రశ్నకు బహుళ సమాధానాలు';
$string['multichoice'] = 'సరైన సమాదానం ఉన్న జవాబుల్లో నుంచి గుర్తించు';
$string['multipleanswers'] = 'కనీసం ఒక సమాధానం ఎంచుకోండి.';
$string['name'] = 'ఆఫ్లైన్ క్విజ్ పేరు';
$string['neededcorrection'] = '<strong> శ్రద్ధ: మీ గుర్తులు కొన్ని మాన్యువల్ దిద్దుబాటు అవసరం. కింది చిత్రంలో ఎరుపు చతురస్రాన్ని చూడండి.
<br /> ఈ ఉపాధ్యాయులచే సూచించబడిన మాన్యువల్ జోక్యం మరియు ఆఫ్ లైన్ క్విజ్ ఫలితాలు ప్రచురించడం ఆలస్యం! </ strong>';
$string['newgrade'] = 'గ్రేడెడ్';
$string['newpage'] = 'క్రొత్త పేజీ';
$string['noattemptexists'] = 'ఫలితం లేదు';
$string['noattempts'] = 'ఫలితాలు ఏవీ దిగుమతి కాలేదు!';
$string['noattemptsonly'] = 'ఫలితాలు లేని విద్యార్థులను మాత్రమే చూపించు';
$string['nocourse'] = 'ID {$a->offlinequiz} తో ఉన్న ఆఫ్లైన్ క్విజ్ కు సంబంధించినది అయిన {id a {$a>course} కోర్సు లేదు.';
$string['nogradesseelater'] = 'ఈ క్విజ్ ఇంకా {$a} కోసం శ్రేణీకరించబడలేదు. ఫలితాలు ఇక్కడ ప్రచురించబడతాయి.';
$string['nogroupdata'] = 'యూజర్ {$a} కోసం గుంపు డేటా లేదు';
$string['nomcquestions'] = 'సమూహం {$a} లో బహుళ ఎంపిక ప్రశ్నలు లేవు!';
$string['noofflinequiz'] = 'Id {$a} తో ఆఫ్లైన్ క్విజ్ లేదు!';
$string['nopages'] = 'ఏ పేజీలు దిగుమతి కాలేదు';
$string['noparticipantsfound'] = 'పాల్గొనేవారు ఏవీ దొరకలేదు';
$string['nopdfscreated'] = 'పత్రాలు ఏవీ సృష్టించబడలేదు!';
$string['noquestions'] = 'కొన్ని ఆఫ్లైన్ క్విజ్ సమూహాలు ఖాళీగా ఉన్నాయి. దయచేసి కొన్ని ప్రశ్నలను జోడించండి.';
$string['noquestionselected'] = 'ప్రశ్నలు లేవు!';
$string['noquestionsfound'] = 'సమూహం {$a} లో ప్రశ్నలు లేవు!';
$string['noquestionsonpage'] = 'ఖాళీ పేజీ';
$string['noresults'] = 'ఫలితాలు లేవు.';
$string['noreview'] = 'ఈ ఆఫ్లైన్ క్విజ్ను సమీక్షించడానికి మీకు అనుమతి లేదు';
$string['noscannedpage'] = 'ID {$a} తో ఏ స్కాన్ చేయబడిన పేజీ లేదు!';
$string['nothingtodo'] = 'చేయటానికి ఏమి లేదు!';
$string['notxtfile'] = 'సంఖ్య TXT ఫైల్';
$string['notyetgraded'] = 'ఇంకా శ్రేణీకరించబడలేదు';
$string['nozipfile'] = 'జిప్ ఫైల్ లేదు';
$string['numattempts'] = 'దిగుమతి చేసిన ఫలితాల సంఖ్య: {$a}';
$string['numattemptsqueue'] = '{$a} సమాధానం రూపాలు క్యూకు జోడించబడ్డాయి. డేటా ప్రాసెస్ అయిన తర్వాత ఒక ఇమెయిల్ మీ చిరునామాకి పంపబడుతుంది';
$string['numattemptsverify'] = 'స్కాన్ చేసిన రూపాలు దిద్దుబాటు కోసం వేచి ఉన్నాయి: {$a}';
$string['numberformat'] = 'విలువ {$ a} అంకెలు గల సంఖ్యగా ఉండాలి!';
$string['numbergroups'] = 'సమూహాల సంఖ్య';
$string['numpages'] = '{$a} పేజీలు దిగుమతి అయ్యాయి';
$string['numquestionsx'] = 'ప్రశ్నలు: {$a}';
$string['numusersadded'] = '{$a} పాల్గొనేవారు జోడించబడ్డారు';
$string['odsformat'] = 'OpenDocument స్ప్రెడ్షీట్ (ODS)';
$string['offlineimplementationfor'] = 'ఆఫ్లైన్ అమలు కోసం';
$string['offlinequiz:addinstance'] = 'ఆఫ్లైన్ క్విజ్ని జోడించండి';
$string['offlinequiz:attempt'] = 'క్విజెస్ ప్రయత్నం';
$string['offlinequiz:createofflinequiz'] = 'ఆఫ్లైన్ క్విజ్ ఫారమ్లను సృష్టించండి';
$string['offlinequiz:deleteattempts'] = 'ఆఫ్లైన్ క్విజ్ ఫలితాలను తొలగించండి';
$string['offlinequiz:grade'] = 'గ్రేడ్ ఆఫ్లైన్ మానవీయంగా క్విజ్ చేస్తుంది';
$string['offlinequiz:manage'] = 'ఆఫ్ లైన్ క్విజ్లను నిర్వహించండి';
$string['offlinequiz:preview'] = 'ఆఫ్లైన్ క్విజ్ లను పరిదృశ్యం చేయండి';
$string['offlinequiz:view'] = 'ఆఫ్లైన్ క్విజ్ సమాచారాన్ని వీక్షించండి';
$string['offlinequiz:viewreports'] = 'ఆఫ్లైన్ క్విజ్ నివేదికలను వీక్షించండి';
$string['offlinequizcloses'] = 'ఆఫ్లైన్ క్విజ్ ముగుస్తుంది';
$string['offlinequizcloseson'] = 'ఈ ఆఫ్లైన్ క్విజ్ యొక్క సమీక్ష {$ a} వద్ద మూసివేయబడుతుంది';
$string['offlinequizisclosed'] = 'ఆఫ్లైన్ క్విజ్ మూసివేయబడింది)';
$string['offlinequizisclosedwillopen'] = 'ఆఫ్లైన్ క్విజ్ మూసివేయబడింది ({$a} తెరుస్తుంది)';
$string['offlinequizisopen'] = 'ఈ ఆఫ్లైన్ క్విజ్ తెరవబడింది';
$string['offlinequizisopenwillclose'] = 'ఆఫ్లైన్ క్విజ్ ఓపెన్ (మూసివేయడం {$a})';
$string['offlinequizopenedon'] = 'ఈ ఆఫ్లైన్ క్విజ్ {$a} వద్ద ప్రారంభించబడింది';
$string['offlinequizopens'] = 'ఆఫ్లైన్-క్విజ్ తెరుచుకుంటుంది';
$string['offlinequizsettings'] = 'ఆఫ్లైన్ సెట్టింగులు';
$string['offlinequizwillopen'] = 'ఆఫ్-టెస్ట్ {$a} పై తెరుస్తుంది';
$string['oneclickenrol'] = '1-క్లిక్ నమోదు';
$string['oneclickenroldesc'] = 'ఈ ఐచ్చికాన్ని క్రియాశీలపరచినట్లయితే, ఉపాధ్యాయులు ఒక క్లిక్తో వినియోగదారులను నమోదు చేసుకునే అవకాశం ఉంది.';
$string['oneclickrole'] = '1-క్లిక్ నమోదు కోసం పాత్ర.';
$string['oneclickroledesc'] = '1-క్లిక్ నమోదు కోసం ఉపయోగించే పాత్రను ఎంచుకోండి. శ్రేణి "విద్యార్థి" తో మాత్రమే పాత్రలు ఎంచుకోవచ్చు.';
$string['onlylocalcategories'] = 'స్థానిక ప్రశ్న కేటగిరీలు మాత్రమే';
$string['orderandpaging'] = 'ఆర్డర్ మరియు పేజింగ్';
$string['orderandpaging_help'] = 'ప్రతి ప్రశ్నకు 10, 20, 30, ... సంఖ్యలు ఎదురవుతాయి. చేర్చబడ్డ అదనపు ప్రశ్నలకు స్థలాలను విడిచిపెట్టడానికి 10 దశలను పెంచుతుంది. ప్రశ్నలను క్రమాన్ని మార్చడానికి, నంబర్లను మార్చండి మరియు "ప్రశ్నలను మళ్లీ క్రమం చేయి" బటన్ క్లిక్ చేయండి.

నిర్దిష్ట ప్రశ్నలకు తర్వాత పేజీ బ్రేక్లను జోడించడానికి, ప్రశ్నలకు పక్కన ఉన్న చెక్ బాక్స్లను ఎంచుకుని, "ఎంచుకున్న ప్రశ్నలకు జోడించబడిన పేజీ విరామాలు" బటన్ను క్లిక్ చేయండి.

అనేక పేజీల మీద ప్రశ్నలు ఏర్పరచుటకు, Repaginate బటన్ నొక్కుము మరియు ప్రతి పేజీకి కావలసిన ప్రశ్నల సంఖ్యను ఎంచుకోండి.';
$string['orderingofflinequiz'] = 'ఆర్డర్ మరియు పేజింగ్';
$string['otherresultexists'] = '{$a} కోసం ఇప్పటికే ఉన్న ఫలితం ఇప్పటికే ఉంది, దిగుమతి విస్మరించబడింది! మొదటి ఫలితాన్ని తొలగించండి.';
$string['outof'] = '{$a->grade} గరిష్టంగా {$a->maxgrade}';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'మొత్తం అభిప్రాయం';
$string['overview'] = 'అవలోకనం';
$string['page-mod-offlinequiz-edit'] = 'ఆఫ్లైన్ క్విజ్ పేజీని సవరించండి';
$string['page-mod-offlinequiz-x'] = 'ఏదైనా ఆఫ్లైన్ క్విజ్ పేజీ';
$string['pagecorrected'] = 'పాల్గొనేవారి జాబితాను సరిచేసిన షీట్ దిగుమతి చేయబడింది';
$string['pageevaluationtask'] = 'ఆఫ్ లైన్ క్విజ్-ప్లగ్ఇన్కి జవాబు షీట్ మూల్యాంకనం';
$string['pageimported'] = 'పాల్గొనేవారి జాబితా షీట్ దిగుమతి';
$string['pagenotdetected'] = 'పేజీ కోసం బార్కోడ్ను గుర్తించడం సాధ్యం కాలేదు!';
$string['pagenumberimported'] = 'పాల్గొనేవారి జాబితాలో {$a} షీట్ దిగుమతి చేయబడింది';
$string['pagenumberupdate'] = 'పేజీ సంఖ్య నవీకరణ';
$string['pagesizeparts'] = 'ప్రతి పేజీకి చూపిన పాల్గొనేవారు:';
$string['papergray'] = 'కాగితం యొక్క వైట్ విలువ';
$string['papergray_help'] = 'మీ స్కాన్ చేసిన జవాబు రూపాల యొక్క తెలుపు భాగాలు చాలా చీకటిగా ఉంటే, ఈ విలువను ముదురు బూడిద రంగుగా మార్చడం ద్వారా దీన్ని సరిచేయవచ్చు';
$string['partcheckedwithoutresult'] = 'ఫలితము లేకుండా పాల్గొనేవారు <a href="{$a-> url} "> {$a->count}';
$string['partcheckedwithresult'] = '{$a} ఫలితంగా పాల్గొన్నవారిని తనిఖీ చేసారు';
$string['participants'] = 'పాల్గొనేవారు';
$string['participants_help'] = '<p> పాల్గొనే వ్యక్తుల జాబితాలో చాలామంది పాల్గొనేవారితో పెద్ద ఆఫ్లైన్ క్విజ్ల కోసం రూపొందించబడ్డాయి. వారు క్విజ్లో పాల్గొన్న విద్యార్థులను పరీక్షించడానికి గురువుకు సహాయం చేస్తారు మరియు అన్ని ఫలితాలు సరిగ్గా దిగుమతి అవుతాయా.
మీరు వివిధ జాబితాలకు వినియోగదారులను జోడించవచ్చు. ఉదాహరణకు, ప్రతి జాబితాలో ఒక ప్రత్యేక గదిలోని పాల్గొనేవారిని కలిగి ఉండవచ్చు. పాల్గొనేవారు ఒక ప్రత్యేక సమూహంలో సభ్యులు కావచ్చు. ఆ సమూహాలను సృష్టించడం కోసం ఒక సమూహ నమోదు సాధనాన్ని ఉపయోగించవచ్చు.
పాల్గొనేవారి జాబితా PDF పత్రాలను డౌన్లోడ్ చేసుకోవచ్చు, ప్రచురించబడుతుంది మరియు ఆఫ్లైన్ క్విజెస్ యొక్క సమాధానం రూపాల వలె క్రాస్తో మార్క్ చేయబడుతుంది. తర్వాత వారు అప్లోడ్ చేయబడతారు మరియు గుర్తించబడిన విద్యార్థులు డేటాబేస్లో ప్రస్తుతం గుర్తించబడతాయి.
దయచేసి విద్యార్థులను గుర్తించడానికి ఉపయోగించే బార్కోడ్లపై మచ్చలు నివారించండి. </ P>';
$string['participantsinlists'] = 'జాబితాలలో పాల్గొనేవారు';
$string['participantslist'] = 'పాల్గొనేవారి జాబితా';
$string['participantslists'] = 'పాల్గొనేవారు';
$string['partimportnew'] = 'పాల్గొనేవారి యొక్క అప్లోడ్ జాబితాలు';
$string['partimportnew_help'] = '<P>
ఈ ట్యాబ్లో మీరు పాల్గొనేవారిలో నిండిన జాబితాలను అప్లోడ్ చేయవచ్చు. మీరు సింగిల్ స్కాన్ చేయబడిన ఇమేజ్ ఫైళ్ళను లేదా అనేక స్కాన్ చేయబడిన ఇమేజ్ ఫైల్లను జిప్-ఆర్చీవ్ లో అప్లోడ్ చేయవచ్చు. ఆఫ్లైన్ క్విజ్ మాడ్యూల్ నేపథ్యంలో చిత్ర ఫైల్స్ను ప్రాసెస్ చేస్తుంది.
ఫైలు పేర్లు సంబంధిత కాదు కానీ umlauts వంటి ప్రత్యేక అక్షరాలు కలిగి ఉండకూడదు. చిత్రాలు GIF లు, PNG లు ఉండాలి
లేదా TIF లు. 200 మరియు 300 డిపిల మధ్య ఒక తీర్మానం సిఫార్సు చేయబడింది. </ P>';
$string['partuncheckedwithoutresult'] = '{$a} ఫలితాలు లేకుండా ఎంపిక చేయని అభ్యర్థులు';
$string['partuncheckedwithresult'] = 'ఫలితంగా ఎంపిక చేయని పాల్గొన్నవారిని <a href="{$a->url} "> {$a->count}';
$string['pdfdeletedforgroup'] = 'సమూహం {$a} కోసం ఫారం తొలగించబడింది';
$string['pdfintro'] = 'అదనపు సమాచారం';
$string['pdfintro_help'] = 'ఈ సమాచారం ప్రశ్న షీట్ యొక్క మొదటి పేజీలో ముద్రించబడుతుంది మరియు జవాబు రూపంలో ఎలా పూరించాలో గురించి సాధారణ సమాచారాన్ని కలిగి ఉండాలి.';
$string['pdfintrotext'] = '<b> నేను సరిగ్గా ఎలా గుర్తించగలను? </ b> <br /> ఈ సమాధానం రూపం స్వయంచాలకంగా స్కాన్ చేయబడుతుంది. దయచేసి మడవండి లేదా గుర్తించవద్దు. ఖాళీలను గుర్తించడానికి ఒక నలుపు లేదా నీలం పెన్ ఉపయోగించండి. మీరు మార్కింగ్ను సరి చేయాలనుకుంటే, పూర్తిగా రంగుతో పెట్టెను పూరించండి. ఈ ఫీల్డ్ ఖాళీ పెట్టె వలె అనువదించబడుతుంది. <br />';
$string['pdfintrotoolarge'] = 'పరిచయం చాలా పొడవుగా ఉంది (గరిష్టంగా 2000 అక్షరాలు).';
$string['pdfscreated'] = 'PDF రూపాలు సృష్టించబడ్డాయి';
$string['pdfsdeletedforgroup'] = 'సమూహం {$a} కోసం రూపాలు తొలగించబడ్డాయి';
$string['pearlywhite'] = 'ముదురు తెలుపు';
$string['pluginadministration'] = 'ఆఫ్లైన్ క్విజ్ నిర్వహణ';
$string['pluginname'] = 'ఆఫ్లైన్ క్విజ్';
$string['point'] = 'పాయింట్';
$string['present'] = 'ప్రస్తుతం';
$string['preventsamequestion'] = 'విభిన్న సమూహాలలో అదే ప్రశ్న యొక్క బహుళ వినియోగాన్ని నిరోధించండి';
$string['preview'] = 'ప్రివ్యూ';
$string['previewforgroup'] = 'సమూహం {$a} కోసం పరిదృశ్యం';
$string['previewquestion'] = 'పరిదృశ్యం ప్రశ్న';
$string['printstudycodefield'] = 'ప్రశ్న షీట్పై ప్రింట్ స్టడీ కోడ్ ఫీల్డ్';
$string['printstudycodefield_help'] = 'తనిఖీ చేస్తే, ప్రశ్న షీట్ యొక్క మొదటి పేజీలో అధ్యయనం కోడ్ ఫీల్డ్ ముద్రించబడుతుంది.';
$string['questionanalysis'] = 'కఠినత విశ్లేషణ';
$string['questionanalysistitle'] = 'కఠినత విశ్లేషణ పట్టిక';
$string['questionbankcontents'] = 'ప్రశ్న బ్యాంకు విషయాలు';
$string['questionforms'] = 'ప్రశ్న రూపాలు';
$string['questioninfoanswers'] = 'సరైన సమాధానాల సంఖ్య';
$string['questioninfocorrectanswer'] = 'సరైన సమాధానము';
$string['questioninfocorrectanswers'] = 'సరైన సమాధానాలు';
$string['questioninfonone'] = 'ఏమి లేదు';
$string['questioninfoqtype'] = 'ప్రశ్న రకం';
$string['questionname'] = 'ప్రశ్న పేరు';
$string['questionsheet'] = 'ప్రశ్న షీట్';
$string['questionsheetlatextemplate'] = '% TEX ఎన్కోడింగ్ = UTF-8 యూనికోడ్
\\ Documentclass [11pt, a4paper] {వ్యాసం}
\\ Usepackage [utf8x] {inputenc}
\\ Usepackage [T1] {fontenc}
\\ textwidth 16truecm
\\ textheight 23truecm
\\ Setlength {\\ oddsidemargin} {0cm}
\\ Setlength {\\ evensidemargin} {0cm}
\\ Setlength {\\ topmargin} {- 1cm}
\\ uspeepage {amsmath}% కోసం \\
\\ mathbb etc కొరకు \\ usepackage {amsfonts}%
\\ uspeepage [colorlinks = true, urlcolor = dunkelrot, linkcolor = black] {hyperref}% హైపర్ లింక్స్ వుపయోగించుటకు
\\ Usepackage {enumitem}
\\ Usepackage {xcolor}
\\ Usepackage {ulem}
\\ parindent 0pt% ఒక విభాగం ప్రారంభంలో ఇండెంట్ లేదు
\\ Renewcommand \\ UrlFont {\\ sf}
\\ Usepackage {lastpage}
\\ Usepackage {fancyhdr}
\\ Pagestyle {ఫాన్సీ}
\\ chead {\\ sc \\ title, group \\ group}
\\ cfoot {Seite \\ thepage / \\ pageref {LastPage}}
\\ makeatletter %%% సమాధానాల మధ్య పేజీని విస్మరించు
\\ @ Beginparpenalty = 10000
\\ @ Itempenalty = 10000
\\ makeatother
%
\\ newcommand {\\ answerIs} [1] {} %%% సరైన సమాధానం చూపించడాన్ని ఆపివేయి
% \\ newcommand {\\ answerIs} [1] {[# 1]} %%% సరైన సమాధానం చూపడం ప్రారంభించు
%%%
% ================================================================ ================================================== ========
%%% కోర్సు డేటా:
\\ Newcommand {\\ గ్రూప్} {A}
\\ newcommand {\\ header} {టెస్ట్ కోర్స్}
\\ Newcommand {\\ తేదీ}

\\ Newcommand {\\ TestTitle} {%
\\ {సెంటర్} ప్రారంభం
{\\ bf \\ పెద్ద ప్రశ్నాపత్రం} \\\\ [3 మిమీ]
\\ Fbox {
\\ {పట్టిక} {RL} ప్రారంభం
\\ rule {0pt} {25pt} పేరు: & $ \\ underline {\\ hspace * {8cm}} $ \\ rule {20pt} {0pt} \\\\ [5mm]
స్టూడెంట్ ID: & $ \\ $ {{hcm {}} {8cm}} $ {
% \\ rule + 10pt} {0pt} ప్రోగ్రామ్ కోడ్: & $ \\ underline {\\ hspace * {8cm}} $ \\\\ [5mm]
\\ rule [-20pt] {0pt} {20pt} సంతకం: & $ \\ underline {\\ hspace * {8cm}} $
\\ ముగింపు {పట్టిక}}
\\ ముగింపు {సెంటర్}
}

\\ InputIfFileExists {offline_test_extras.tex} {} {}% ఇన్పుట్ అదనపు వినియోగదారు నిర్వచనాలు

\\ {పత్రం} ప్రారంభం


% ================================================================ ================================================== ========
\\ TestTitle

% ================================================================ ================================================== ========


\\ bigskip
% ================================================================ ================================================== ========

{$ A-> pdfintrotext}

% ================================================================ ================================================== ========

\\ NEWPAGE

% ================================================================ ================================================== ========


{$ A-> latexforquestions}


\\ ముగింపు {పత్రం}';
$string['questionsin'] = 'ప్రశ్నలు';
$string['questionsingroup'] = 'గుంపులో ప్రశ్నలు';
$string['questionsinthisofflinequiz'] = 'ఈ ఆఫ్లైన్ క్విజ్లో ప్రశ్నలు';
$string['questiontextisempty'] = '[ఖాళీ ప్రశ్న టెక్స్ట్]';
$string['quizdate'] = 'ఆఫ్లైన్ క్విజ్ తేదీ';
$string['quizopenclose'] = 'ఓపెన్ మరియు దగ్గరగా తేదీలు';
$string['quizopenclose_help'] = 'విద్యార్థులు వారి ప్రయత్నం (లు) బహిరంగ సమయం మరియు దగ్గరి సమయానికి ముందు చూడగలరు.';
$string['randomfromexistingcategory'] = 'ఇప్పటికే ఉన్న వర్గానికి చెందిన రాండమ్ ప్రశ్న';
$string['randomnumber'] = 'యాదృచ్ఛిక ప్రశ్నల సంఖ్య';
$string['randomquestionusinganewcategory'] = 'ఒక కొత్త వర్గం ఉపయోగించి యాదృచ్ఛిక ప్రశ్న';
$string['readjust'] = 'Readjust';
$string['reallydeletepdfs'] = 'మీరు ఫారమ్ ఫైల్లను నిజంగా తొలగించాలనుకుంటున్నారా?';
$string['reallydeleteupdatepdf'] = 'మీరు నిజంగా పాల్గొనే జాబితాను తొలగించాలనుకుంటున్నారా?';
$string['recreatepdfs'] = 'PDF లను రీ క్రియేట్ చేయండి';
$string['recurse'] = 'ఉపవర్గాల నుండి కూడా ప్రశ్నలు చేర్చండి';
$string['rediswrong'] = 'తప్పు క్రాస్ లేదా క్రాస్ లేదు';
$string['refreshpreview'] = 'రిఫ్రెష్ ప్రివ్యూ';
$string['regrade'] = 'Regrade';
$string['regradedisplayexplanation'] = '<b> శ్రద్ధ: </ b> క్రమబద్ధీకరణ మాన్యువల్గా భర్తీ చేసిన మార్కులు మారవు!';
$string['regradinginfo'] = 'మీరు ప్రశ్నకు స్కోర్ను మార్చుకుంటే, పాల్గొనేవారి ఫలితాలను నవీకరించడానికి మీరు ఆఫ్లైన్ క్విజ్ను తప్పనిసరిగా నమోదు చేయాలి.';
$string['regradingquiz'] = 'Regrading';
$string['regradingresult'] = 'యూజర్ {$a} కోసం రీ గ్రేడింగ్ ఫలితం ...';
$string['reloadpreview'] = 'ప్రివ్యూ రీలోడ్ చెయ్యండి';
$string['reloadquestionlist'] = 'ప్రశ్న జాబితా రీలోడ్ చెయ్యి';
$string['remove'] = 'తొలగించు';
$string['removeemptypage'] = 'ఖాళీ పేజీని తొలగించండి';
$string['removepagebreak'] = 'పేజీ బ్రేక్ తీసివేయి';
$string['removeselected'] = 'ఎంపిక తీసివేయండి';
$string['reordergroupquestions'] = 'గుంపు ప్రశ్నలు క్రమాన్ని మార్చు';
$string['reorderquestions'] = 'ప్రశ్నలను క్రమం చేయండి';
$string['reordertool'] = 'క్రమాన్ని ప్రదర్శించే సాధనాన్ని చూపు';
$string['repaginate'] = 'పేజీకి {$a} ప్రశ్నలతో పునఃప్రారంభించండి';
$string['repaginatecommand'] = 'Repaginate';
$string['repaginatenow'] = 'ఇప్పుడు పునరావృతం చేయండి';
$string['reportends'] = 'ఫలితాల రివ్యూ ముగుస్తుంది';
$string['reportoverview'] = 'అవలోకనం';
$string['reportstarts'] = 'ఫలితాలు రివ్యూ మొదలవుతుంది';
$string['resetofflinequizzes'] = 'ఆఫ్లైన్ క్విజ్ డేటాను రీసెట్ చేయండి';
$string['resultexists'] = '{$a} కోసం ఇప్పటికే ఉన్న ఫలితం ఇప్పటికే ఉంది, దిగుమతి చేయబడలేదు';
$string['resultimport'] = 'ఫలితాలను దిగుమతి చేయండి';
$string['results'] = 'ఫలితాలు';
$string['review'] = 'సమీక్ష';
$string['reviewbefore'] = 'ఆఫ్లైన్ క్విజ్ తెరిచినప్పుడు సమీక్షను అనుమతించండి';
$string['reviewclosed'] = 'ఆఫ్లైన్ క్విజ్ మూసివేయబడిన తరువాత';
$string['reviewcloses'] = 'రివ్యూ ముగుస్తుంది';
$string['reviewimmediately'] = 'ప్రయత్నం తరువాత వెంటనే';
$string['reviewincludes'] = 'సమీక్ష కలిగి ఉంది';
$string['reviewofresult'] = 'ఫలితం యొక్క సమీక్ష';
$string['reviewopens'] = 'రివ్యూ తెరుస్తుంది';
$string['reviewoptions'] = 'విద్యార్థులు చూడవచ్చు';
$string['reviewoptions_help'] = 'ఈ ఎంపికలతో మీరు ఫలితాలు దిగుమతి అయిన తర్వాత విద్యార్థులు ఏమి చూస్తారో నియంత్రించవచ్చు.
ఫలితాల నివేదిక కోసం మీరు ప్రారంభ మరియు ముగింపు సమయాన్ని కూడా నిర్వచించవచ్చు. చెక్బాక్స్ అంటే:
<Table>
<tr> <td style = "vertical-align: top;"> <b> ప్రయత్నం </ b> </ td> <td>
ప్రశ్నలు మరియు సమాధానాల పాఠం విద్యార్థులకు చూపబడుతుంది. వారు ఎంచుకున్న సమాధానాలను వారు చూస్తారు, కానీ సరైన సమాధానాలు సూచించబడవు. </ Td>
</ Td> </ tr>
<tr> <td style = "vertical-align: top;"> <b> సరియైనది </ b> </ td> <td>
ఐచ్ఛికం "ప్రయత్నం" సక్రియం చేయబడితే మాత్రమే ఈ ఐచ్ఛికం సక్రియం చేయబడుతుంది. యాక్టివేట్ చేయబడినట్లయితే, ఎంపిక చేసిన సమాధానాల్లో సరైనవి (ఆకుపచ్చ నేపథ్యం) లేదా తప్పు (ఎరుపు నేపథ్యం) విద్యార్థులను చూడవచ్చు.
</ Td> </ tr>
<tr> <td style = "vertical-align: top;"> <b> మార్క్స్ </ b> </ td> <td>
సమూహం (ఉదా., B), గణనలు (సాధించిన గ్రేడ్, ప్రశ్నలకు మొత్తం గ్రేడ్, శాతం 40, 80 (50)) మరియు గ్రేడ్ (ఉదా.
అదనంగా, "ప్రయత్నం" ఎంపిక చేయబడినట్లయితే, సాధించిన స్కోరు మరియు గరిష్ట స్కోర్ ప్రతి ప్రశ్నకు చూపబడతాయి.
</ Td> </ tr>
<tr> <td style = "vertical-align: top;"> <b> కుడి సమాధానాలు </ b> </ td> <td>
ఇది సమాధానాలు సరియైన లేదా తప్పు అని చూపించాం. ఈ ప్రయత్నం "ప్రయత్నం" సెట్ చేయబడితే మాత్రమే అందుబాటులో ఉంటుంది.
</ Td> </ tr>
<tr> <td style = "vertical-align: top;"> <b> స్కాన్ చేయబడిన ఫారమ్ </ b> </ td> <td>
స్కాన్ చేసిన జవాబు రూపాలు చూపించబడ్డాయి. తనిఖీ పెట్టెలు ఆకుపచ్చ చతురస్రాలతో గుర్తించబడతాయి.
</ Td> </ tr>
<tr> <td style = "vertical-align: top;"> <b> తరగతులుతో స్కాన్ చేసిన ఫారమ్ </ b> </ td> <td>
స్కాన్ చేసిన జవాబు రూపాలు చూపించబడ్డాయి. తనిఖీ పెట్టెలు ఆకుపచ్చ చతురస్రాలతో గుర్తించబడతాయి. తప్పు మార్కులు మరియు తప్పిపోయిన గుర్తులు హైలైట్ చేయబడ్డాయి.
అదనంగా, ఒక పట్టిక ప్రతి ప్రశ్నకు గరిష్ట గ్రేడ్ మరియు సాధించిన గ్రేడ్ను చూపిస్తుంది.
</ Td> </ tr>
</ పట్టిక>';
$string['reviewoptionsheading'] = 'సమీక్ష ఎంపికలు';
$string['rimport'] = 'అప్లోడ్ / కరెక్ట్';
$string['rotate'] = 'రొటేట్';
$string['rotatingsheet'] = 'షీట్ తిప్పబడింది ...';
$string['save'] = 'సేవ్';
$string['saveandshow'] = 'సేవ్ చేసి విద్యార్థికి మార్పులను చూపించు';
$string['savescannersettings'] = 'స్కానర్ సెట్టింగులను సేవ్ చేయండి';
$string['scannedform'] = 'స్కాన్ రూపం';
$string['scannerformfortype'] = 'రకం {$a} కోసం ఫారం';
$string['scanneroptions'] = 'స్కానర్ సెట్టింగులు';
$string['scannerpdfs'] = 'ఖాళీ రూపాలు';
$string['scannerpdfstext'] = 'మీరు మీ స్వంత స్కానర్ సాఫ్ట్ వేర్ ను ఉపయోగించాలనుకుంటే క్రింది ఖాళీ ఫారమ్లను డౌన్లోడ్ చేయండి.';
$string['scanningoptionsheading'] = 'స్కానింగ్ ఎంపికలు';
$string['score'] = 'స్కోరు';
$string['search:activity'] = 'ఆఫ్లైన్ క్విజ్ - కార్యాచరణ సమాచారం';
$string['select'] = 'ఎంచుకోండి';
$string['selectagroup'] = 'ఒక సమూహాన్ని ఎంచుకోండి';
$string['selectall'] = 'అన్ని ఎంచుకోండి';
$string['selectcategory'] = 'వర్గాన్ని ఎంచుకోండి';
$string['selectdifferentgroup'] = 'దయచేసి వేరొక సమూహాన్ని ఎంచుకోండి!';
$string['selectedattempts'] = 'ఎంచుకున్న ప్రయత్నాలు ...';
$string['selectformat'] = 'ఫార్మాట్ని ఎంచుకోండి ..';
$string['selectgroup'] = 'సమూహాన్ని ఎంచుకోండి';
$string['selectlist'] = 'దయచేసి జాబితాను ఎంచుకోండి లేదా షీట్ readjust చేయడానికి ప్రయత్నించండి:';
$string['selectmultipletoolbar'] = 'బహుళ టూల్బార్ను ఎంచుకోండి';
$string['selectnone'] = 'అన్ని ఎంపికలను తీసివేయండి';
$string['selectpage'] = 'దయచేసి పేజీ సంఖ్యను ఎంచుకోండి లేదా షీట్ readjust చేయడానికి ప్రయత్నించండి:';
$string['selectquestiontype'] = '- ప్రశ్న రకం ఎంచుకోండి -';
$string['showallparts'] = 'అన్ని {$a} పాల్గొనేవారిని చూపించు';
$string['showcopyright'] = 'కాపీరైట్ ప్రకటనను చూపించు';
$string['showcopyrightdesc'] = 'మీరు ఈ ఎంపికను ప్రారంభిస్తే, విద్యార్ధి ఫలితాల సమీక్ష పేజీలో కాపీరైట్ ప్రకటన చూపబడుతుంది.';
$string['showgrades'] = 'ప్రశ్న తరగతులు ముద్రించండి';
$string['showgrades_help'] = 'ఈ ఐచ్ఛికం ఆఫ్లైన్ క్విజ్ ప్రశ్నల యొక్క గరిష్ట తరగతులు ప్రశ్న షీట్లో ముద్రించాలా వద్దా అనేదాన్ని నియంత్రిస్తుంది.';
$string['showmissingattemptonly'] = 'ఫలితం లేకుండా తనిఖీ చేసిన అన్ని పాల్గొనేవారిని చూపించు';
$string['showmissingcheckonly'] = 'ఫలితంగా అన్ని తనిఖీ చేయని పాల్గొనేవారిని చూపించు';
$string['shownumpartsperpage'] = 'ఒక్కో పేజీకి పాల్గొనేవారికి {$a} పాల్గొనండి';
$string['showquestioninfo'] = 'సమాధానాల గురించి సమాచారాన్ని ప్రింట్ చేయండి';
$string['showquestioninfo_help'] = 'ఈ ఐచ్ఛికాన్ని మీరు నియంత్రించవచ్చు, ప్రశ్న గురించి అదనపు సమాచారం ప్రశ్న షీట్లో ముద్రించబడుతుంది.
మీరు వీటిలో ఒకదాన్ని ఎంచుకోవచ్చు:
<Ul>
<li> ఏదీ లేదు
<li> ప్రశ్న రకము - ప్రశ్నా రకమును బట్టి ఏకైక-ఛాయిస్, మల్టి-ఛాయిస్, అన్నీ-నథింగ్ బహుళ-ఛాయిస్ ముద్రించబడతాయి
<li> సరైన సమాధానాల సంఖ్య - సరైన సమాధానాల సంఖ్య ముద్రించబడును
</ Ul>';
$string['showstudentview'] = 'విద్యార్థి వీక్షణను చూపించు';
$string['showtutorial'] = 'విద్యార్థులకు ఆఫ్లైన్ క్విజ్ ట్యుటోరియల్ని చూపించు.';
$string['showtutorial_help'] = 'ఈ ఐచ్ఛికం విద్యార్ధులు ఆఫ్లైన్ క్విజ్ల ప్రాథమికాల గురించి ట్యుటోరియల్ను చూడవచ్చో నిర్ణయిస్తుంది.
ట్యుటోరియల్ ఆఫ్లైన్ క్విజెస్లో వివిధ రకాల డాక్యుమెంట్లను ఎలా నిర్వహించాలనే దాని గురించి సమాచారం అందిస్తుంది. ఇంటరాక్టివ్ భాగంలో వారు వారి విద్యార్ధి ID సరిగ్గా ఎలా ఆడాలి అని తెలుసుకోండి. <br />
<b> దయచేసి గమనించండి: </ b> <br />
మీరు ఈ ఎంపికను "అవును" గా సెట్ చేసి, ఆఫ్లైన్ క్విజ్ ను దాచిపెడితే ట్యుటోరియల్కి లింక్ కనిపించదు. ఈ సందర్భంలో మీరు కోర్సు పేజీలోని ట్యుటోరియల్ లింక్ని జోడించవచ్చు';
$string['showtutorialdescription'] = 'కింది URL ను ఉపయోగించి కోర్సు పేజీకు మీరు ట్యుటోరియల్ లింక్ని జోడించవచ్చు:';
$string['shuffleanswers'] = 'సమాధానాలు షఫుల్ చేయండి';
$string['shufflequestions'] = 'ప్రశ్నలను షఫుల్ చేయండి';
$string['shufflequestionsanswers'] = 'ప్రశ్నలు మరియు సమాధానాలను షఫుల్ చేయండి';
$string['shufflequestionsselected'] = 'షఫుల్ ప్రశ్నలు సెట్ చేయబడ్డాయి, కాబట్టి పేజీలకు సంబంధించిన కొన్ని చర్యలు అందుబాటులో లేవు. షఫుల్ ఎంపికను మార్చడానికి, {$a}.';
$string['shufflewithin'] = 'ప్రశ్నల్లో షఫుల్ చేయండి';
$string['shufflewithin_help'] = 'ప్రారంభించబడితే, ప్రతి ప్రశ్నకు అనుగుణంగా ఉండే భాగాలు యాదృచ్ఛికంగా ప్రతిసారి ప్రివ్యూ రూపంలోని రీలోడ్ బటన్ను నొక్కినప్పుడు మార్చబడతాయి. గమనిక: ఈ సెట్టింగ్ shuffeling ఎంపికను ఆక్టివేట్ చేసిన ప్రశ్నలకు మాత్రమే వర్తిస్తుంది.';
$string['signature'] = 'సంతకం';
$string['singlechoice'] = 'ఒకే ఎంపిక';
$string['standard'] = 'ప్రామాణిక';
$string['starttutorial'] = 'పరీక్ష గురించి ట్యుటోరియల్ను ప్రారంభించండి';
$string['statistics'] = 'గణాంకాలు';
$string['statisticsplural'] = 'గణాంకాలు';
$string['statsoverview'] = 'గణాంకాలు అవలోకనం';
$string['studycode'] = 'కోడ్ అధ్యయనం';
$string['theattempt'] = 'ప్రయత్నం';
$string['timesup'] = 'సమయం మి౦చిపోతు౦ది!';
$string['totalmarksx'] = 'మొత్తం మార్కులు: {$a}';
$string['totalpointsx'] = 'మొత్తం మార్కులు: {$a}';
$string['totalquestionsinrandomqcategory'] = 'వర్గం లో {$a} ప్రశ్నలు మొత్తం.';
$string['trigger'] = 'దిగువ / అధిక సరిహద్దు';
$string['tutorial'] = 'ఆఫ్లైన్ క్విజెస్ కోసం ట్యుటోరియల్';
$string['type'] = 'రకం';
$string['uncheckparts'] = 'ఎంపిక చేసిన సభ్యులును గుర్తించి గైరుహాజరుగా మార్క్ చేయ౦డి';
$string['updatedsumgrades'] = 'సమూహం {$a->letter} యొక్క అన్ని తరగతులు మొత్తం {$a->grade} కు తిరిగి లెక్కించబడ్డాయి.';
$string['upgradingfilenames'] = 'పత్రాల యొక్క ఫైల్ పేర్లను అప్గ్రేడ్ చేయడం: ఆఫ్లైన్ క్విజ్ {$a->done} చేసినవి} / {$a->outof} (ఆఫ్లైన్ క్విజ్ ID {$a->info})';
$string['upgradingilogs'] = 'స్కాన్ చేయబడిన పేజీలను అప్గ్రేడ్ చేయడం: స్కాన్ చేయబడిన పేజీ {$a->done} / {$a->outof} <br/> (ఆఫ్లైన్ క్విజ్ ID {$a->info})';
$string['upgradingofflinequizattempts'] = 'ఆఫ్లైన్ క్విజ్ ప్రయత్నాలను అప్గ్రేడ్ చేయడం: ఆఫ్లైన్ క్విజ్ {$a->done} / {$a->outof} <br/> (ఆఫ్లైన్ క్విజ్ ID {$a->info})';
$string['upload'] = 'అప్లోడ్ / సరైన';
$string['uploadpart'] = 'పాల్గొనేవారి సరైన జాబితాలు అప్లోడ్ చేయ౦డి';
$string['uppertrigger'] = 'అధిక రెండవ సరిహద్దు';
$string['uppertriggerzero'] = 'అధిక రెండవ సరిహద్దు సున్నా';
$string['upperwarning'] = 'హయ్యర్ మొదటి సరిహద్దు';
$string['upperwarningzero'] = 'హయ్యర్ మొదటి సరిహద్దు సున్నా';
$string['useradded'] = 'వినియోగదారుడు {$a} జోడించబడ్డారు';
$string['userdoesnotexist'] = 'వినియోగదారుడు {$a} వ్యవస్థలో లేరు';
$string['useridentification'] = 'వినియోగదారు గుర్తింపు';
$string['userimported'] = 'వినియోగదారుడు {$a} దిగుమతి మరియు శ్రేణి';
$string['usernotincourse'] = 'వినియోగదారుడు {$a} కోర్సులో కాదు.';
$string['usernotinlist'] = 'వాడుకరి జాబితాలో నమోదు చెయ్యబడలేదు!';
$string['usernotregistered'] = 'వాడుకరి {$a} కోర్సులో నమోదు కాలేదు';
$string['userpageimported'] = 'యూజర్ {$a} కోసం దిగుమతి చేసిన ఒకే పేజీ';
$string['valuezero'] = 'విలువ సున్నాగా ఉండకూడదు';
$string['viewresults'] = 'ఫలితాలను వీక్షించండి';
$string['white'] = 'తెలుపు ర౦గు';
$string['withselected'] = 'ఎంచుకున్న ...';
$string['zerogradewarning'] = 'హెచ్చరిక: మీ ఆఫ్లైన్ క్విజ్ గ్రేడ్ 0.0!';
$string['zipfile'] = 'జిప్ ఫైల్';
$string['zipok'] = 'జిప్ ఫైల్ దిగుమతి';
