<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'facetoface', language 'te', version '4.3'.
 *
 * @package     facetoface
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addingsession'] = '{$a} లో కొత్త సెషన్ను జోడిస్తోంది';
$string['addmanageremailaddress'] = 'నిర్వాహకుని ఇమెయిల్ చిరునామాను జోడించండి';
$string['addmanageremailinstruction'] = 'మీరు గతంలో మీ నిర్వాహకుని ఇమెయిల్ చిరునామాను నమోదు చేయలేదు. దయచేసి ఈ సెషన్ కోసం సైన్-అప్ చేయడానికి క్రింద నమోదు చేయండి.';
$string['addnewfield'] = 'క్రొత్త అనుకూల ఫీల్డ్ను జోడించండి';
$string['addnewfieldlink'] = 'క్రొత్త అనుకూల ఫీల్డ్ను సృష్టించండి';
$string['addnewnotice'] = 'క్రొత్త సైట్ ప్రకటనను జోడించండి';
$string['addnewnoticelink'] = 'క్రొత్త సైట్ ప్రకటనను సృష్టించండి';
$string['addremoveattendees'] = 'హాజరైనవారిని జోడించు / తొలగించు';
$string['addsession'] = 'క్రొత్త సెషన్ను జోడించండి';
$string['addstudent'] = 'విద్యార్థిని జోడించు';
$string['alllocations'] = 'అన్ని స్థానాలు';
$string['allowcancellations'] = 'సైన్-అప్ రద్దులను అనుమతించండి';
$string['allowcancellations_help'] = 'తనిఖీ చేసినట్లయితే, సెషన్ హాజరైన వారి సైన్అప్లను రద్దు చేయగలుగుతారు';
$string['allowcancellationsdefault'] = 'సైన్-అప్ రద్దులను డిఫాల్ట్గా అనుమతించు';
$string['allowcancellationsdefault_help'] = 'తనిఖీ చేసినట్లయితే, ఈ కార్యాచరణకు కొత్త సెషన్లను సృష్టించే డిఫాల్ట్ సెట్టింగ్, సైన్-అప్ రద్దులను అనుమతిస్తుంది';
$string['allowoverbook'] = 'ఓవర్ బుకింగ్ అనుమతించు';
$string['allowoverbook_help'] = '"ఓవర్ బుకింగ్ను అనుమతించు" తనిఖీ చేసినప్పుడు, అభ్యాసకులు ఇప్పటికే పూర్తి అయినప్పటికీ కూడా ఫేస్-టు-ఫేస్ సెషన్ కోసం సైన్ అప్ చేయగలరు.

అభ్యాసకుడు ఇప్పటికే పూర్తి అయిన సెషన్ కోసం సైన్ అప్ చేసినప్పుడు, వారు సెషన్ కోసం వేచి ఉన్న జాబితాకు సలహా ఇస్తున్న ఒక ఇమెయిల్ను అందుకుంటారు మరియు బుకింగ్ అందుబాటులోకి వచ్చినప్పుడు వారికి తెలియజేయబడుతుంది.';
$string['allsessionsin'] = '{$a} లో అన్ని సెషన్లు';
$string['alreadysignedup'] = 'ఈ ముఖా ముఖి కార్యాచరణ కోసం మీరు ఇప్పటికే సైన్-అప్ చేశారు.';
$string['answer'] = 'సైన్ ఇన్ చేయండి';
$string['answercancel'] = 'సైన్ అవుట్ చేయండి';
$string['approvalreqd'] = 'ఆమోదం అవసరం';
$string['approvalreqd_help'] = '"ఆమోదం అవసరం" తనిఖీ చేసినప్పుడు, ఒక అభ్యాసకుడికి ఫేస్-టు-ఫేస్ సెషన్కు హాజరు కావడానికి వారి మేనేజర్ నుండి అనుమతి అవసరం.';
$string['approve'] = 'ఆమోదించడానికి';
$string['assessmentyour'] = 'మీ అంచనా';
$string['attendance'] = 'హాజరు';
$string['attendanceinstructions'] = 'సెషన్కు హాజరైన వినియోగదారులను ఎంచుకోండి:';
$string['attendedsession'] = 'హాజరైన సెషన్';
$string['attendees'] = 'హాజర్';
$string['booked'] = 'బుక్';
$string['bookingcancelled'] = 'మీ బుకింగ్ రద్దు చేయబడింది.';
$string['bookingcompleted'] = 'మీ బుకింగ్ పూర్తి అయింది.';
$string['bookingfull'] = 'పూర్తి బుకింగ్';
$string['bookingopen'] = 'బుకింగ్ ఓపెన్';
$string['bookingstatus'] = 'మీరు క్రింది సెషన్ కోసం బుక్ చేయబడ్డారు';
$string['calendareventdescriptionbooking'] = 'మీరు ఈ <a href="{$a}"> ముఖా ముఖి సెషన్ </a> కోసం బుక్ చేస్తారు.';
$string['calendareventdescriptionsession'] = 'మీరు <a href="{$a}"> ముఖా ముఖి సెషన్ </a> ను సృష్టించారు.';
$string['calendaroptions'] = 'క్యాలెండర్ ఎంపికలు';
$string['cancelbooking'] = 'బుకింగ్ రద్దు';
$string['cancelbookingfor'] = '{$a} కోసం బుకింగ్ రద్దు';
$string['cancellation'] = 'రద్దు';
$string['cancellationconfirm'] = 'మీరు ఈ సెషన్కు బుకింగ్ను ఖచ్చితంగా రద్దు చేయాలనుకుంటున్నారా?';
$string['cancellationinstrmngr'] = 'మేనేజర్ కోసం నోటీసు';
$string['cancellationinstrmngr_help'] = '** నిర్వాహకుడికి నోటీసు పంపడం ** తనిఖీ చేయబడితే, మేనేజర్ ** ఫీల్డ్ కోసం ** నోటిఫికేషన్లో టెక్స్ట్ వారు ఒక ఫేస్-టు-ఫేస్ బుకింగ్ను రద్దు చేశారనే సలహాదారుడి మేనేజర్కు పంపబడుతుంది.';
$string['cancellationmessage'] = 'రద్దు సందేశం';
$string['cancellationmessage_help'] = 'వినియోగదారులు సెషన్ కోసం వారి బుకింగ్ను రద్దు చేసినప్పుడు ఈ సందేశం పంపబడుతుంది.';
$string['cancellations'] = 'రద్దులు';
$string['cancellationsent'] = 'మీరు వెంటనే రద్దు ఇమెయిల్ను అందుకోవాలి.';
$string['cancellationsentmgr'] = 'మీరు మరియు మీ మేనేజర్ వెంటనే రద్దు ఇమెయిల్ను అందుకోవాలి.';
$string['cancellationstablesummary'] = 'వారి సెషన్ సైన్అప్లను రద్దు చేసిన వ్యక్తుల జాబితా.';
$string['cancelreason'] = 'కారణము';
$string['cannotapproveatcapacity'] = 'ఈ సెషన్ నిండినందున మీరు హాజరైనవారిని ఆమోదించలేరు.';
$string['cannotsignupsessioninprogress'] = 'మీరు సైన్ అప్ చేయలేరు, ఈ సెషన్ ప్రోగ్రెస్లో ఉంది';
$string['cannotsignupsessionover'] = 'మీరు సైన్ అప్ చేయలేరు, ఈ సెషన్ ముగిసింది.';
$string['capacity'] = 'కెపాసిటీ';
$string['capacity_help'] = '** కెపాసిటీ ** సెషన్లో అందుబాటులో ఉన్న సీట్ల సంఖ్య.

ముఖం- to- ఫేస్ సెషన్ సామర్థ్యం చేరుకున్నప్పుడు సెషన్ వివరాలు కోర్సు పేజీలో కనిపించవు. వివరాలను \'అన్ని సెషన్ల పేజీని చూడండి\' పైకి కనిపిస్తాయి మరియు అభ్యాసకుడు సెషన్లో నమోదు చేయలేరు.
& Nbsp;';
$string['changemanageremailaddress'] = 'మేనేజర్ ఇమెయిల్ చిరునామాను మార్చండి';
$string['changemanageremailinstruction'] = 'దయచేసి దిగువ మీ ప్రస్తుత మేనేజర్ కోసం ఇమెయిల్ చిరునామాను నమోదు చేయండి.';
$string['clearall'] = 'అన్నీ క్లియర్ చేయండి';
$string['closed'] = 'ముగించబడినది';
$string['conditions'] = 'పరిస్థితులు';
$string['conditionsexplanation'] = 'శిక్షణా క్యాలెండర్లో నోటీసును చూపించటానికి ఈ ప్రమాణాలు తప్పక కలుస్తాయి';
$string['confirm'] = 'నిర్ధారించండి';
$string['confirmanager'] = 'నిర్వాహకుని ఇమెయిల్ చిరునామాను నిర్ధారించండి';
$string['confirmation'] = 'నిర్ధారణ';
$string['confirmationinstrmngr'] = 'మేనేజర్ కోసం నోటీసు';
$string['confirmationinstrmngr_help'] = '"మేనేజర్కు నోటీసు పంపండి" తనిఖీ చేయబడినప్పుడు, "మేనేజర్ కోసం నోటీసు" ఫీల్డ్లోని టెక్స్ట్ ఒక ఫేస్-టు-ఫేస్ సెషన్ కోసం ఒక సభ్యుడు సైన్ అప్ చేశాడని సూచించే మేనేజర్కు పంపబడుతుంది.';
$string['confirmationmessage'] = 'నిర్ధారణ సందేశం';
$string['confirmationmessage_help'] = 'వినియోగదారులు ఒక సెషన్ కోసం సైన్ అప్ చేసినప్పుడు ఈ సందేశం పంపబడుతుంది.';
$string['confirmationsent'] = 'మీరు వెంటనే నిర్ధారణను స్వీకరించాలి';
$string['confirmationsentmgr'] = 'మీరు మరియు మీ నిర్వాహకుడు వెంటనే నిర్ధారణ ఇమెయిల్ను స్వీకరించాలి.';
$string['confirmmanageremailaddress'] = 'నిర్వాహకుని ఇమెయిల్ చిరునామాను నిర్ధారించండి';
$string['confirmmanageremailaddressquestion'] = '<B> {$ a} </ b> మీ మేనేజర్ ఇమెయిల్ చిరునామా ఇప్పటికీ?';
$string['confirmmanageremailinstruction1'] = 'మీరు ఇంతకు ముందు మీ నిర్వాహకుని ఇమెయిల్ చిరునామాగా నమోదు చేసారు:';
$string['confirmmanageremailinstruction2'] = 'ఇది మీ మేనేజర్ ఇమెయిల్ చిరునామా ఇప్పటికీ';
$string['continuetologin'] = 'లాగిన్ కొనసాగించు క్లిక్ చేయండి';
$string['copy'] = 'కాపీ';
$string['copyingsession'] = '{$a} లో కొత్త సెషన్గా కాపీ';
$string['copysession'] = 'సెషన్ను కాపీ చేయండి';
$string['cost'] = 'ఖరీదు';
$string['costheading'] = 'సెషన్ ఖర్చు';
$string['crontask'] = 'ముఖా ముఖి నిర్వహణ ఉద్యోగాలు';
$string['currentstatus'] = 'ప్రస్తుత స్థితి';
$string['customfieldsheading'] = 'అనుకూల సెషన్ ఫీల్డ్స్';
$string['date'] = 'తేదీ';
$string['dateadd'] = 'కొత్త తేదీని జోడించండి';
$string['dateremove'] = 'ఈ తేదీని తీసివేయండి';
$string['datesignedup'] = 'తేదీ సైన్ అప్';
$string['datetext'] = 'మీరు తేదీ కోసం సైన్ ఇన్ చేసారు';
$string['decidelater'] = 'తర్వాత నిర్ణయించు';
$string['decline'] = 'డిక్లైన్';
$string['delete'] = 'తొలగించు';
$string['deleteall'] = 'అన్నిటిని తొలిగించు';
$string['deletesession'] = 'సెషన్ను తొలగించు';
$string['deletesessionconfirm'] = 'మీరు ఈ సెషన్ కోసం ఈ సెషన్ మరియు అన్ని సైన్-అప్లను తొలగించాలనుకుంటున్నారా?';
$string['deletingsession'] = '{$a} లో సెషన్ను తొలగిస్తుంది';
$string['description'] = 'పరిచయం టెక్స్ట్';
$string['description_help'] = '** వర్ణన ** ఒక అభ్యాసకుడు ఫేస్-టు-ఫేస్ సెషన్లో ఎన్ఆర్లస్ చేసినప్పుడు ప్రదర్శించే కోర్సు వివరణ.

** వివరణ ** శిక్షణ క్యాలెండర్లో కూడా ప్రదర్శిస్తుంది.';
$string['details'] = 'వివరాలు';
$string['details_help'] = 'వివరాలు సెషన్ ఆధారంగా ట్రాక్ చేయబడతాయి.
వచన విభాగంలో పాఠం ఉన్నట్లయితే, యూజర్ సైన్అప్ పేజీలో వివరాలు టెక్స్ట్ ప్రదర్శించబడుతుంది.
అప్రమేయంగా, వివరాల వచనం నిర్ధారణ, రిమైండర్, వెయిట్ జాబితా మరియు రద్దు ఇమెయిల్ సందేశాలలో కూడా కనిపిస్తుంది.';
$string['discountcode'] = 'డిస్కౌంట్ కోడ్';
$string['discountcode_help'] = 'ఉద్యోగుల శిక్షణ కోసం ట్రాక్ చేసే డిస్కౌంట్ ధర కోసం అవసరమైన కోడ్ కోడ్.
సిబ్బంది డిస్కౌంట్ కోడ్ నమోదు చేయకపోతే, సాధారణ వ్యయం శిక్షణ రికార్డులో కనిపిస్తుంది.';
$string['discountcodelearner'] = 'డిస్కౌంట్ కోడ్';
$string['discountcodelearner_help'] = 'మీకు తెలిస్తే డిస్కౌంట్ కోడ్ ఇక్కడ నమోదు చేయండి. మీరు ఈ ఫీల్డ్ను ఖాళీగా వదిలేస్తే, ఈ ఈవెంట్ కోసం మీకు సాధారణ ధర ఛార్జీ చేయబడుతుంది';
$string['discountcost'] = 'డిస్కౌంట్ ఖర్చు';
$string['discountcost_help'] = 'సభ్యత్వం ఖర్చు సభ్యత్వ ఐడి ఉన్న సిబ్బందికి చెల్లించే డాలర్ మొత్తం.
ఒక సెషన్ కోసం సైన్ అప్ చేస్తున్నప్పుడు సిబ్బంది సభ్యుడి సభ్యత్వం ID లోకి ప్రవేశిస్తే, కోర్సు యొక్క ధర పుస్తకంలో ధర కాలమ్లో డిస్కౌంట్ ధర కనిపిస్తుంది.';
$string['due'] = 'కారణంగా';
$string['duration'] = 'వ్యవధి';
$string['duration_help'] = '** వ్యవధి ** గంటల్లో శిక్షణ మొత్తం పొడవు.
ఉదాహరణకి:
* "2 గంటలు" ** 2 ** లేదా ** 2: 00 గా నమోదు అవుతుంది **
* "1 గంట మరియు 30 నిమిషాలు" ** 1: 30 **
* "45 నిమిషాలు" ** 0: 45 ** గా నమోదు చేయబడింది
* "20 నిమిషాలు" ** 0: 20 ** గా నమోదు చేయబడింది.

శిక్షణ రెండు లేదా అంతకంటే ఎక్కువ కాల వ్యవధిలో జరిగితే, వ్యవధి మిశ్రమ మొత్తం.';
$string['early'] = '{$a} ప్రారంభంలో';
$string['edit'] = 'మార్చు';
$string['editingsession'] = '{$a} లో సెషన్ సవరణ';
$string['editsession'] = 'సెషన్ను సవరించండి';
$string['email:instrmngr'] = 'మేనేజర్ కోసం నోటీసు';
$string['email:message'] = 'సందేశం';
$string['email:subject'] = 'Subject';
$string['emailmanager'] = 'మేనేజర్కు నోటీసుని పంపండి';
$string['emailmanagercancellation'] = '# మేనేజర్కు నోటీసు పంపండి';
$string['emailmanagercancellation_help'] = '"మేనేజర్కి నోటీసు పంపండి" తనిఖీ చేసినప్పుడు, ఫేస్-టు-ఫేస్ బుకింగ్ రద్దు చేయబడిన వారికి అభ్యాసకుడి మేనేజర్కు ఒక ఇమెయిల్ పంపబడుతుంది.';
$string['emailmanagerconfirmation'] = '# మేనేజర్కు నోటీసు పంపండి';
$string['emailmanagerconfirmation_help'] = '"మేనేజర్కు నోటీసు పంపండి" తనిఖీ చేసినప్పుడు, అభ్యాసకుడు ముఖాముఖి సెషన్ కోసం సైన్ అప్ చేసినప్పుడు, ఒక నిర్ధారణ ఇమెయిల్ అభ్యాసకుని మేనేజర్కు పంపబడుతుంది.';
$string['emailmanagerreminder'] = '# మేనేజర్కు నోటీసు పంపండి';
$string['emailmanagerreminder_help'] = '"మేనేజర్కు నోటీసు పంపండి" తనిఖీ చేసినప్పుడు, ఫేస్-టు-ఫేస్ సెషన్ యొక్క ప్రారంభ తేదీకి కొన్ని రోజుల ముందు, రిమైండర్ సందేశం అభ్యాసకుని మేనేజర్కు పంపబడుతుంది.';
$string['emptylocation'] = 'స్థానం ఖాళీగా ఉంది';
$string['enrolled'] = 'చేరాడు';
$string['error:addalreadysignedupattendee'] = 'ఈ ముఖా ముఖి కార్యాచరణ కోసం {$a} ఇప్పటికే సైన్ అప్ అయింది.';
$string['error:addattendee'] = 'సెషన్కు {$a} ను జోడించలేకపోయాము.';
$string['error:cancelbooking'] = 'మీ బుకింగ్ రద్దు చేయడంలో సమస్య ఉంది';
$string['error:cancellationsnotallowed'] = 'ఈ సైన్-అప్ను రద్దు చేయడానికి మీకు అనుమతి లేదు.';
$string['error:cannotemailmanager'] = 'వినియోగదారుడు {$a->userid} కు సబ్మిషన్ ఐడి {$a->submissionid} కు రిమైండర్ మెయిల్ పంపారు, కానీ వినియోగదారు యొక్క నిర్వాహక ఇమెయిల్ చిరునామా ({$a->manageremail}) కోసం సందేశాన్ని పంపలేకపోయాడు.';
$string['error:cannotemailuser'] = 'యూజర్ {$a->userid} ({$a->useremail}) కు సబ్మిషన్ ఐడి {$a->submissionid} మెయిల్ పంపడం సాధ్యం కాలేదు.';
$string['error:cannotsendconfirmationmanager'] = 'నిర్ధారణ సందేశాన్ని మీ ఇమెయిల్ ఖాతాకు పంపించారు, కానీ మీ మేనేజర్ యొక్క ఇమెయిల్ చిరునామాకు నిర్ధారణ సందేశాన్ని పంపడానికి సమస్య ఉంది.';
$string['error:cannotsendconfirmationthirdparty'] = 'నిర్ధారణ సందేశాన్ని మీ ఇమెయిల్ ఖాతాకు మరియు మీ మేనేజర్ యొక్క ఇమెయిల్ ఖాతాకి పంపించబడ్డారు, కానీ మూడవ పార్టీ ఇమెయిల్ చిరునామాకు నిర్ధారణ సందేశాన్ని పంపడానికి సమస్య ఉంది.';
$string['error:cannotsendconfirmationuser'] = 'మీ ఇమెయిల్ ఖాతాకు నిర్ధారణ సందేశాన్ని పంపడంలో సమస్య ఉంది.';
$string['error:cannotsendconfirmationusermanager'] = 'నిర్ధారణ సందేశాన్ని మీ ఇమెయిల్ చిరునామాకు మరియు మీ మేనేజర్ యొక్క ఇమెయిల్ చిరునామాకు పంపడం సాధ్యపడలేదు.';
$string['error:cannotsendrequestmanager'] = 'మీ నిర్వాహక ఇమెయిల్ ఖాతాకు సైన్అప్ అభ్యర్థన సందేశాన్ని';
$string['error:cannotsendrequestuser'] = 'మీ ఇమెయిల్ ఖాతాకు సైన్అప్ అభ్యర్థన సందేశాన్ని పంపడంలో సమస్య ఉంది.';
$string['error:canttakeattendanceforunstartedsession'] = 'ఇంకా ప్రారంభమయ్యే ఒక సెషన్కు హాజరు కాలేరు.';
$string['error:couldnotaddfield'] = 'అనుకూల సెషన్ ఫీల్డ్ను జోడించడం సాధ్యం కాలేదు.';
$string['error:couldnotaddnotice'] = 'సైట్ నోటీసుని జోడించడం సాధ్యం కాలేదు.';
$string['error:couldnotaddsession'] = 'సెషన్ను జోడించడం సాధ్యపడలేదు';
$string['error:couldnotaddtrainer'] = 'కొత్త ఫేస్-టు-ఫేస్ సెషన్ శిక్షణను సేవ్ చేయలేకపోయాము';
$string['error:couldnotcopysession'] = 'సెషన్ను కాపీ చేయడం సాధ్యం కాలేదు';
$string['error:couldnotdeletefield'] = 'అనుకూల సెషన్ ఫీల్డ్ని తొలగించలేరు';
$string['error:couldnotdeletenotice'] = 'సైట్ నోటీసుని తొలగించడం సాధ్యం కాలేదు';
$string['error:couldnotdeletesession'] = 'సెషన్ను తొలగించలేరు';
$string['error:couldnotdeletetrainer'] = 'ఫేస్-టు-ఫేస్ సెషన్ శిక్షణను తొలగించలేకపోయాము';
$string['error:couldnotfindsession'] = 'కొత్తగా చేర్చిన సెషన్ను కనుగొనలేకపోయాము';
$string['error:couldnotsavecustomfield'] = 'అనుకూల ఫీల్డ్ను సేవ్ చేయలేకపోయాము';
$string['error:couldnotupdatecalendar'] = 'క్యాలెండర్లో సెషన్ ఈవెంట్ను నవీకరించలే';
$string['error:couldnotupdatef2frecord'] = 'డేటాబేస్లో ముఖా ముఖి సైన్ అప్ రికార్డును నవీకరించడం సాధ్యపడలేదు';
$string['error:couldnotupdatefield'] = 'అనుకూల సెషన్ ఫీల్డ్ను నవీకరించడం సాధ్యపడలేదు.';
$string['error:couldnotupdatemanageremail'] = 'నిర్వాహకుని ఇమెయిల్ చిరునామాను నవీకరించలేరు.';
$string['error:couldnotupdatenotice'] = 'సైట్ నోటీసుని నవీకరించడం సాధ్యపడలేదు.';
$string['error:couldnotupdatesession'] = 'సెషన్ నవీకరించలేరు';
$string['error:coursemisconfigured'] = 'కోర్సు తప్పుగా కాన్ఫిగర్ చేయబడింది';
$string['error:cronprefix'] = 'లోపం: ముఖా ముఖి క్రోన్:';
$string['error:emptylocation'] = 'స్థానం ఖాళీగా ఉంది.';
$string['error:emptymanageremail'] = 'మేనేజర్ ఇమెయిల్ చిరునామా ఖాళీగా ఉంది.';
$string['error:emptyvenue'] = 'వేదిక ఖాళీగా ఉంది.';
$string['error:enrolmentfailed'] = 'కోర్సులో {$a} నమోదు చేయలేకపోయాము.';
$string['error:eventoccurred'] = 'మీరు ఇప్పటికే సంభవించిన ఒక ఈవెంట్ను రద్దు చేయలేరు.';
$string['error:f2ffailedupdatestatus'] = 'వినియోగదారుల స్థితిని నవీకరించడానికి ముఖా ముఖి విఫలమైంది';
$string['error:fieldidincorrect'] = 'ఫీల్డ్ ID తప్పు: {$a}';
$string['error:incorrectcoursemodule'] = 'కోర్సు మాడ్యూల్ తప్పు';
$string['error:incorrectcoursemoduleid'] = 'కోర్సు మాడ్యూల్ ID తప్పు';
$string['error:incorrectcoursemodulesession'] = 'కోర్సు మాడ్యూల్ ముఖా ముఖి సెషన్ తప్పు';
$string['error:incorrectfacetofaceid'] = 'ముఖా ముఖి ID తప్పు';
$string['error:incorrectnotificationtype'] = 'చెల్లని నోటిఫికేషన్ రకం సరఫరా చేయబడింది';
$string['error:invaliduserid'] = 'చెల్లని వినియోగదారు ID';
$string['error:manageremailaddressmissing'] = 'మీరు ప్రస్తుతం సిస్టమ్లో నిర్వాహకుడికి కేటాయించబడలేదు. దయచేసి సైట్ నిర్వాహకుడిని సంప్రదించండి.';
$string['error:mustspecifycoursemodulefacetoface'] = 'తప్పనిసరిగా కోర్సు మాడ్యూల్ లేదా ముఖా ముఖి ఐడిని పేర్కొనాలి';
$string['error:nomanageremail'] = 'మీ మేనేజర్ కోసం మీరు ఒక ఇమెయిల్ చిరునామాను అందించలేదు';
$string['error:nomanagersemailset'] = 'మేనేజర్ ఇమెయిల్ సెట్ చేయబడలేదు';
$string['error:nopermissiontosignup'] = 'ఈ ముఖా ముఖి సెషన్కు సైన్ అప్ చెయ్యడానికి మీకు అనుమతి లేదు.';
$string['error:noticeidincorrect'] = 'నోటీసు ID తప్పు: {$a}';
$string['error:problemsigningup'] = 'మిమ్మల్ని సైన్ అప్ చేస్తున్నప్పుడు సమస్య ఏర్పడింది.';
$string['error:removeattendee'] = 'సెషన్ నుండి {$a} తీసివేయడం సాధ్యం కాలేదు.';
$string['error:sessionstartafterend'] = 'సెషన్ ప్రారంభ తేదీ / సమయం ముగిసిన తర్వాత';
$string['error:shortnametaken'] = 'ఈ చిన్న పేరుతో కస్టమ్ ఫీల్డ్ ఇప్పటికే ఉంది';
$string['error:signedupinothersession'] = 'ఈ కార్యాచరణ కోసం మీరు మరొక సెషన్లో ఇప్పటికే సైన్ అప్ అయ్యారు. మీరు ముఖా ముఖి కార్యాచరణకు ఒక సెషన్ కోసం మాత్రమే సైన్ అప్ చేయవచ్చు.';
$string['error:unknownbuttonclicked'] = 'క్లిక్ చేసిన బటన్తో ఏ చర్య సంబంధం లేదు';
$string['eventaddsession'] = 'సెషన్ జోడించబడింది';
$string['eventaddsessionfailed'] = 'సెషన్ యాడ్ (FAILED)';
$string['eventapproverequests'] = 'సెషన్ ఆమోద అభ్యర్థనలు';
$string['eventattendancetaken'] = 'సెషన్ హాజరు తీసుకున్నది';
$string['eventattendeesviewed'] = 'సెషన్ హాజరైనవారు వీక్షించారు';
$string['eventcancelbooking'] = 'సెషన్ రద్దు బుకింగ్';
$string['eventcancelbookingfailed'] = 'సెషన్ రద్దు బుకింగ్ (FAILED)';
$string['eventcoursef2fviewed'] = 'కోర్సు ముఖం-నుండి-ఫేస్ సంభాషణలు వీక్షించబడ్డాయి';
$string['eventcoursemoduleviewed'] = 'ముఖా ముఖి మాడ్యూల్ ఇన్స్టాన్స్ చూచుటకు';
$string['eventdeletesession'] = 'సెషన్ తొలగించబడింది';
$string['eventdeletesessionfailed'] = 'సెషన్ తొలగింపు (FAILED)';
$string['eventsignup'] = 'సెషన్ సైన్అప్';
$string['eventsignupfailed'] = 'సెషన్ సైన్అప్ (FAILED)';
$string['eventtakeattendancefailed'] = 'సెషన్ హాజరు (FAILED)';
$string['eventupdatemanageremailfailed'] = 'మేనేజర్ ఇమెయిల్ అప్డేట్ (FAILED)';
$string['eventupdatesession'] = 'సెషన్ నవీకరించబడింది';
$string['eventupdatesessionfailed'] = 'సెషన్ నవీకరణ (FAILED)';
$string['excelformat'] = 'Excel';
$string['export'] = 'ఎగుమతి';
$string['exportattendance'] = 'ఎగుమతి హాజరు';
$string['exporttofile'] = 'ఫైల్కు ఎగుమతి చేయండి';
$string['facetoface'] = 'ముఖా ముఖి';
$string['facetoface:addattendees'] = 'ముఖాముఖి సెషన్కు హాజరైనవారిని జోడించండి';
$string['facetoface:addinstance'] = 'ఉదాహరణకు జోడించండి';
$string['facetoface:configurecancellation'] = 'ముఖాముఖి కార్యకలాపాలను జోడించడం / సవరించడం ద్వారా సైన్-అప్ రద్దుల కాన్ఫిగరేషన్ను అనుమతించండి.';
$string['facetoface:editsessions'] = 'ముఖా ముఖి సెషన్లను జోడించండి, సవరించండి, కాపీ చేయండి మరియు తొలగించండి';
$string['facetoface:overbook'] = 'పూర్తి సెషన్లకు సైన్-అప్ చేయండి.';
$string['facetoface:removeattendees'] = 'ముఖా ముఖి సెషన్ నుండి హాజరైన వారిని తీసివేయండి';
$string['facetoface:signup'] = 'సెషన్ కోసం సైన్-అప్ చేయండి';
$string['facetoface:takeattendance'] = 'హాజరు తీసుకోండి';
$string['facetoface:view'] = 'ముఖా ముఖి కార్యకలాపాలు మరియు సెషన్లను వీక్షించండి';
$string['facetoface:viewattendees'] = 'హాజరు జాబితా మరియు హాజరైనవారిని వీక్షించండి';
$string['facetoface:viewcancellations'] = 'వీక్షణ రద్దులను చూడండి';
$string['facetoface:viewemptyactivities'] = 'ముఖా ముఖి కార్యకలాపాలను ఖాళీగా వీక్షించండి';
$string['facetofacebooking'] = 'ముఖా ముఖి బుకింగ్';
$string['facetofacename'] = 'ముఖా ముఖి పేరు';
$string['facetofacesession'] = 'ముఖా ముఖి సెషన్';
$string['feedback'] = 'అభిప్రాయం';
$string['feedbackupdated'] = '\\ {$a} వ్యక్తుల కోసం అభిప్రాయం నవీకరించబడింది';
$string['field:multiselect'] = 'బహుళ ఎంపిక';
$string['field:select'] = 'ఎంపికల మెనూ';
$string['field:text'] = 'టెక్స్ట్';
$string['fielddeleteconfirm'] = 'ఫీల్డ్ను \'{$a}\' మరియు దానికి సంబంధించిన అన్ని సెషన్ డేటాను తొలగించాలా?';
$string['floor'] = 'అంతస్తు';
$string['format'] = 'ఫార్మాట్';
$string['full'] = 'తేదీ పూర్తిగా ఆక్రమించబడింది';
$string['goback'] = 'వెనక్కి వెళ్ళు';
$string['guestsno'] = 'క్షమించండి, సెషన్లకు సైన్ అప్ చేయడానికి అతిథులు అనుమతించబడవు.';
$string['icalendarheading'] = 'iCalendar అటాచ్మెంట్లు';
$string['import'] = 'దిగుమతి';
$string['info'] = 'సమాచారం';
$string['late'] = '\\ {$a} ఆలస్యం';
$string['location'] = 'స్థానం';
$string['location_help'] = '** స్థానం ** సెషన్ సమీపంలో వివరిస్తుంది (నగరం, కౌంటీ, ప్రాంతం, మొదలైనవి).

** స్థానం పేజీలో ** ప్రదర్శనలు, \'సైన్-అప్ పేజ్\', \'అన్ని సెషన్ల పేజీ\', మరియు అన్ని ఇమెయిల్ నోటిఫికేషన్లలో ప్రదర్శిస్తుంది.

\'అన్ని సెషన్లను వీక్షించండి\' పేజీలో, జాబితా చేయబడిన సెషన్లను నగర ద్వారా ఫిల్టర్ చేయవచ్చు.';
$string['lookfor'] = 'శోధన';
$string['manageradded'] = 'మీ నిర్వాహకుని ఇమెయిల్ చిరునామా ఆమోదించబడింది.';
$string['managerchanged'] = 'మీ నిర్వాహకుని ఇమెయిల్ చిరునామా మార్చబడింది.';
$string['manageremail'] = 'నిర్వాహకుని ఇమెయిల్';
$string['manageremailaddress'] = 'నిర్వాహకుని ఇమెయిల్ చిరునామా';
$string['manageremailformat'] = 'ఇమెయిల్ చిరునామా తప్పనిసరిగా ఆమోదించబడే \'{$a}\' ఆకృతిలో ఉండాలి.';
$string['manageremailheading'] = 'మేనేజర్ ఇమెయిల్లు';
$string['manageremailinstruction'] = 'ఒక శిక్షణ సెషన్ కోసం సైన్ అప్ చేయడానికి, నిర్ధారణ ఇమెయిల్ మీ ఇమెయిల్ చిరునామాకు పంపబడాలి మరియు మీ మేనేజర్ యొక్క ఇమెయిల్ చిరునామాకు కాపీ చేయబడాలి.';
$string['manageremailinstructionconfirm'] = 'దయచేసి ఇది మీ నిర్వాహకుని ఇమెయిల్ చిరునామా అని నిర్ధారించండి:';
$string['managername'] = 'నిర్వాహకుని పేరు';
$string['managerupdated'] = 'మీ నిర్వాహకుని ఇమెయిల్ చిరునామా అప్డేట్ చెయ్యబడింది.';
$string['maximumpoints'] = 'గరిష్ట సంఖ్యల సంఖ్య';
$string['maximumsize'] = 'హాజరైనవారి సంఖ్య';
$string['message'] = 'కోర్సు లో బుకింగ్ మార్చండి {$a->coursename}!

{$a->duedate} ({$a->name}) లో {$a->coursename} లో సెషన్లో ఖాళీ స్థలం ఉంది.
మీరు రిజిస్టర్ చెయ్యబడ్డారు. తేదీ ఇకమీదట మీకు సరిపోకపోతే, దయచేసి <a href=\'{$a->url} \'> {$a->url} లో నమోదు చేయనిది.';
$string['mods_help'] = 'కోర్సు లో బుకింగ్ మార్చండి {$a->coursename}!

{$a->duedate} ({$a->name}) లో {$a->coursename} లో సెషన్లో ఖాళీ స్థలం ఉంది.
మీరు రిజిస్టర్ చెయ్యబడ్డారు. తేదీ ఇకమీదట మీకు సరిపోకపోతే, దయచేసి <a href=\'{$a->url} \'> {$a->url} లో నమోదు చేయనిది.';
$string['modulename'] = 'ముఖా ముఖి';
$string['modulename_help'] = 'ముఖా ముఖి యాక్టివిటీ మాడ్యూల్ ఒక గురువును ఒక వ్యక్తి లేదా తరగతిలో ఆధారిత / సెషన్ల కోసం ఒక స్వచ్ఛంద బుకింగ్ వ్యవస్థను ఏర్పాటు చేయడానికి అనుమతిస్తుంది.

ఫేస్-టు-ఫేస్ సూచించే లోపల ప్రతి సెషన్ నగర, వేదిక, ప్రారంభ సమయం, ముగింపు సమయం, వ్యయం, సామర్ధ్యం మొదలైన వాటి చుట్టూ అనుకూలీకరించిన సెట్టింగులను కలిగి ఉంటుంది. వీటిని పలు రోజుల పాటు అమలు చేయడానికి లేదా అనుకోని మరియు వెయిట్ లిస్ట్ చేయబడిన సెషన్ల కోసం అనుమతించడానికి అమర్చవచ్చు.

మేనేజర్ ఆమోదం అవసరం కోసం కార్యాచరణను సెట్ చేయవచ్చు మరియు ఉపాధ్యాయులు హాజరైనవారికి స్వయంచాలక నోటిఫికేషన్లను మరియు సెషన్ రిమైండర్లను కాన్ఫిగర్ చేయవచ్చు.

విద్యార్థులు వారి హాజరు తో సెషన్స్ కోసం వీక్షించడానికి మరియు సైన్ అప్ చూడవచ్చు మరియు గ్రేడ్లు ప్రాంతంలో నమోదు.';
$string['modulenameplural'] = 'ముఖా ముఖి';
$string['moreinfo'] = 'మరింత సమాచారం';
$string['multidate'] = '(బహుళ తేదీ)';
$string['newmanageremailaddress'] = 'నిర్వాహకుని ఇమెయిల్ చిరునామా';
$string['noactionableunapprovedrequests'] = 'చర్య తీసుకోని అభ్యర్థనలు లేవు';
$string['nocustomfields'] = '<p> అనుకూల ఖాళీలను ఏవీ నిర్వచించబడలేదు. </ p>';
$string['nofacetofaces'] = 'ముఖాముఖి కార్యకలాపాలు ఏవీ లేవు';
$string['none'] = 'ఎవరూ';
$string['noremindersneedtobesent'] = 'రిమైండర్లు పంపబడవలసిన అవసరం లేదు.';
$string['normalcost'] = 'సాధారణ వ్యయం';
$string['normalcost_help'] = 'సభ్యత్వ ఐడి లేని సిబ్బంది సభ్యులకు చెల్లించే డాలర్ మొత్తాన్ని సాధారణ వ్యయం.

సెషన్లో హాజరయ్యే ప్రతి సిబ్బంది సభ్యుల కోసం కోర్సు యొక్క ధర కాలమ్లో సాధారణ వ్యయం కనిపిస్తుంది (డిస్కౌంట్ వ్యయం ప్రవేశించకపోతే మరియు సెషన్ సంతకం చేసేటప్పుడు సిబ్బంది సభ్యుడు సభ్యత్వం ఐడిలో ప్రవేశిస్తారు).';
$string['nosignedupusers'] = 'ఈ సెషన్ కోసం యూజర్లు సైన్-అప్ చేయలేదు';
$string['nositenotices'] = '<p> సైట్ నోటీసులు ఏవీ నిర్వచించబడలేదు. </ p>';
$string['note'] = 'గమనిక';
$string['notefull'] = 'సెషన్ పూర్తిగా బుక్ చేసినప్పటికీ మీరు ఇంకా నమోదు చేసుకోవచ్చు. మీరు క్యూలో పెట్టబడతారు (ఎరుపు రంగులో గుర్తించబడింది). ఎవరైనా సైన్ అవుట్ చేస్తే, క్యూలో మొదటి విద్యార్ధి రిజిస్టీర్స్ విద్యార్థులకు తరలించబడతారు మరియు మెయిల్ ద్వారా అతడికి ఒక నోటిఫికేషన్ పంపబడుతుంది.';
$string['noticedeleteconfirm'] = 'సైట్ ప్రకటనను \'{$a->name}\' తొలగించండి? <br/> <blockquote> {$a->text} </ blockquote>';
$string['noticetext'] = 'టెక్స్ట్ గమనించండి';
$string['notificationboth'] = 'ఇమెయిల్ నోటిఫికేషన్ మరియు iCalendar నియామకం';
$string['notificationemail'] = 'ఇమెయిల్ నోటిఫికేషన్ మాత్రమే';
$string['notificationical'] = 'iCalendar నియామకం మాత్రమే';
$string['notificationtype'] = 'నోటిఫికేషన్ పద్ధతి';
$string['notificationtype_help'] = 'నోటిఫికేషన్ పద్ధతి అభ్యాసకుడు వారి బుకింగ్కు ఎలా తెలియజేయబడుతుందో ఎంచుకోవడానికి అనుమతిస్తుంది.

* iCalendar అపాయింట్మెంట్ మాత్రమే
* ఇమెయిల్ నోటిఫికేషన్ మాత్రమే
* ఇమెయిల్ నోటిఫికేషన్ మరియు iCalendar నియామకం';
$string['notsignedup'] = 'మీరు ఈ సెషన్ కోసం సైన్ అప్ చేయలేదు.';
$string['notsubmittedyet'] = 'ఇంకా పరిశీలించలేదు';
$string['noupcoming'] = '<p> <i> రాబోయే సెషన్లు లేవు </ i> </ p>';
$string['odsformat'] = 'ఓపెన్ డాక్యుమెంట్';
$string['onehour'] = '1 గంట';
$string['oneminute'] = '1 నిమిషం';
$string['options'] = 'ఎంపికలు';
$string['or'] = 'లేదా';
$string['order'] = 'ఆర్డర్';
$string['place'] = 'గది';
$string['placeholder:alldates'] = '[alldates]';
$string['placeholder:attendeeslink'] = '[attendeeslink]';
$string['placeholder:cost'] = '[ఖరీదు]';
$string['placeholder:details'] = '[వివరాలు]';
$string['placeholder:duration'] = '[వ్యవధి]';
$string['placeholder:facetofacename'] = '[facetofacename]';
$string['placeholder:finishtime'] = '[finishtime]';
$string['placeholder:firstname'] = '[మొదటి పేరు]';
$string['placeholder:lastname'] = '[చివరి పేరు]';
$string['placeholder:reminderperiod'] = '[reminderperiod]';
$string['placeholder:sessiondate'] = '[sessiondate]';
$string['placeholder:starttime'] = '[starttime]';
$string['pluginadministration'] = 'ఫేస్-టు-ఫేస్ అడ్మినిస్ట్రేషన్';
$string['pluginname'] = 'ముఖా ముఖి';
$string['points'] = 'పాయింట్లు';
$string['pointsplural'] = 'పాయింట్లు';
$string['potentialattendees'] = 'సంభావ్య హాజరైనవారు';
$string['previoussessions'] = 'మునుపటి సెషన్లు';
$string['printversionid'] = 'ముద్రణ సంస్కరణ: పేరు లేకుండా';
$string['printversionname'] = 'ముద్రణ సంస్కరణ: పేరుతో';
$string['privacy:metadata:facetoface_session_roles'] = 'ఒక facetoface సెషన్లో ఒక శిక్షణ పాత్ర కలిగిన వినియోగదారులు జాబితా చేస్తుంది';
$string['privacy:metadata:facetoface_signups'] = 'ఫేస్-టు-ఫేస్ సెషన్లకు వినియోగదారు సైన్అప్లు';
$string['privacy:metadata:facetoface_signups:discountcode'] = 'వినియోగదారు ద్వారా ప్రవేశించిన డిస్కౌంట్ కోడ్';
$string['privacy:metadata:facetoface_signups:id'] = 'సైన్అప్ యొక్క ఐడి';
$string['privacy:metadata:facetoface_signups:mailedreminder'] = 'రిమైండర్ చివరిసారి పంపబడింది';
$string['privacy:metadata:facetoface_signups:notificationtype'] = 'ఎలా యూజర్ తెలియజేయాలనుకుంటున్నారు.';
$string['privacy:metadata:facetoface_signups:sessionid'] = 'సెషన్ ఐడి';
$string['privacy:metadata:facetoface_signups_status'] = 'సెషన్కు వినియోగదారు సైన్అప్ యొక్క స్థితి';
$string['privacy:metadata:facetoface_signups_status:grade'] = 'సెషన్కు హాజరు అయ్యే గ్రేడ్';
$string['privacy:metadata:facetoface_signups_status:note'] = 'రద్దు చేయబడిన సెషన్కు కారణం అవుతోంది';
$string['privacy:metadata:facetoface_signups_status:signupid'] = 'సైన్అప్ యొక్క ఐడి';
$string['privacy:metadata:facetoface_signups_status:statuscode'] = 'సైన్అప్ యొక్క ఉదా ఉదాహరించిన స్థితి రద్దు చేయబడింది, తిరస్కరించబడింది, పూర్తిగా_అందించబడింది';
$string['privacy:metadata:facetoface_signups_status:timecreated'] = 'సైన్అప్ సృష్టించబడిన సమయం.';
$string['privacy:metadata:roleid'] = 'యూజర్ యొక్క పాత్ర ID.';
$string['privacy:metadata:userid'] = 'Face-to-Face కార్యాచరణను ప్రాప్యత చేసిన వినియోగదారు ID';
$string['really'] = 'మీరు ఈ ఫేస్-టు-ఫేస్ కోసం అన్ని ఫలితాలను ఖచ్చితంగా తొలగించాలనుకుంటున్నారా?';
$string['registeredon'] = 'నమోదు చేయబడింది';
$string['registrations'] = 'రిజిస్ట్రేషన్లు';
$string['reminder'] = 'రిమైండర్';
$string['reminderinstrmngr'] = 'మేనేజర్ కోసం నోటీసు';
$string['reminderinstrmngr_help'] = '** నిర్వాహకుడికి నోటీసు పంపడం ** తనిఖీ చేయబడితే, మేనేజర్ ** ఫీల్డ్ కోసం ** నోటిఫికేషన్లోని టెక్స్ట్ వారు ఒక ఫేస్-టు-ఫేస్ సెషన్ కోసం సంతకం చేసిన అభ్యాసకుడి మేనేజర్కి పంపబడుతుంది.';
$string['remindermessage'] = 'రిమైండర్ సందేశం';
$string['remindermessage_help'] = 'సెషన్ ప్రారంభ తేదీకి కొద్ది రోజుల ముందు ఈ సందేశం పంపబడుతుంది.';
$string['reminderperiod'] = 'సందేశాన్ని పంపడానికి ముందు రోజులు పంపబడతాయి';
$string['reminderperiod_help'] = 'రిమైండర్ సందేశం సెషన్ ప్రారంభమవడానికి ఈ చాలా రోజుల ముందు పంపబడుతుంది.';
$string['requestmessage'] = 'సందేశాన్ని అభ్యర్థించండి';
$string['requestmessage_help'] = '** ఆమోదం అవసరమైనప్పుడు ** ప్రారంభించబడినప్పుడు, ** అభ్యర్ధన సందేశం ** విభాగం అందుబాటులో ఉంది.

ఫేస్-టు-ఫేస్ సెషన్కు హాజరు కావడానికి అభ్యాసకుడికి ఆమోదం ప్రక్రియకు సంబంధించి ** అభ్యర్ధన సందేశం ** విభాగం అభ్యాసకులకు మరియు వారి మేనేజర్కి పంపిన నోటీసులను ప్రదర్శిస్తుంది.

** విషయం: ** మేనేజర్ మరియు అభ్యాసకుడు పంపిన అభ్యర్థన ఆమోదం ఇమెయిల్స్ కనిపించే విషయం లైన్.

** సందేశం: ** ఫేస్-టు-ఫేస్ సెషన్కు హాజరు కావాలనే వారి అభ్యర్ధన ఆమోదం కోసం వారి మేనేజర్కు పంపబడిందని వారికి అభ్యాసకుడికి పంపిన ఇమెయిల్ టెక్స్ట్.

** మేనేజర్ కోసం నోటీసు: ** ఫేస్-టు-ఫేస్ సెషన్కు హాజరు కావడానికి అభ్యర్ధి యొక్క మేనేజర్ అభ్యర్థన ఆమోదించిన ఇమెయిల్ టెక్స్ట్.';
$string['room'] = 'గది';
$string['room_help'] = '** గది ** అనేది శిక్షణా కోసం ఉపయోగించే గది పేరు / సంఖ్య / ఐడెంటిఫైయర్.

* సైన్-అప్ పేజీలో ** రూమ్ ** ప్రదర్శనలు, \'అన్ని సెషన్ల పేజీని వీక్షించండి\' మరియు అన్ని ఇమెయిల్ నోటిఫికేషన్లలో.';
$string['saveallfeedback'] = 'అన్ని ప్రతిస్పందనలను సేవ్ చేయండి';
$string['saveattendance'] = 'హాజరు సేవ్';
$string['scheduledsession'] = 'షెడ్యూల్డ్ సెషన్';
$string['scheduledsessions'] = 'షెడ్యూల్డ్ సెషన్స్';
$string['search:activity'] = 'Facetoface కార్యకలాపాలు';
$string['seatsavailable'] = 'అందుబాటులో ఉన్న సీట్లు';
$string['seeattendees'] = 'హాజరైనవారిని చూడండి';
$string['sentremindermanager'] = 'యూజర్ మేనేజర్కు రిమైండర్ ఇమెయిల్ను పంపించారు';
$string['sentreminderuser'] = 'వినియోగదారుకు రిమైండర్ ఇమెయిల్ను పంపించారు';
$string['sessiondate'] = 'సెషన్ తేదీ సెషన్ సంభవించే తేదీ';
$string['sessiondatetime'] = 'సెషన్ తేదీ / సమయం';
$string['sessiondatetimeknown'] = 'సెషన్ తేదీ / సమయం తెలిసిన';
$string['sessiondatetimeknown_help'] = '** ఒక సెషన్ తేదీ / సమయం తెలిసినట్లయితే **

ఈ అమరిక కోసం "అవును" ఎంటర్ చేసినట్లయితే, సెషన్ తేదీ మరియు సమయం కోర్సు పేజీలో ప్రదర్శించబడుతుంది (సెషన్ రాబోయే మరియు అందుబాటులో ఉంటే), "అన్ని సెషన్ల పేజీని వీక్షించండి", సెషన్ సైన్-అప్ పేజీ, అలాగే సెషన్కు సంబంధించిన అన్ని ఇమెయిల్ నోటిఫికేషన్లు.

తెలిసిన తేదీ మరియు సమయంతో ఒక సెషన్ కోసం ఒక సభ్యుడు సైన్ అప్ చేసినప్పుడు:

* సిబ్బంది మరియు సిబ్బంది యొక్క నిర్వాహకుడు ఒక నిర్ధారణ ఇమెయిల్ను పంపవచ్చు (అనగా ఫేస్-టు-ఫేస్ ఇన్స్టాన్స్ సెట్టింగుల "నిర్ధారణ సందేశం" విభాగానికి ఫార్మాట్ చేయబడినది).
* సిబ్బంది రిమైండర్ ఇమెయిల్ సందేశాన్ని పంపవచ్చు (అనగా ఫేస్-టు-ఫేస్ ఇన్స్టాన్స్ సెట్టింగులలో "రిమైండర్ సందేశం" విభాగానికి ఫార్మాట్ చేయబడినది). ఫేస్-టు-ఫేస్ ఇన్స్టాన్స్ సెట్టింగులలో "రిమైండర్ మెసేజ్" విభాగంలో కూడా "రిమైండర్ సందేశం పంపబడే ముందు" అమరిక ప్రకారం సెషన్కు ముందు కొన్ని రోజుల రిమైండర్ పంపబడుతుంది.

** ఒక సెషన్ తేదీ / సమయం తెలియదు (లేదా వేచి-జాబితా) **

ఈ సెట్టింగుకు "నో" ఎంటర్ చేస్తే, పాఠం "వేచి-జాబితా చేయబడినది" కోర్సు పేజీలో ప్రదర్శించబడుతుంది, "అన్ని సెషన్ల పేజీని వీక్షించండి", సెషన్ సైన్-అప్ పుట, సెషన్కు సంబంధించిన అన్ని ఇమెయిల్ నోటిఫికేషన్లు .

ఉద్యోగం-జాబితాలో ఉన్న సెషన్ కోసం ఒక సభ్యుడు సైన్ అప్ చేసినప్పుడు:

* సిబ్బంది ఒక నిర్ధారణ ఇమెయిల్ను పంపవచ్చు (అనగా ఫేస్-టు-ఫేస్ ఇన్స్టాన్స్ సెట్టింగులలో "వెయిట్-లిస్ట్ మెసేజ్" విభాగానికి ఫార్మాట్ చేయబడినది).
* సిబ్బంది రిమైండర్ ఇమెయిల్ సందేశాన్ని పంపరు.
* సిబ్బంది యొక్క నిర్వాహకుడు నిర్ధారణ మరియు రద్దు ఇమెయిల్ సందేశాలు పంపబడవు.';
$string['sessionfinishtime'] = 'సెషన్ ముగింపు సమయం';
$string['sessioninprogress'] = 'సెషన్ ప్రోగ్రెస్లో ఉంది';
$string['sessionisfull'] = 'ఈ సెషన్ నిండింది. మీరు మరొక సమయాన్ని ఎంచుకోవాలి లేదా బోధకుడు మాట్లాడాలి';
$string['sessionover'] = 'సెషన్ మీద';
$string['sessionrequiresmanagerapproval'] = 'ఈ సెషన్కు మేనేజర్ ఆమోదం అవసరం.';
$string['sessionroles'] = 'సెషన్ పాత్రలు';
$string['sessions'] = 'సెషన్స్';
$string['sessionsoncoursepage'] = 'సెషన్లు కోర్సు పేజీలో ప్రదర్శించబడతాయి';
$string['sessionsoncoursepage_help'] = 'ప్రధాన కోర్సు పేజీలో చూపబడే ప్రతి ఫేస్-టు-ఫేస్ సూచించే సెషన్ల సంఖ్య ఇది.';
$string['sessionstartdate'] = 'సెషన్ ప్రారంభ తేదీ';
$string['sessionstarttime'] = 'సెషన్ ప్రారంభ సమయం';
$string['sessionvenue'] = 'సెషన్ వేదిక';
$string['setting:addchangemanageremail'] = 'వారి మేనేజర్ యొక్క ఇమెయిల్ చిరునామా కోసం వినియోగదారులను అడగండి.';
$string['setting:addchangemanageremail_caption'] = 'నిర్వాహకుని ఇమెయిల్:';
$string['setting:addchangemanageremaildefault'] = 'వారి మేనేజర్ యొక్క ఇమెయిల్ చిరునామా కోసం వినియోగదారులను అడగండి.';
$string['setting:defaultcancellationinstrmngr'] = 'నిర్వాహకులకు డిఫాల్ట్ రద్దు సందేశం పంపబడింది';
$string['setting:defaultcancellationinstrmngr_caption'] = 'రద్దు సందేశం (నిర్వాహకులు)';
$string['setting:defaultcancellationinstrmngrdefault'] = '*** సలహా మాత్రమే ****

ఈ కింది కోర్సు కోసం [మొదటి పేరు] [చివరి పేరు] ఇకపై సంతకం చేయలేదు మరియు వారి బృందం నాయకుడు / మేనేజర్గా మీకు జాబితా చేయబడాలని సూచించారు.

*** [మొదటి పేరు] [చివరి పేరు] యొక్క బుకింగ్ రద్దు క్రింద కాపీ చేయబడింది ****';
$string['setting:defaultcancellationmessage'] = 'వినియోగదారుకు డిఫాల్ట్ రద్దు సందేశం పంపబడింది.';
$string['setting:defaultcancellationmessage_caption'] = 'రద్దు సందేశం';
$string['setting:defaultcancellationmessagedefault'] = 'ఈ క్రింది కోర్సులో మీ బుకింగ్ రద్దు చెయ్యబడింది:

*** బుకింగ్ క్యాజెల్డ్ ***

పాల్గొనేవారు: [మొదటిపేరు] [చివరిపేరు]
కోర్సు: [facetofacename]

వ్యవధి: [వ్యవధి]
తేదీ (లు):
[Alldates]

స్థానం: [సెషన్: స్థానం]
వేదిక: [సెషన్: వేదిక]
గది: [సెషన్: గది]';
$string['setting:defaultcancellationsubject'] = 'రద్దు ఇమెయిల్స్ కోసం డిఫాల్ట్ విషయం లైన్.';
$string['setting:defaultcancellationsubject_caption'] = 'రద్దు విషయం';
$string['setting:defaultcancellationsubjectdefault'] = 'కోర్సు బుకింగ్ రద్దు';
$string['setting:defaultconfirmationinstrmngr'] = 'నిర్వాహకులకు డిఫాల్ట్ నిర్ధారణ సందేశం పంపబడింది.';
$string['setting:defaultconfirmationinstrmngr_caption'] = 'నిర్ధారణ సందేశం (నిర్వాహకులు)';
$string['setting:defaultconfirmationinstrmngrdefault'] = '*** సలహా మాత్రమే ****

ఈ కింది కోర్సు కోసం [మొదటి పేరు] [చివరి పేరు] బుక్ చేయబడి, వారి బృందం నాయకుడు / మేనేజర్గా మీకు జాబితా చేయబడిందని సూచించడం.

మీరు వారి టీమ్ లీడర్ / మేనేజర్ కాకపోతే మరియు మీరు ఈ ఇమెయిల్ను పొరపాటున అందుకున్నట్లు విశ్వసిస్తే ఈ ఇమెయిల్కు ప్రత్యుత్తరం ఇవ్వండి. ఈ కోర్సు తీసుకొని మీ సిబ్బంది గురించి ఆందోళన కలిగి ఉంటే, దయచేసి వాటిని నేరుగా చర్చించండి.

*** [మొదటి పేరు] [చివరి పేరు] బుకింగ్ నిర్ధారణ క్రింద కాపీ చేయబడింది ****';
$string['setting:defaultconfirmationmessage'] = 'వినియోగదారులకు డిఫాల్ట్ నిర్ధారణ సందేశం పంపబడింది.';
$string['setting:defaultconfirmationmessage_caption'] = 'నిర్ధారణ సందేశం';
$string['setting:defaultconfirmationmessagedefault'] = 'ఈ కింది కోర్సులో మీరు ఇప్పుడు బుక్ చేయబడ్డారని ధృవీకరించాలి:

పాల్గొనేవారు: [మొదటిపేరు] [చివరిపేరు]
కోర్సు: [facetofacename]
ఖర్చు: [ఖర్చు]

వ్యవధి: [వ్యవధి]
తేదీ (లు):
[Alldates]

స్థానం: [సెషన్: స్థానం]
వేదిక: [సెషన్: వేదిక]
గది: [సెషన్: గది]

*** కోర్సు మొదలవుతుంది ముందు దయచేసి పది నిమిషాలు చేరుకోండి ***

మీ బుకింగ్ను మళ్లీ షెడ్యూల్ చేయడానికి లేదా రద్దు చేయడానికి
మీ బుకింగ్ను తిరిగి షెడ్యూల్ చేయడానికి మీరు ఈ బుకింగ్ను రద్దు చేసి, కొత్త సెషన్ను మళ్ళీ బుక్ చేసుకోవాలి. మీ బుకింగ్ రద్దు చేయడానికి, సైట్కు తిరిగి, ఈ కోర్సు కోసం పేజీకి వెళ్లి, బుకింగ్ సమాచార స్క్రీన్ నుండి \'రద్దు\' ఎంచుకోండి.

[వివరాలు]

ఈ కోర్సుకు ముందు మీరు రిమైండర్ [రిమైండర్పర్యాడ్] వ్యాపార రోజుల అందుకుంటారు.';
$string['setting:defaultconfirmationsubject'] = 'నిర్ధారణ ఇమెయిల్స్ కోసం డిఫాల్ట్ విషయం లైన్.';
$string['setting:defaultconfirmationsubject_caption'] = 'నిర్ధారణ అంశం';
$string['setting:defaultconfirmationsubjectdefault'] = 'కోర్సు బుకింగ్ నిర్ధారణ: [facetofacename], [starttime] - [ముగింపు సమయం], [sessiondate]';
$string['setting:defaultreminderinstrmngr'] = 'డిఫాల్ట్ రిమైండర్ సందేశం నిర్వాహకులకు పంపబడింది';
$string['setting:defaultreminderinstrmngr_caption'] = 'రిమైండర్ సందేశం (నిర్వాహకులు)';
$string['setting:defaultreminderinstrmngrdefault'] = '*** రిమైండర్ మాత్రమే ****

మీ సిబ్బంది [మొదటి పేరు] [చివరి పేరు] కోర్సుకు హాజరు కావడానికి మరియు దానిపైకి బుక్ చేయబడుతుంది మరియు ఈ రిమైండర్ ఇమెయిల్ కూడా పొందింది.

మీరు వారి టీమ్ లీడర్ / మేనేజర్ కాకపోతే మరియు మీరు ఈ ఇమెయిల్ను పొరపాటున అందుకున్నట్లు విశ్వసిస్తే ఈ ఇమెయిల్కు ప్రత్యుత్తరం ఇవ్వండి.

*** [మొదటి పేరు] [చివరి పేరు] యొక్క రిమైండర్ ఇమెయిల్ క్రింద కాపీ చేయబడింది ****';
$string['setting:defaultremindermessage'] = 'వినియోగదారులకు డిఫాల్ట్ రిమైండర్ సందేశం పంపబడింది.';
$string['setting:defaultremindermessage_caption'] = 'రిమైండర్ సందేశం';
$string['setting:defaultremindermessagedefault'] = 'ఈ కింది కోర్సులో మీరు బుక్ చేయబడిన ఒక రిమైండర్:

పాల్గొనేవారు: [మొదటిపేరు] [చివరిపేరు]
కోర్సు: [facetofacename]
ఖర్చు: [ఖర్చు]

వ్యవధి: [వ్యవధి]
తేదీ (లు):
[Alldates]

స్థానం: [సెషన్: స్థానం]
వేదిక: [సెషన్: వేదిక]
గది: [సెషన్: గది]

*** కోర్సు మొదలవుతుంది ముందు దయచేసి పది నిమిషాలు చేరుకోండి ***

మీ బుకింగ్ను మళ్లీ షెడ్యూల్ చేయడానికి లేదా రద్దు చేయడానికి
మీ బుకింగ్ను తిరిగి షెడ్యూల్ చేయడానికి మీరు ఈ బుకింగ్ను రద్దు చేసి, కొత్త సెషన్ను మళ్ళీ బుక్ చేసుకోవాలి. మీ బుకింగ్ రద్దు చేయడానికి, సైట్కు తిరిగి, ఈ కోర్సు కోసం పేజీకి వెళ్లి, బుకింగ్ సమాచార స్క్రీన్ నుండి \'రద్దు\' ఎంచుకోండి.

[వివరాలు]';
$string['setting:defaultremindersubject'] = 'రిమైండర్ ఇమెయిల్స్ కోసం డిఫాల్ట్ విషయం లైన్.';
$string['setting:defaultremindersubject_caption'] = 'రిమైండర్ విషయం';
$string['setting:defaultremindersubjectdefault'] = 'కోర్సు బుకింగ్ రిమైండర్: [facetofacename], [starttime] - [ముగింపు సమయం], [sessiondate]';
$string['setting:defaultrequestinstrmngrdefault'] = '[[మొదటి పేరు] [కింది పేరు] కింది కోర్సులో బుక్ చేయమని కోరింది, మరియు మీరు వారి టీం లీడర్ / మేనేజర్గా జాబితా చేయబడ్డారని సూచించడం.

కోర్సు: [facetofacename]
ఖర్చు: [ఖర్చు]

వ్యవధి: [వ్యవధి]
తేదీ (లు):
[Alldates]

స్థానం: [సెషన్: స్థానం]
వేదిక: [సెషన్: వేదిక]
గది: [సెషన్: గది]

దయచేసి అభ్యర్థనను ఆమోదించడానికి క్రింది లింక్ను అనుసరించండి:
[Attendeeslink] #unapproved


*** [మొదటి పేరు] [చివరి పేరు] బుకింగ్ అభ్యర్థన క్రింద కాపీ చేయబడింది ****';
$string['setting:defaultrequestmessagedefault'] = 'కింది కోర్సులో బుక్ చెయ్యడానికి మీ అభ్యర్థన మీ మేనేజర్కు పంపబడింది:

పాల్గొనేవారు: [మొదటిపేరు] [చివరిపేరు]
కోర్సు: [facetofacename]
ఖర్చు: [ఖర్చు]

వ్యవధి: [వ్యవధి]
తేదీ (లు):
[Alldates]

స్థానం: [సెషన్: స్థానం]
వేదిక: [సెషన్: వేదిక]
గది: [సెషన్: గది]';
$string['setting:defaultrequestsubjectdefault'] = 'కోర్సు బుకింగ్ అభ్యర్థన: [facetofacename], [starttime] - [ముగింపు సమయం]';
$string['setting:defaultvalue'] = 'డిఫాల్ట్ విలువ';
$string['setting:defaultwaitlistedmessage'] = 'వినియోగదారులకు పంపిన డిఫాల్ట్ వేచి ఉన్న-జాబితా సందేశం.';
$string['setting:defaultwaitlistedmessage_caption'] = 'వేచి ఉన్న జాబితా సందేశం';
$string['setting:defaultwaitlistedmessagedefault'] = 'ఈ కోసం మీరు వేచి ఉన్న జాబితాకు జోడించబడ్డారని సలహా ఇస్తారు:

కోర్సు: [facetofacename]
స్థానం: [సెషన్: స్థానం]
పాల్గొనేవారు: [మొదటిపేరు] [చివరిపేరు]

*** ఈ కోర్సు బుకింగ్ నిర్ధారణ కాదు గమనించండి ***

నిరీక్షణ ద్వారా మీరు ఈ కోర్సులో మీ ఆసక్తిని రిజిస్టర్ చేసి సెషన్లు అందుబాటులోకి వచ్చినప్పుడు నేరుగా సంప్రదించబడతారు.

ఈ వెయిట్లిస్ట్ నుండి మిమ్మల్ని తీసివేయడానికి దయచేసి ఈ కోర్సుకు తిరిగి వెళ్లి బుకింగ్ రద్దు చేయి క్లిక్ చేయండి. Waitlist తొలగింపు నిర్ధారణ ఇమెయిల్ లేదని గమనించండి';
$string['setting:defaultwaitlistedsubject'] = 'వేచి జాబితాలో ఉన్న ఇమెయిల్లకు డిఫాల్ట్ విషయం లైన్.';
$string['setting:defaultwaitlistedsubject_caption'] = 'వేచి-జాబితా చేయబడిన విషయం';
$string['setting:defaultwaitlistedsubjectdefault'] = '[Facetofacename] కోసం వెయిట్ లిస్టింగ్ సలహా';
$string['setting:disableicalcancel'] = 'ICalendar జోడింపుతో రద్దు ఇమెయిల్లను నిలిపివేయండి.';
$string['setting:disableicalcancel_caption'] = 'ICalendar రద్దులను నిలిపివేయి:';
$string['setting:fromaddress'] = 'ఈ మాడ్యూల్ పంపిన ఇమెయిల్ రిమైండర్ల నుండి ఏమవుతుంది.';
$string['setting:fromaddress_caption'] = 'పంపినవారు చిరునామా:';
$string['setting:fromaddressdefault'] = 'moodle@example.com';
$string['setting:hidecost'] = 'ఖర్చు మరియు డిస్కౌంట్ కోడ్ ఫీల్డ్లను దాచిపెట్టు.';
$string['setting:hidecost_caption'] = 'ఖర్చు మరియు డిస్కౌంట్ దాచు';
$string['setting:hidediscount'] = 'డిస్కౌంట్ కోడ్ ఫీల్డ్ మాత్రమే దాచు.';
$string['setting:hidediscount_caption'] = 'డిస్కౌంట్ దాచు:';
$string['setting:isfilter'] = 'ఫిల్టర్గా ప్రదర్శించు';
$string['setting:manageraddressformat'] = 'చెల్లుబాటు అయ్యే విధంగా పరిగణించబడే మేనేజర్ యొక్క ఇమెయిల్ చిరునామాలో ఇది తప్పక ఉండాలి.';
$string['setting:manageraddressformat_caption'] = 'అవసరమైన అంత్యప్రత్యయం';
$string['setting:manageraddressformatreadable'] = 'నిర్వాహకుని ఇమెయిల్ చిరునామాపై పరిమితుల యొక్క చిన్న వివరణ. మునుపటి సెట్ చేయబడకపోతే ఈ సెట్టింగ్కు ఎటువంటి ప్రభావం లేదు.';
$string['setting:manageraddressformatreadable_caption'] = 'ఫార్మాట్ ఉదాహరణ:';
$string['setting:manageraddressformatreadabledefault'] = 'firstname.lastname@company.com';
$string['setting:oneemailperday'] = 'బహుళ-రోజుల ఈవెంట్ల కోసం బహుళ నిర్ధారణ ఇమెయిల్లను పంపండి.';
$string['setting:oneemailperday_caption'] = 'రోజుకు ఒక సందేశం:';
$string['setting:possiblevalues'] = 'సాధ్యం విలువలు జాబితా';
$string['setting:sessionroles'] = 'కోర్సులో ఎంచుకున్న పాత్రలకు కేటాయించిన వినియోగదారులు ప్రతి ఫేస్-టు-ఫేస్ సెషన్తో ట్రాక్ చేయవచ్చు';
$string['setting:sessionroles_caption'] = 'సెషన్ పాత్రలు:';
$string['setting:showinsummary'] = 'ఎగుమతులు మరియు జాబితాలలో చూపించు';
$string['setting:type'] = 'ఫీల్డ్ రకం';
$string['shortname'] = '# చిన్న పేరు';
$string['shortname_help'] = '** చిన్న పేరు ** క్యాలెండర్లో ** ఎనేబుల్ అయినప్పుడు శిక్షణ క్యాలెండర్లో కనిపించే సెషన్ వివరణ.';
$string['showbylocation'] = 'స్థానం ద్వారా చూపించు';
$string['showoncalendar'] = 'క్యాలెండర్ ప్రదర్శన సెట్టింగ్లు';
$string['showoncalendar_help'] = '** సైట్ ** ఎంచుకున్నప్పుడు ఫేస్-టు-ఫేస్ సూచించే సెషన్లు సైట్ క్యాలెండర్లో గ్లోబల్ ఈవెంట్గా ప్రదర్శించబడతాయి. అన్ని సెషన్ వినియోగదారులు ఈ సెషన్లను వీక్షించగలరు.

** కోర్సు ** ఎంచుకున్నప్పుడు అన్ని ఫేస్-టు-ఫేస్ సూచీ సెషన్లు కోర్సు క్యాలెండర్లో మరియు సైట్ లెవల్ క్యాలెండర్లో కోర్సు ఈవెంట్ వలె ప్రదర్శించబడతాయి మరియు కోర్సులో నమోదు చేసుకున్న వినియోగదారులందరికీ కనిపించబడతాయి.

** ఏదీకాదు ** ఎంచుకున్నప్పుడు, ఫేస్-టు-ఫేస్ యాక్టివిటీ సెషన్లు వినియోగదారుని క్యాలెండర్లో ** ఎంపికను ఎంపిక చేసినట్లుగా నిర్ధారించబడిన హాజరీ యొక్క క్యాలెండర్లో వినియోగదారు ఈవెంట్స్గా మాత్రమే ప్రదర్శించబడుతుంది.';
$string['sign-ups'] = 'సైన్-అప్లను';
$string['signup'] = 'చేరడం';
$string['signupfor'] = '{$a} కోసం సైన్-అప్ చేయండి';
$string['signupforsession'] = 'అందుబాటులో ఉన్న సెషన్ కోసం సైన్-అప్ చేయండి';
$string['signupforthissession'] = 'ఈ ఫేస్-టు-ఫేస్ సెషన్ కోసం సైన్-అప్ చేయండి';
$string['signups'] = 'సైన్-అప్లను';
$string['sitenoticesheading'] = 'సైట్ నోటీసులు';
$string['status'] = 'స్థితి';
$string['status_approved'] = 'ఆమోదించబడింది';
$string['status_booked'] = 'బుక్';
$string['status_declined'] = 'తిరస్కరించబడింది';
$string['status_fully_attended'] = 'పూర్తిగా హాజరయ్యారు';
$string['status_no_show'] = 'ప్రదర్శన లేదు';
$string['status_partially_attended'] = 'పాక్షికంగా హాజరయ్యారు';
$string['status_requested'] = 'అభ్యర్థించిన';
$string['status_session_cancelled'] = 'సెషన్ రద్దు చేయబడింది';
$string['status_user_cancelled'] = 'వినియోగదారు రద్దు చేయబడింది';
$string['status_waitlisted'] = 'వేచి-జాబితా';
$string['subject'] = 'కోర్సులో బుకింగ్లో మార్చండి {$a->coursename} ({$a->duedate})';
$string['submissions'] = 'సమర్పణలు';
$string['submit'] = 'సమర్పించండి';
$string['submitted'] = 'Submitted';
$string['summary'] = 'సారాంశం';
$string['suppressemail'] = 'ఇమెయిల్ నోటిఫికేషన్ను అణచివేయండి';
$string['suppressemail_help'] = 'ఫేస్-టు-ఫేస్ సెషన్ నుండి నిశ్శబ్దంగా జోడించడానికి / తొలగించాలనుకుంటే ఈ ఎంపికను ఉపయోగించండి. ఈ ఎంపికను టోగుల్ చేసినప్పుడు, సాధారణ ఇమెయిల్
  ఎంచుకున్న వినియోగదారులకు నిర్ధారణ పంపబడదు.';
$string['takeattendance'] = 'హాజరు తీసుకోండి';
$string['thirdpartyemailaddress'] = 'మూడవ పక్ష ఇమెయిల్ చిరునామా (లు)';
$string['thirdpartyemailaddress_help'] = '** మూడో-వ్యక్తి ఇమెయిల్ చిరునామా (ఎస్) ** ఒక మూడవ-పక్షం (బాహ్య బోధకుడు వంటి) యొక్క ఇమెయిల్ చిరునామాను పేర్కొనడానికి ఉపయోగించే ఒక ఐచ్ఛిక ఫీల్డ్, అప్పుడు ఒక సెషన్ కోసం యూజర్ సైన్-అప్ చేసినప్పుడు నిర్ధారణ సందేశాలను అందుకుంటారు.
** బహుళ ఇమెయిల్ చిరునామాలను ఎంటర్ చేసేటప్పుడు **, కామాతో ప్రతి చిరునామాను వేరు చేయండి. ఉదాహరణకు: bob@example.com, joe@example.com';
$string['thirdpartywaitlist'] = 'వేచి-జాబితా సెషన్ల గురించి మూడవ పార్టీకి తెలియజేయండి';
$string['thirdpartywaitlist_help'] = '** వేచి-జాబితా సెషన్ల గురించి మూడవ-పార్టీకి తెలియజేయండి ** ఒక అభ్యాసకుడు వేచి ఉన్న జాబితా సెషన్ కోసం సైన్ అప్ చేసినప్పుడు మూడవ పార్టీ (లు) ఎంపిక చేయబడుతుంది. ఎప్పుడు

** వేచి-జాబితా సెషన్ల గురించి మూడవ పార్టీకి తెలియజేయండి ** ఒక షెడ్యూల్ సెషన్కు వినియోగదారు సైన్ అప్ (లేదా రద్దు చేస్తే) మూడవ పక్షం (లు) మాత్రమే తెలియజేయబడుతుంది.';
$string['time'] = 'సమయం';
$string['timecancelled'] = 'సమయం రద్దు చేయబడింది';
$string['timedue'] = 'నమోదు గడువు';
$string['timefinish'] = 'సమయం ముగించు';
$string['timefinish_help'] = 'సెషన్ ముగుస్తుంది సమయం ముగిసే సమయం.';
$string['timerequested'] = 'సమయం అభ్యర్థించబడింది';
$string['timesignedup'] = 'సమయం ముగిసింది';
$string['timestart'] = 'సమయం ప్రారంభించండి';
$string['timestart_help'] = 'ప్రారంభ సమయం సెషన్ ప్రారంభమైన సమయం';
$string['unapprovedrequests'] = 'ఆమోదించని అభ్యర్థనలు';
$string['unknowndate'] = '(తెలియని తేదీ)';
$string['unknowntime'] = '(తెలియని సమయం)';
$string['upcomingsessions'] = 'రానున్న సెషన్లు';
$string['upcomingsessionslist'] = 'ఈ ఫేస్-టు-ఫేస్ కార్యాచరణ కోసం అన్ని రాబోయే సెషన్ల జాబితా';
$string['updaterequests'] = 'నవీకరణ అభ్యర్థనలు';
$string['upgradeprocessinggrades'] = 'ఫేస్-టు-ఫేస్ గ్రేడింగ్లను ప్రోత్సహిస్తుంది, అనేక సెషన్లు ఉంటే ఇది కొంత సమయం పట్టవచ్చు ..';
$string['usercalentry'] = 'యూజర్ క్యాలెండర్లో ఎంట్రీని చూపించు';
$string['usercalentry_help'] = 'సక్రియంగా ఉన్నప్పుడు ఈ సెట్టింగ్ ఫేస్-టు-ఫేస్ సెషన్ యొక్క హాజరైన క్యాలెండర్కు వినియోగదారు ఈవెంట్ ఎంట్రీని జోడిస్తుంది. ఇది ఆపివేయబడినప్పుడు సెషన్ హాజరీ యొక్క క్యాలెండర్లో కనిపించే నకిలీ కార్యక్రమం నిరోధిస్తుంది, మీరు క్యాలెండర్ డిస్ప్లే సెట్టింగులు కోర్సు';
$string['usercancelledon'] = '{$a} లో వినియోగదారు రద్దు చేయబడింది';
$string['userdeletedcancel'] = 'వాడుకరి తొలగించబడింది';
$string['usernotsignedup'] = 'స్థితి: సంతకం చేయలేదు';
$string['usersignedup'] = 'స్థితి: సైన్ అప్';
$string['usersignedupon'] = 'వినియోగదారు {$a} పై సైన్ అప్ అయ్యారు';
$string['userwillbewaitlisted'] = 'ఈ సెషన్ ప్రస్తుతం పూర్తి. "సైన్-అప్" బటన్ను క్లిక్ చేయడం ద్వారా, మీరు సెషన్ల వేచి-జాబితాలో ఉంచబడతారు.';
$string['validation:needatleastonedate'] = 'మీరు కనీసం ఒక తేదీని అందించాలి లేదా వేచి ఉన్న జాబితాలో సెషన్ను గుర్తించాలి.';
$string['venue'] = 'వేదిక';
$string['venue_help'] = '** వేదిక ** సెషన్ లో జరుగుతుంది భవనం.

* సైన్-అప్ పేజీలో ** వేదిక ** ప్రదర్శనలు, \'అన్ని సెషన్ల పేజీని వీక్షించండి\' మరియు అన్ని ఇమెయిల్ నోటిఫికేషన్లలో.';
$string['viewallsessions'] = 'అన్ని సెషన్లను వీక్షించండి';
$string['viewsubmissions'] = 'సమర్పణలను వీక్షించండి';
$string['wait-list'] = 'వేచి-జాబితా';
$string['wait-listed'] = 'వేచి-జాబితా';
$string['waitlistedmessage'] = 'వేచి ఉన్న జాబితా సందేశం';
$string['waitlistedmessage_help'] = 'వేచి ఉన్న సెషన్ కోసం వినియోగదారులు సైన్-అప్ చేసినప్పుడు ఈ సందేశం పంపబడుతుంది.';
$string['waitliststatus'] = 'కింది సెషన్లో వేచి ఉన్న జాబితాలో మీకు స్థానం ఉంది';
$string['xhours'] = '{$a} గంటలు';
$string['xminutes'] = '{$a} నిమిషాలు';
$string['youarebooked'] = 'మీరు క్రింది సెషన్ కోసం నమొదు చేయబడ్డారు';
$string['youremailaddress'] = 'మీ ఇమెయిల్ చిరునామా';
