<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'attendance', language 'te', version '4.3'.
 *
 * @package     attendance
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['Aacronym'] = 'ఒక';
$string['Afull'] = 'ఆబ్సెంట్';
$string['Eacronym'] = 'E';
$string['Efull'] = 'క్షమించరాదు';
$string['Lacronym'] = 'L';
$string['Lfull'] = 'ఆలస్యం';
$string['Pacronym'] = 'P';
$string['Pfull'] = 'ప్రస్తుతం';
$string['absenteereport'] = 'అబ్సింతీ రిపోర్ట్';
$string['acronym'] = 'సంక్షిప్తనామం';
$string['add'] = 'చేర్చు';
$string['addmultiplesessions'] = 'బహుళ సెషన్లు';
$string['addsession'] = 'సెషన్ను జోడించండి';
$string['adduser'] = 'వినియోగదారుని జోడించు';
$string['addwarning'] = 'హెచ్చరికను జోడించండి';
$string['all'] = 'అన్ని';
$string['allcourses'] = 'అన్ని కోర్సులు';
$string['allpast'] = 'అన్ని గత';
$string['allsessions'] = 'అన్ని సెషన్లు';
$string['attendance:addinstance'] = 'కొత్త హాజరు కార్యాచరణను జోడించండి';
$string['attendance:canbelisted'] = 'జాబితాలో కనిపిస్తుంది';
$string['attendance:changeattendances'] = 'హాజరు మార్చడం';
$string['attendance:changepreferences'] = 'మార్పులను మార్చడం';
$string['attendance:export'] = 'ఎగుమతి నివేదికలు';
$string['attendance:manageattendances'] = 'హాజరు నిర్వహించండి';
$string['attendance:managetemporaryusers'] = 'తాత్కాలిక వినియోగదారులను నిర్వహించండి';
$string['attendance:takeattendances'] = 'హాజరు పొందడం';
$string['attendance:view'] = 'హాజరు కావడం';
$string['attendance:viewreports'] = 'నివేదికలు చూస్తున్నారు';
$string['attendance:viewsummaryreports'] = 'కోర్సు సారాంశం నివేదికలను వీక్షించండి';
$string['attendance:warningemails'] = 'హాజరు కాని వినియోగదారులతో ఇమెయిల్స్కు చందా పొందవచ్చు';
$string['attendance_already_submitted'] = 'మీరు ఇప్పటికే సెట్ చేయబడిన స్వీయ రిజిస్టర్ హాజరు కాకపోవచ్చు.';
$string['attendance_no_status'] = 'చెల్లుబాటు అయ్యే హోదా ఏదీ అందుబాటులో లేదు - మీరు హాజరు కావడానికి చాలా ఆలస్యం కావచ్చు.';
$string['attendancedata'] = 'హాజరు డేటా';
$string['attendancegrade'] = 'హాజరు గ్రేడ్';
$string['attendancenotset'] = 'మీరు హాజరు కావాలి';
$string['attendancenotstarted'] = 'ఈ కోర్సు కోసం హాజరు ఇంకా ప్రారంభించలేదు';
$string['attendancepercent'] = 'హాజరు శాతం';
$string['attendancereport'] = 'హాజరు నివేదిక';
$string['attendanceslogged'] = 'హాజరు లాగ్';
$string['attendancestaken'] = 'హాజరు తీసుకున్న';
$string['attendancesuccess'] = 'హాజరు విజయవంతంగా తీసుకోబడింది';
$string['attendanceupdated'] = 'హాజరు విజయవంతంగా నవీకరించబడింది';
$string['attforblockdirstillexists'] = 'పాత mod / attforblock డైరెక్టరీ ఇప్పటికీ ఉంది - ఈ అప్గ్రేడ్ని నడుపుటకు ముందు మీరు ఈ డైరెక్టరీని మీ సర్వర్లో తొలగించాలి.';
$string['attrecords'] = 'హాజరు రికార్డులు';
$string['autoassignstatus'] = 'అత్యధిక స్థాయిని స్వయంచాలకంగా ఎంచుకోండి';
$string['autoassignstatus_help'] = 'ఇది ఎంచుకున్నట్లయితే, విద్యార్థులు స్వయంచాలకంగా అందుబాటులో ఉన్న అత్యధిక గ్రేడ్ కేటాయించబడుతుంది.';
$string['automark'] = 'ఆటోమేటిక్ మార్కింగ్';
$string['automark_help'] = 'స్వయంచాలకంగా పూర్తి చేయడానికి మార్కింగ్ అనుమతిస్తుంది.
"అవును" విద్యార్థులు కోర్సు యొక్క మొదటి ప్రాప్తిని బట్టి స్వయంచాలకంగా గుర్తించబడతారు.
"సెషన్ ముగింపులో గుర్తించబడని సెట్" ఉంటే, హాజరుకాని ఏ విద్యార్ధిని ఎంచుకోబడని స్థితికి సెట్ చేయబడతారు.';
$string['automarkall'] = 'అవును';
$string['automarkclose'] = 'సెషన్ ముగింపులో గుర్తించబడని సెట్ చెయ్యండి';
$string['automarktask'] = 'ఆటో మార్కింగ్ అవసరమయ్యే హాజరు సెషన్ల కోసం తనిఖీ చేయండి';
$string['autorecorded'] = 'సిస్టమ్ ఆటో రికార్డ్ చేయబడింది';
$string['averageattendance'] = 'సగటు హాజరు';
$string['averageattendancegraded'] = 'సగటు హాజరు';
$string['calclose'] = 'మూసివేయి';
$string['caleventcreated'] = 'సెషన్ కోసం క్యాలెండర్ ఈవెంట్ విజయవంతంగా సృష్టించబడింది';
$string['caleventdeleted'] = 'సెషన్ కోసం క్యాలెండర్ ఈవెంట్ విజయవంతంగా తొలగించబడింది';
$string['calmonths'] = 'జనవరి, ఫిబ్రవరి, మార్చి, ఏప్రిల్, మే, జూన్, జూలై, ఆగష్టు, సెప్టెంబర్, అక్టోబర్, నవంబర్, డిసెంబర్';
$string['calshow'] = 'తేదీని ఎంచుకోండి';
$string['calweekdays'] = 'సు, మో, తూ, మేము, Th, Fr, సే';
$string['cannottakeforgroup'] = 'మీరు సమూహం "{$a}" కోసం హాజరు కాలేరు';
$string['cantaddstatus'] = 'క్రొత్త స్థితిని జోడించేటప్పుడు మీరు ఎక్రోనిం మరియు వివరణని సెట్ చేయాలి';
$string['categoryreport'] = 'కోర్సు వర్గం నివేదిక';
$string['changeattendance'] = 'హాజరు మార్చు';
$string['changeduration'] = 'వ్యవధి మార్చండి';
$string['changesession'] = 'సెషన్ మార్చండి';
$string['checkweekdays'] = 'మీ ఎంచుకున్న సెషన్ తేదీ పరిధిలో పడే వారాన్ని ఎంచుకోండి.';
$string['column'] = 'కాలమ్';
$string['columns'] = 'నిలువు';
$string['commonsession'] = 'అన్ని విద్యార్థులు';
$string['commonsessions'] = 'అన్ని విద్యార్థులు';
$string['confirm'] = 'నిర్ధారించండి';
$string['confirmcolumnmappings'] = 'కాలమ్ మ్యాపింగ్లను నిర్ధారించండి';
$string['confirmdeletehiddensessions'] = 'మీరు కోర్సు ప్రారంభ తేదీకి ముందు షెడ్యూల్ చేయవలసిన {$ a-> లెక్కింపు సెషన్లను తొలగించాలనుకుంటున్నారా ({$ a-> date})?';
$string['confirmdeleteuser'] = 'మీరు ఖచ్చితంగా వినియోగదారుని \'{$a->fullname}\' ({$a->email}} ను తొలగించాలనుకుంటున్నారా? <br/> వారి హాజరు రికార్డులన్నీ శాశ్వతంగా తొలగించబడతాయి.';
$string['copyfrom'] = 'నుండి హాజరు డేటాను కాపీ చేయండి';
$string['countofselected'] = 'ఎంపిక చేసిన కౌంట్';
$string['course'] = 'కోర్సు';
$string['coursesummary'] = 'కోర్సు సారాంశం నివేదిక';
$string['createmultiplesessions'] = 'బహుళ సెషన్లను సృష్టించండి';
$string['createmultiplesessions_help'] = 'ఈ ఫంక్షన్ మీరు ఒక సాధారణ దశలో బహుళ సెషన్లను సృష్టించడానికి అనుమతిస్తుంది.
సెషన్లు బేస్ సెషన్ తేదీ ప్రారంభమవుతాయి మరియు \'రిపీట్ వరకు\' తేదీ వరకు కొనసాగండి.

  * <strong> పునరావృతం </ strong>: మీ తరగతి సమావేశం అయినప్పుడు వారంలోని రోజులను ఎంచుకోండి (ఉదాహరణకు, సోమవారం / బుధవారం / శుక్రవారం).
  * <strong> ప్రతి పునరావృతం </ strong>: ఇది ఫ్రీక్వెన్సీ సెట్టింగ్కు అనుమతిస్తుంది. మీ తరగతి ప్రతి వారం సమావేశం అయితే, 1 ఎంచుకోండి; ఇది ప్రతి వారం వస్తే, 2 ఎంచుకోండి; ప్రతి 3 వ వారం, ఎంచుకోండి 3, మొదలైనవి
  * <strong> వరకు పునరావృతం చేయి </ strong>: చివరి రోజు తరగతి ఎంచుకోండి (చివరి రోజు మీరు హాజరు కావాలి).';
$string['createonesession'] = 'కోర్సు కోసం ఒక సెషన్ను సృష్టించండి';
$string['csvdelimiter'] = 'CSV డీలిమిటర్';
$string['date'] = 'తేదీ';
$string['days'] = 'రోజులు';
$string['defaultdisplaymode'] = 'డిఫాల్ట్ డిస్ప్లే మోడ్';
$string['defaults'] = 'డిఫాల్ట్లకు';
$string['defaultsessionsettings'] = 'డిఫాల్ట్ సెషన్ సెట్టింగులు';
$string['defaultsessionsettings_help'] = 'ఈ సెట్టింగులు అన్ని కొత్త సెషన్లకు డిఫాల్ట్లను నిర్వచిస్తాయి';
$string['defaultsettings'] = 'డిఫాల్ట్ హాజరు సెట్టింగ్లు';
$string['defaultsettings_help'] = 'ఈ సెట్టింగులు కొత్త హాజరు కోసం డిఫాల్ట్లను నిర్వచిస్తాయి';
$string['defaultstatus'] = 'డిఫాల్ట్ స్థితి సెట్ చేయబడింది';
$string['defaultsubnet'] = 'డిఫాల్ట్ నెట్వర్క్ చిరునామా';
$string['defaultsubnet_help'] = 'హాజరు రికార్డింగ్ పాక్షిక లేదా పూర్తి IP చిరునామాల కామాతో వేరు చేయబడిన జాబితాను పేర్కొనడం ద్వారా నిర్దిష్ట ఉపనెత్లకు పరిమితం చేయబడవచ్చు. ఇది క్రొత్త సెషన్లను సృష్టించేటప్పుడు ఉపయోగించే డిఫాల్ట్ విలువ.';
$string['defaultview'] = 'లాగిన్పై డిఫాల్ట్ వీక్షణ';
$string['defaultview_desc'] = 'ఇది మొదటి లాగిన్ పై ఉపాధ్యాయులకు చూపించిన డిఫాల్ట్ వ్యూ.';
$string['defaultwarnings'] = 'డిఫాల్ట్ హెచ్చరిక సెట్';
$string['defaultwarningsettings'] = 'డిఫాల్ట్ హెచ్చరిక సెట్టింగులు';
$string['defaultwarningsettings_help'] = 'ఈ సెట్టింగ్లు అన్ని కొత్త హెచ్చరికల కోసం డిఫాల్ట్లను నిర్వచిస్తాయి';
$string['delete'] = 'తొలగించు';
$string['deletedgroup'] = 'ఈ సెషన్తో అనుబంధిత సమూహం తొలగించబడింది';
$string['deletehiddensessions'] = 'అన్ని రహస్య సెషన్లను తొలగించండి';
$string['deletelogs'] = 'హాజరు డేటాను తొలగించండి';
$string['deleteselected'] = 'ఎంచుకున్నవాటిని రద్దు చేయుట';
$string['deletesession'] = 'సెషన్ను తొలగించు';
$string['deletesessions'] = 'అన్ని సెషన్లను తొలగించండి';
$string['deleteuser'] = 'వినియోగదారుని తొలగించు';
$string['deletewarningconfirm'] = 'మీరు ఖచ్చితంగా ఈ హెచ్చరికను తొలగించాలనుకుంటున్నారా?';
$string['deletingsession'] = 'కోర్సు కోసం సెషన్ను తొలగించడం';
$string['deletingstatus'] = 'కోర్సు కోసం స్థితిని తొలగించడం';
$string['description'] = 'వివరణ';
$string['display'] = 'ప్రదర్శన';
$string['displaymode'] = 'డిస్ప్లే మోడ్';
$string['donotusepaging'] = 'పేజింగ్ని ఉపయోగించవద్దు';
$string['downloadexcel'] = 'Excel ఫార్మాట్లో డౌన్లోడ్ చేయండి';
$string['downloadooo'] = 'OpenOffice ఆకృతిలో డౌన్లోడ్ చేయండి';
$string['downloadtext'] = 'టెక్స్ట్ ఫార్మాట్లో డౌన్లోడ్ చేయండి';
$string['duration'] = 'వ్యవధి';
$string['editsession'] = 'సెషన్ను సవరించండి';
$string['edituser'] = 'వినియోగదారుని సవరించండి';
$string['emailcontent'] = 'ఇమెయిల్ కంటెంట్';
$string['emailcontent_default'] = 'ఎక్కువ% userfirstname%,
% Coursename% attendancename% లో మీరు హాజరయ్యారు% warniercent% క్రింద పడిపోయింది మరియు ప్రస్తుతం% శాతం% ఉంది - మీరు సరే ఆశిస్తున్నాము!

ఈ కోర్సు నుండి ఎక్కువగా రావటానికి మీరు మీ హాజరును పెంచుకోవాలి, మీకు ఏవైనా మద్దతు అవసరమైతే దయచేసి సన్నిహితంగా ఉండండి.';
$string['emailcontent_help'] = 'ఒక హెచ్చరిక విద్యార్థికి పంపినప్పుడు, ఇది ఈ ఫీల్డ్ నుండి ఇమెయిల్ కంటెంట్ను తీసుకుంటుంది. కింది వైల్డ్కార్డ్లను ఉపయోగించవచ్చు:
<Ul>
<Li>% coursename% </ li>
<Li>% userfirstname% </ li>
<Li>% userlastname% </ li>
<Li>% వినియోగదారు ఐడి% </ li>
<Li>% warningpercent% </ li>
<Li>% attendancename% </ li>
<Li>% cmid% </ li>
<Li>% numtakensessions% </ li>
<Li>% పాయింట్లు% </ li>
<Li>% maxpoints% </ li>
<Li>% శాతం% </ li>
</ Ul>';
$string['emailsubject'] = 'ఇమెయిల్ విషయం';
$string['emailsubject_default'] = 'హాజరు హెచ్చరిక';
$string['emailsubject_help'] = 'ఒక హెచ్చరిక విద్యార్థికి పంపినప్పుడు, ఈ ఫీల్డ్ నుండి ఇమెయిల్ విషయం పడుతుంది.';
$string['emailuser'] = 'ఇమెయిల్ వినియోగదారు';
$string['emailuser_help'] = 'తనిఖీ చేసినట్లయితే, విద్యార్థికి హెచ్చరిక పంపబడుతుంది.';
$string['emptyacronym'] = 'ఖాళీ ఎక్రోనింస్ అనుమతించబడదు. స్థితి రికార్డ్ నవీకరించబడలేదు.';
$string['emptydescription'] = 'ఖాళీ వివరణలు అనుమతించబడవు. స్థితి రికార్డ్ నవీకరించబడలేదు.';
$string['enablecalendar'] = 'క్యాలెండర్ ఈవెంట్లను సృష్టించండి';
$string['enablecalendar_desc'] = 'ప్రారంభించబడితే, ప్రతి హాజరు సెషన్ కోసం క్యాలెండర్ ఈవెంట్ సృష్టించబడుతుంది. ఈ సెట్టింగ్ని మార్చిన తర్వాత రీసెట్ క్యాలెండర్ రిపోర్ట్ను మీరు అమలు చేయాలి.';
$string['enablewarnings'] = 'హెచ్చరికలను ప్రారంభించండి';
$string['enablewarnings_desc'] = 'హాజరు కాన్ఫిగర్ థ్రెషోల్డ్ దిగువన పడిపోతున్నప్పుడు వినియోగదారులకు హాజరు మరియు ఇమెయిల్ నోటిఫికేషన్ల కోసం ఒక హెచ్చరిక సెట్ను ఇది అనుమతిస్తుంది. <br/> <strong> హెచ్చరిక: ఇది క్రొత్త ఫీచర్ మరియు విస్తృతంగా పరీక్షించబడలేదు. దయచేసి మీ స్వంత-ప్రమాదాన్ని ఉపయోగించుకోండి మరియు మీరు బాగా పనిచేస్తుందని కనుగొంటే, మూడ్లె ఫోరమ్ల్లో ఫీడ్బ్యాక్ను అందించండి. </ Strong>';
$string['encoding'] = 'ఎన్కోడింగ్';
$string['endofperiod'] = 'కాలం ముగింపు';
$string['endtime'] = 'సెషన్ ముగింపు సమయం';
$string['enrolmentend'] = 'వాడుకరి నమోదు ముగిసింది {$a}';
$string['enrolmentstart'] = 'వాడుకరి నమోదు {$a}';
$string['enrolmentsuspended'] = 'నమోదు సస్పెండ్ చేయబడింది';
$string['error:coursehasnoattendance'] = 'చిన్న పేరుతో {$a} కోర్సు హాజరు కార్యకలాపాలు లేవు.';
$string['error:coursenotfound'] = 'చిన్న పేరు {$a} తో ఉన్న కోర్సు కనుగొనబడలేదు.';
$string['error:sessioncourseinvalid'] = 'ఒక సెషన్ కోర్సు చెల్లనిది! ముళ్లు';
$string['error:sessiondateinvalid'] = 'సెషన్ తేదీ చెల్లనిది! ముళ్లు';
$string['error:sessionendinvalid'] = 'సెషన్ ముగింపు సమయం చెల్లనిది! దాటవేయడం.';
$string['error:sessionstartinvalid'] = 'సెషన్ ప్రారంభ సమయం చెల్లనిది! దాటవేయడం.';
$string['errorgroupsnotselected'] = 'ఒకటి లేదా అంతకంటే ఎక్కువ సమూహాలను ఎంచుకోండి';
$string['errorinaddingsession'] = 'సెషన్ను జోడించడంలో లోపం';
$string['erroringeneratingsessions'] = 'సెషన్లను రూపొందించడంలో లోపం';
$string['eventdurationupdated'] = 'సెషన్ వ్యవధి నవీకరించబడింది';
$string['eventreportviewed'] = 'హాజరు నివేదిక వీక్షించబడింది';
$string['eventscreated'] = 'క్యాలెండర్ ఈవెంట్స్ సృష్టించబడింది';
$string['eventsdeleted'] = 'క్యాలెండర్ ఈవెంట్స్ తొలగించబడ్డాయి';
$string['eventsessionadded'] = 'సెషన్ జోడించబడింది';
$string['eventsessiondeleted'] = 'సెషన్ తొలగించబడింది';
$string['eventsessionipshared'] = 'హాజరు స్వీయ మార్కింగ్ IP వివాదం';
$string['eventsessionsimported'] = 'సెషన్స్ దిగుమతి';
$string['eventsessionupdated'] = 'సెషన్ నవీకరించబడింది';
$string['eventstatusadded'] = 'స్థితి జోడించబడింది';
$string['eventstatusupdated'] = 'స్థితి నవీకరించబడింది';
$string['eventtaken'] = 'హాజరు కావడం';
$string['eventtakenbystudent'] = 'విద్యార్ధి ద్వారా హాజరైన హాజరు';
$string['export'] = 'ఎగుమతి';
$string['extrarestrictions'] = 'అదనపు పరిమితులు';
$string['from'] = 'నుండి:';
$string['gradebookexplanation'] = 'గ్రేడ్బుక్లో గ్రేడ్';
$string['gradebookexplanation_help'] = 'హాజరు మాడ్యూల్ మీ ప్రస్తుత హాజరు గ్రేడ్ను మీరు తేదీ వరకు సంపాదించిన పాయింట్ల సంఖ్య మరియు తేదీ వరకు సంపాదించగలిగే పాయింట్ల సంఖ్య ఆధారంగా ప్రదర్శిస్తుంది; అది భవిష్యత్తులో తరగతి కాలాన్ని కలిగి ఉండదు. గ్రేడ్బుక్లో, మీ హాజరు గ్రేడ్ మీ ప్రస్తుత హాజరు శాతం మరియు కోర్సు యొక్క మొత్తం వ్యవధిలో సంపాదించవచ్చు ఆ పాయింట్లు సంఖ్య, భవిష్యత్తు తరగతి కాలాలు సహా. అందుకని, హాజరు మాడ్యూల్ మరియు గ్రేడ్బుక్లలో మీ హాజరు పద్దతులు ప్రదర్శించబడతాయి, కానీ అవి ఒకే శాతంగా ఉంటాయి.

ఉదాహరణకు, మీరు ఇప్పటి వరకు 10 పాయింట్లను (80% హాజరు) సంపాదించి ఉంటే మరియు మొత్తం కోర్సుకు హాజరు 50 పాయింట్ల విలువైనది, హాజరు మాడ్యూల్ 8/10 ను ప్రదర్శిస్తుంది మరియు గ్రేడ్బుక్ 40/50 ను ప్రదర్శిస్తుంది. మీరు ఇంకా 40 పాయింట్లను సంపాదించలేదు కాని 40% మీ ప్రస్తుత హాజరు శాతంకి సమానమైన పాయింట్ విలువ. హాజరు మాడ్యూల్ లో సంపాదించిన పాయింట్ విలువ తగ్గిపోతుంది ఎందుకంటే ఇది తేదీ వరకు మాత్రమే హాజరవుతుంది; ఏదేమైనా, గ్రేడ్బుక్లో చూపించిన హాజరు పాయింట్ విలువ, మీ భవిష్యత్ హాజరును బట్టి పెరుగుతుంది లేదా తగ్గిపోతుంది, ఎందుకంటే అది మొత్తం కోర్సు కోసం హాజరు ఆధారంగా ఉంటుంది.';
$string['graded'] = 'గ్రేడెడ్ సెషన్స్';
$string['gridcolumns'] = 'గ్రిడ్ స్తంభాలు';
$string['group'] = 'గ్రూప్';
$string['groups'] = 'గుంపులు';
$string['groupsession'] = 'విద్యార్థుల సమూహం';
$string['hiddensessions'] = 'దాచిన సెషన్లు';
$string['hiddensessions_help'] = 'కోర్సు ప్రారంభ తేదీకి ముందు షెడ్యూల్ ఉంటే సెషన్లు దాచబడతాయి.

పాత లక్షణాలను తొలగించడానికి బదులుగా మీరు ఈ లక్షణాన్ని ఉపయోగించవచ్చు. కనిపించే సెషన్లు మాత్రమే గ్రేడ్బుక్లో కనిపిస్తాయి.';
$string['hiddensessionsdeleted'] = 'అన్ని రహస్య సెషన్లు తొలగించబడ్డాయి';
$string['hideextrauserdetails'] = 'అదనపు యూజర్ వివరాలను దాచిపెట్టు';
$string['hidensessiondetails'] = 'సెషన్ వివరాలను దాచు';
$string['identifyby'] = 'విద్యార్థిని గుర్తించండి';
$string['import'] = 'దిగుమతి';
$string['importfile'] = 'ఫైల్ను దిగుమతి చేయండి';
$string['importfile_help'] = 'ఫైల్ను దిగుమతి చేయండి';
$string['importsessions'] = 'దిగుమతి సెషన్స్';
$string['includeabsentee'] = 'హాజరుకాని నివేదికను లెక్కించేటప్పుడు సెషన్ను చేర్చండి';
$string['includeabsentee_help'] = 'తనిఖీ చేసినట్లయితే, ఈ సెషన్ హాజరుకాని నివేదిక లెక్కల్లో చేర్చబడుతుంది.';
$string['includeall'] = 'అన్ని సెషన్లను ఎంచుకోండి';
$string['includenottaken'] = 'తీసుకున్న సమావేశాలను చేర్చండి';
$string['includeremarks'] = 'వ్యాఖ్యలను చేర్చండి';
$string['incorrectpassword'] = 'మీరు తప్పు పాస్వర్డ్ను నమోదు చేసి, మీ హాజరు నమోదు చేయబడలేదు, దయచేసి సరైన పాస్వర్డ్ను నమోదు చేయండి.';
$string['indetail'] = 'విస్తృతంగా';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['invalidaction'] = 'మీరు చర్యను ఎంచుకోవాలి';
$string['invalidemails'] = 'ఇప్పటికే ఉన్న యూజర్ ఖాతాల చిరునామాలను తప్పక పేర్కొనాలి, కనుగొనలేక పోయాను: {$a}';
$string['invalidimportfile'] = 'ఫైల్ ఆకృతి చెల్లనిది.';
$string['invalidsessionenddate'] = 'ఈ తేదీ సెషన్ తేదీ కంటే ముందు ఉండదు';
$string['invalidsessionendtime'] = 'ముగింపు సమయం ప్రారంభ సమయం కంటే ఎక్కువగా ఉండాలి';
$string['invalidstatus'] = 'మీరు చెల్లని స్థితిని ఎంచుకున్నారు, దయచేసి మళ్లీ ప్రయత్నించండి';
$string['iptimemissing'] = 'విడుదల చేయడానికి చెల్లని నిమిషాలు';
$string['jumpto'] = 'ఇక్కడికి గెంతు';
$string['maxpossible'] = 'గరిష్ఠ సాధ్యం';
$string['maxpossible_help'] = 'ప్రతి సెషన్లో గరిష్ట పాయింట్లను ఇంకా తీసుకున్నట్లయితే (గత మరియు భవిష్యత్తు) గరిష్ట పాయింట్లు స్వీకరించినట్లయితే ప్రతి యూజర్ చేరగల స్కోర్ను చూపుతుంది:
    <Ul>
    <li> <strong> పాయింట్లు </ strong>: ప్రతి సెషన్లో ప్రతి వినియోగదారుని చేరగల గరిష్ట పాయింట్లు. </ li>
    <li> <strong> శాతం </ strong>: ప్రతి సెషన్లలో ప్రతి వినియోగదారుని చేరగల గరిష్ట శాతం. </ li>
    </ Ul>';
$string['maxpossiblepercentage'] = 'సాధ్యమైనంత ఎక్కువ శాతం';
$string['maxpossiblepoints'] = 'గరిష్ఠ పాయింట్లు';
$string['maxwarn'] = 'ఇ-మెయిల్ హెచ్చరికల గరిష్ఠ సంఖ్య';
$string['maxwarn_help'] = 'గరిష్ట సంఖ్యను ఒక హెచ్చరిక పంపాలి (సెషన్కు ఒక హెచ్చరిక మాత్రమే పంపబడుతుంది)';
$string['mergeuser'] = 'వినియోగదారుని విలీనం చేయండి';
$string['modulename'] = 'హాజరు';
$string['modulename_help'] = 'హాజరు సూచించే మాడ్యూల్ తరగతి మరియు విద్యార్ధుల సమయంలో వారి హాజరు రికార్డును వీక్షించడానికి ఒక ఉపాధ్యాయుడికి హాజరుకావడానికి వీలు కల్పిస్తుంది.

గురువు బహుళ సెషన్లను సృష్టించవచ్చు మరియు హాజరు హోదాని "ప్రస్తుతము", "అబ్సెంట్", "లేట్" లేదా "ఎక్స్ప్యూసెడ్" లేదా తమ అవసరాలకు అనుగుణంగా ఉన్న స్థితులను మార్చవచ్చు.

నివేదికలు మొత్తం తరగతి లేదా వ్యక్తిగత విద్యార్థులకు అందుబాటులో ఉన్నాయి.';
$string['modulenameplural'] = 'హాజరు';
$string['months'] = 'నెలల';
$string['moreattendance'] = 'ఈ పేజీ కోసం హాజరు విజయవంతంగా తీసుకోబడింది';
$string['moveleft'] = 'ఎడమకి తరలించు';
$string['moveright'] = 'కుడికి తరలించు';
$string['multisessionexpanded'] = 'బహుళ సెషన్లు విస్తరించాయి';
$string['multisessionexpanded_desc'] = 'క్రొత్త సెషన్లను సృష్టిస్తున్నప్పుడు డిఫాల్ట్గా విస్తరించిన "బహుళ సెషన్స్" సెట్టింగులను చూపించు.';
$string['mustselectusers'] = 'ఎగుమతి చేయడానికి వినియోగదారులను తప్పక ఎంచుకోవాలి';
$string['newdate'] = 'కొత్త తేదీ';
$string['newduration'] = 'కొత్త వ్యవధి';
$string['newstatusset'] = 'కొత్త హోదా సెట్లు';
$string['noabsentstatusset'] = 'ఉపయోగంలో ఉన్న స్థితి సెట్ చేయబడనప్పుడు ఉపయోగించడానికి ఒక స్థితిని కలిగి లేదు.';
$string['noattendanceusers'] = 'కోర్సులో చేరే విద్యార్ధులు లేనందున ఏ డేటాను ఎగుమతి చేయడం సాధ్యం కాదు.';
$string['noattforuser'] = 'యూజర్ కోసం హాజరు రికార్డులు లేవు';
$string['noautomark'] = 'డిసేబుల్';
$string['nodescription'] = 'సాధారణ తరగతి సెషన్';
$string['noeventstoreset'] = 'నవీకరణ అవసరం క్యాలెండర్ ఈవెంట్స్ లేవు.';
$string['nogroups'] = 'మీరు సమూహ సెషన్లను జోడించలేరు. ఏ సమూహాలు కోర్సులో లేవు.';
$string['noguest'] = 'అతిథి హాజరు చూడలేరు';
$string['noofdaysabsent'] = 'రోజులు లేవు';
$string['noofdaysexcused'] = 'రోజులు క్షమించబడలేదు';
$string['noofdayslate'] = 'ఆలస్యం రోజులు లేవు';
$string['noofdayspresent'] = 'రోజులు లేవు';
$string['nosessiondayselected'] = 'సెషన్ రోజు ఎంచుకోబడలేదు';
$string['nosessionexists'] = 'ఈ కోర్సు కోసం సెషన్ లేదు';
$string['nosessionsselected'] = 'సెషన్లు ఎంచుకోబడలేదు';
$string['notfound'] = 'హాజరు కార్యాచరణ ఈ కోర్సులో కనుగొనబడలేదు!';
$string['notifytask'] = 'వినియోగదారులకు హెచ్చరికలను పంపండి';
$string['notmember'] = '& nbsp కాదు; సభ్యులు';
$string['noupgradefromthisversion'] = 'మీరు ఇన్స్టాల్ చేసిన attforblock యొక్క సంస్కరణ నుండి హాజరు మాడ్యూల్ అప్గ్రేడ్ కాలేదు. - attforblock తొలగించండి లేదా కొత్త హాజరు మాడ్యూల్ isntalling ముందు తాజా వెర్షన్ దానిని అప్గ్రేడ్ చేయండి';
$string['numsessions'] = 'సెషన్ల సంఖ్య';
$string['olddate'] = 'పాత తేదీ';
$string['onlyselectedusers'] = 'నిర్దిష్ట వినియోగదారులను ఎగుమతి చేయండి';
$string['overallsessions'] = 'అన్ని సెషన్లలో';
$string['overallsessions_help'] = 'ఇప్పటివరకు తీయని (గత మరియు భవిష్యత్తు) సహా అన్ని సెషన్ల కోసం గణాంకాలను చూపుతుంది:
    <Ul>
    <li> <strong> సెషన్లు </ strong>: మొత్తం సెషన్ల సంఖ్య. </ li>
    <li> <strong> పాయింట్లు </ strong>: తీసుకున్న సెషన్ల ఆధారంగా ఇవ్వబడిన పాయింట్లు. </ li>
    <li> <strong> శాతము </ strong>: అన్ని సెషన్లకు గరిష్ఠ పాయింట్లు సాధించిన పాయింట్ల శాతం. </ li>
    </ Ul>';
$string['oversessionstaken'] = 'తీసుకున్న సెషన్ల కంటే ఎక్కువ';
$string['oversessionstaken_help'] = 'హాజరు తీసుకోబడిన సెషన్ల కోసం గణాంకాలను చూపుతుంది:
    <Ul>
    <li> <strong> సెషన్లు </ strong>: ఇప్పటికే తీసుకున్న సెషన్ల సంఖ్య. </ li>
    <li> <strong> పాయింట్లు </ strong>: తీసుకున్న సెషన్ల ఆధారంగా ఇవ్వబడిన పాయింట్లు. </ li>
    <li> <strong> శాతము </ strong>: తీసుకున్న సెషన్ల గరిష్ట పాయింట్లు సాధించిన పాయింట్ల శాతం. </ li>
    </ Ul>';
$string['participant'] = 'పార్టిసిపెంట్';
$string['password'] = 'పాస్వర్డ్';
$string['passwordgrp'] = 'విద్యార్థి పాస్వర్డ్';
$string['passwordgrp_help'] = 'సెషన్ కోసం తమ సొంత హాజరు స్థాయిని సెట్ చేసే ముందు విద్యార్థులు ఈ పాస్వర్డ్ను నమోదు చేయవలసి ఉంటుంది. ఖాళీగా ఉంటే, ఏ పాస్వర్డ్ అవసరం లేదు.';
$string['passwordrequired'] = 'మీ హాజరును సమర్పించే ముందు మీరు తప్పనిసరిగా సెషన్ పాస్వర్డ్ను నమోదు చేయాలి';
$string['percentage'] = 'శాతం';
$string['percentageallsessions'] = 'అన్ని సెషన్ల శాతం';
$string['percentagesessionscompleted'] = 'తీసుకున్న సెషన్ల శాతం';
$string['pluginadministration'] = 'హాజరు పరిపాలన';
$string['pluginname'] = 'హాజరు';
$string['points'] = 'పాయింట్లు';
$string['pointsallsessions'] = 'అన్ని సెషన్లలో పాయింట్లు';
$string['pointssessionscompleted'] = 'తీసుకున్న సెషన్లపై పాయింట్లు';
$string['preferences_desc'] = 'స్థితి సెట్స్కు మార్పులు ఇప్పటికే ఉన్న హాజరు సెషన్లను ప్రభావితం చేస్తాయి మరియు గ్రేడింగ్ను ప్రభావితం చేయవచ్చు.';
$string['preventsharederror'] = 'ఒక సెషన్ కోసం స్వీయ మార్కింగ్ డిసేబుల్ చెయ్యబడింది ఎందుకంటే ఈ పరికరం మరొక విద్యార్ధి కోసం హాజరును రికార్డ్ చేయడానికి ఉపయోగిస్తున్నట్లుగా కనిపిస్తోంది';
$string['preventsharedip'] = 'IP చిరునామాను పంచుకునే విద్యార్థులను నిరోధించండి';
$string['preventsharedip_help'] = 'ఇతర విద్యార్థులకు హాజరుకావడానికి అదే పరికరాన్ని (ఐపి చిరునామాను ఉపయోగించి గుర్తించి) ఉపయోగించకుండా విద్యార్థులు నిరోధించండి';
$string['preventsharediptime'] = 'IP చిరునామా (నిమిషాలు) యొక్క పునః వినియోగం అనుమతించడానికి సమయం';
$string['preventsharediptime_help'] = 'ఈ సమయం ముగిసిన తర్వాత ఈ సెషన్లో హాజరు కావడానికి ఒక IP చిరునామాని తిరిగి ఉపయోగించుకోవటానికి అనుమతించు.';
$string['priorto'] = 'సెషన్ తేదీ కోర్సు ప్రారంభ తేదీకి ముందు ({$a}) ఈ తేదీకి ముందు షెడ్యూల్ చేయబడిన కొత్త సెషన్లు దాచబడతాయి (అందుబాటులో ఉండవు). మీరు సెషన్ తేదీని ప్రాప్యత చేయడానికి ఎప్పుడైనా కోర్సు ప్రారంభ తేదీని మార్చవచ్చు (కోర్సు సెట్టింగులను చూడండి) <br> <br> దయచేసి సెషన్ తేదీని మార్చండి లేదా నిర్ధారించడానికి మళ్ళీ "సెషన్ జోడించు" బటన్ను క్లిక్ చెయ్యాలా?';
$string['privacy:metadata:attendancelog'] = 'నమోదు చేసిన యూజర్ హాజరు యొక్క లాగ్.';
$string['privacy:metadata:attendancesessions'] = 'హాజరు నమోదు చేయబడే సెషన్లు.';
$string['privacy:metadata:attendancewarningdone'] = 'వారి హాజరు రికార్డుపై వినియోగదారులకు పంపిన హెచ్చరికల లాగ్.';
$string['privacy:metadata:duration'] = 'సెకన్లలో సెషన్ వ్యవధి';
$string['privacy:metadata:groupid'] = 'సమూహం ID సెషన్తో సంబంధం కలిగి ఉంది.';
$string['privacy:metadata:ipaddress'] = 'IP చిరునామా హాజరు నుండి గుర్తించబడింది.';
$string['privacy:metadata:lasttaken'] = 'సెషన్ హాజరు చివరిగా తీసిన సమయంలో టైమ్స్టాంప్.';
$string['privacy:metadata:lasttakenby'] = 'ఈ సెషన్లో హాజరు కావడానికి చివరి వినియోగదారు యొక్క వినియోగదారు ID';
$string['privacy:metadata:notifyid'] = 'హాజరు సెషన్ హెచ్చరిక ID సంబంధం కలిగి ఉంది.';
$string['privacy:metadata:remarks'] = 'వినియోగదారు హాజరు గురించి వ్యాఖ్యలు.';
$string['privacy:metadata:sessdate'] = 'సెషన్ మొదలవుతుంది యొక్క టైమ్స్టాంప్.';
$string['privacy:metadata:sessionid'] = 'హాజరు సెషన్ ID.';
$string['privacy:metadata:statusid'] = 'విద్యార్థి హాజరు హోదా యొక్క ID.';
$string['privacy:metadata:statusset'] = 'స్థితి ID చెందిన స్థితి సెట్.';
$string['privacy:metadata:studentid'] = 'విద్యార్ధి హాజరు నమోదు చేసిన వ్యక్తి ID.';
$string['privacy:metadata:takenby'] = 'విద్యార్థికి హాజరైన యూజర్ యొక్క వినియోగదారు ID.';
$string['privacy:metadata:timemodified'] = 'సెషన్ చివరిగా సవరించబడినప్పుడు యొక్క టైమ్స్టాంప్';
$string['privacy:metadata:timesent'] = 'హెచ్చరిక పంపబడినప్పుడు టైమ్స్టాంప్.';
$string['privacy:metadata:timetaken'] = 'విద్యార్థికి హాజరు కాబడినప్పుడు సమయపాలన తీసుకోబడింది.';
$string['privacy:metadata:userid'] = 'హెచ్చరికను పంపడానికి యూజర్ యొక్క ID.';
$string['processingfile'] = 'ఫైల్ను ప్రాసెస్ చేస్తోంది';
$string['randompassword'] = 'యాధృచ్ఛిక పాస్వర్డ్';
$string['remark'] = 'దీనికి గుర్తు: {$a}';
$string['remarks'] = 'వ్యాఖ్యలు';
$string['repeatasfollows'] = 'ఈ క్రింది విధంగా సెషన్ను పునరావృతం చేయండి';
$string['repeatevery'] = 'ప్రతి రిపీట్ చేయండి';
$string['repeaton'] = 'పునరావృతం చేయండి';
$string['repeatuntil'] = 'రిపీట్ వరకు';
$string['report'] = 'నివేదిక';
$string['required'] = 'అవసరం *';
$string['requiredentries'] = 'తాత్కాలిక రికార్డులు పాల్గొనే హాజరు రికార్డులను భర్తీ చేస్తాయి';
$string['requiredentry'] = 'తాత్కాలిక వినియోగదారు సహాయం మార్గదర్శిని విలీనం';
$string['requiredentry_help'] = '<p align = "center"> <b> హాజరు </ b> </ p>
<p align = "left"> <strong> ఖాతాలను విలీనం చేయి </ strong> </ p>
<p align = "left">
<table border = "2" cellpadding = "4">
<Tr>
<th> Moodle వినియోగదారు </ th>
<th> తాత్కాలిక వినియోగదారు </ th>
<వ> క్రియ </ వ>
</ Tr>
<Tr>
<td> హాజరు డేటా </ td>
<td> హాజరు డేటా </ td>
<td> తాత్కాలిక వినియోగదారుడు Moodle వినియోగదారుని భర్తీ చేస్తుంది </ td>
</ Tr>
<Tr>
<td> సంఖ్య హాజరు డేటా </ td>
<td> హాజరు డేటా </ td>
<td> తాత్కాలిక వినియోగదారు హాజరు Moodle వినియోగదారుకు </ td> బదిలీ చేయబడుతుంది
</ Tr>
<Tr>
<td> హాజరు డేటా </ td>
<td> సంఖ్య హాజరు డేటా </ td>
<td> తాత్కాలిక వినియోగదారు తొలగించబడుతుంది </ td>
</ Tr>
<Tr>
<td> సంఖ్య హాజరు డేటా </ td>
<td> సంఖ్య హాజరు డేటా </ td>
<td> తాత్కాలిక వినియోగదారు తొలగించబడుతుంది </ td>
</ Tr>
</ పట్టిక>

</ P>
విలీన చర్య తర్వాత <p> align = "left"> <strong> అన్ని సందర్భాలలో తాత్కాలిక వినియోగదారు తొలగించబడతారు </ strong> </ p>';
$string['requiresubnet'] = 'నెట్వర్క్ చిరునామా అవసరం';
$string['requiresubnet_help'] = 'హాజరు రికార్డింగ్ పాక్షిక లేదా పూర్తి IP చిరునామాల కామాతో వేరు చేయబడిన జాబితాను పేర్కొనడం ద్వారా నిర్దిష్ట ఉపనెత్లకు పరిమితం చేయబడవచ్చు.';
$string['resetcaledarcreate'] = 'క్యాలెండర్ ఈవెంట్స్ ప్రారంభించబడ్డాయి కానీ చాలామంది ఇప్పటికే ఉన్న సెషన్లకు ఈవెంట్స్ లేవు. మీరు ఇప్పటికే ఉన్న అన్ని సెషన్ల కోసం క్యాలెండర్ ఈవెంట్లను సృష్టించాలనుకుంటున్నారా?';
$string['resetcaledardelete'] = 'క్యాలెండర్ ఈవెంట్స్ డిసేబుల్ చెయ్యబడింది కానీ ఇప్పటికే ఉన్న సెషన్లలో తొలగించబడే ఈవెంట్స్ ఉన్నాయి. మీరు ఇప్పటికే ఉన్న అన్ని ఈవెంట్లను తొలగించాలనుకుంటున్నారా?';
$string['resetcalendar'] = 'క్యాలెండర్ రీసెట్ చేయండి';
$string['resetdescription'] = 'తొలగింపు హాజరు డేటా డేటాబేస్ నుండి సమాచారాన్ని చెరిపివేస్తుంది గుర్తుంచుకోండి. మీరు కోర్సు ప్రారంభ తేదీని మార్చిన పాత సెషన్లను దాచవచ్చు!';
$string['resetstatuses'] = 'డిఫాల్ట్కు స్థితిగతులను రీసెట్ చేయండి';
$string['restoredefaults'] = 'నిర్ణీత విలువలకు మార్చు';
$string['resultsperpage'] = 'ప్రతి పేజీకి ఫలితాలు';
$string['resultsperpage_desc'] = 'పేజీలో ప్రదర్శించబడిన విద్యార్థుల సంఖ్య';
$string['save'] = 'హాజరు సేవ్';
$string['search:activity'] = 'హాజరు - సూచించే సమాచారం';
$string['session'] = 'సెషన్';
$string['session_help'] = 'సెషన్';
$string['sessionadded'] = 'సెషన్ విజయవంతంగా జోడించబడింది';
$string['sessionalreadyexists'] = 'ఈ తేదీ కోసం సెషన్ ఇప్పటికే ఉంది';
$string['sessiondate'] = 'తేదీ';
$string['sessiondays'] = 'సెషన్ డేస్';
$string['sessiondeleted'] = 'సెషన్ విజయవంతంగా తొలగించబడింది';
$string['sessionduplicate'] = 'కోర్సు కోసం ఒక నకిలీ సెషన్ ఉంది: {$a->course} హాజరు: {$a->activity}';
$string['sessionexist'] = 'సెషన్ జోడించబడలేదు (ఇప్పటికే ఉంది)!';
$string['sessiongenerated'] = 'ఒక సెషన్ విజయవంతంగా రూపొందించబడింది';
$string['sessions'] = 'సెషన్స్';
$string['sessionscompleted'] = 'తీసుకున్న సెషన్లు';
$string['sessionsgenerated'] = '{$a} సెషన్లు విజయవంతంగా సృష్టించబడ్డాయి';
$string['sessionsids'] = 'సెషన్ల ID లు:';
$string['sessionsnotfound'] = 'ఎంచుకున్న కాల వ్యవధిలో సెషన్లు లేవు';
$string['sessionstartdate'] = 'సెషన్ ప్రారంభ తేదీ';
$string['sessionstotal'] = 'మొత్తం సెషన్ల సంఖ్య';
$string['sessiontype'] = 'రకం';
$string['sessiontype_help'] = 'మీరు విద్యార్థులందరికోసం లేదా విద్యార్థుల సమూహాలకు సెషన్లను జోడించవచ్చు. వివిధ రకాన్ని జోడించే సామర్థ్యం కార్యాచరణ సమూహం మోడ్పై ఆధారపడి ఉంటుంది.

* సమూహ మోడ్లో "కాదు సమూహాలు" మీరు అన్ని విద్యార్థులకు మాత్రమే సెషన్లను జోడించవచ్చు.
* గ్రూప్ మోడ్లో "ప్రత్యేక సమూహాలు" మీరు విద్యార్థుల సమూహం కోసం మాత్రమే సెషన్లను జోడించవచ్చు.
* సమూహ మోడ్లో "కనిపించే సమూహాలు" మీరు రెండు రకాలైన సెషన్లను జోడించవచ్చు.';
$string['sessiontypeshort'] = 'రకం';
$string['sessionunknowngroup'] = 'ఒక సెషన్ తెలియని గుంపు (లు) ను నిర్దేశిస్తుంది: {$a}';
$string['sessionupdated'] = 'సెషన్ విజయవంతంగా నవీకరించబడింది';
$string['set_by_student'] = 'స్వీయ నమోదు';
$string['setallstatuses'] = 'అన్ని వినియోగదారుల కోసం స్థితిని సెట్ చేయండి';
$string['setallstatusesto'] = '«{$a}» కు అన్ని వినియోగదారులకు స్థితిని సెట్ చేయండి';
$string['settings'] = 'సెట్టింగులు';
$string['setunmarked'] = 'గుర్తించబడనప్పుడు స్వయంచాలకంగా సెట్ చేయండి';
$string['setunmarked_help'] = 'సెషన్లో ప్రారంభించబడితే, విద్యార్థి వారి స్వంత హాజరుని గుర్తించకపోతే ఈ స్థితిని సెట్ చేయండి.';
$string['showdefaults'] = 'డిఫాల్ట్లను చూపు';
$string['showduration'] = 'వ్యవధి చూపించు';
$string['showextrauserdetails'] = 'అదనపు యూజర్ వివరాలను చూపు';
$string['showsessiondescriptiononreport'] = 'నివేదికలో సెషన్ వివరణను చూపు';
$string['showsessiondescriptiononreport_desc'] = 'హాజరు నివేదిక జాబితాలో సెషన్ వివరణను చూపించు.';
$string['showsessiondetails'] = 'సెషన్ వివరాలను చూపు';
$string['somedisabledstatus'] = '(సెషన్ ప్రారంభమైనందున కొన్ని ఎంపికలు తొలగించబడ్డాయి.)';
$string['sortedgrid'] = 'క్రమబద్ధీకరించిన గ్రిడ్';
$string['sortedlist'] = 'క్రమబద్ధీకరించిన జాబితా';
$string['startofperiod'] = 'కాలం ప్రారంభం';
$string['starttime'] = 'సమయం ప్రారంభించండి';
$string['status'] = 'స్థితి';
$string['statusdeleted'] = 'స్థితి తొలగించబడింది';
$string['statuses'] = 'హోదాలు';
$string['statusset'] = 'స్థితి సెట్ {$a}';
$string['statussetsettings'] = 'స్థితి సెట్ చేయబడింది';
$string['strftimedm'] = '% b% d';
$string['strftimedmy'] = '%d %b %Y';
$string['strftimedmyhm'] = '%d %b %Y %I.%M%p';
$string['strftimedmyw'] = '<nobr>%a %d %b %Y</nobr>';
$string['strftimeh'] = '%I%p';
$string['strftimehm'] = '%I:%M%p';
$string['strftimeshortdate'] = '%d.%m.%Y';
$string['studentid'] = 'విద్యార్థి ID';
$string['studentmarked'] = 'ఈ సెషన్లో మీ హాజరు నమోదు చేయబడింది.';
$string['studentmarking'] = 'స్టూడెంట్ రికార్డింగ్';
$string['studentpassword'] = 'విద్యార్థి పాస్వర్డ్';
$string['studentrecordingexpanded'] = 'విద్యార్థి రికార్డింగ్ విస్తరించింది';
$string['studentrecordingexpanded_desc'] = 'క్రొత్త సెషన్లను సృష్టిస్తున్నప్పుడు డిఫాల్ట్గా "స్టూడెంట్ రికార్డింగ్" సెట్టింగులను విస్తరించండి.';
$string['studentscanmark'] = 'సొంత హాజరును రికార్డ్ చేయడానికి విద్యార్థులను అనుమతించండి';
$string['studentscanmark_desc'] = 'తనిఖీ చేసినట్లయితే, ఉపాధ్యాయులు తమ సొంత హాజరును గుర్తించడానికి విద్యార్థులు అనుమతించగలరు.';
$string['studentscanmark_help'] = 'తనిఖీ చేసిన విద్యార్ధులు సెషన్ కోసం వారి సొంత హాజరు స్థాయిని మార్చగలరు.';
$string['studentscanmarksessiontime'] = 'సెషన్ సమయంలో విద్యార్థుల రికార్డు హాజరు';
$string['studentscanmarksessiontime_desc'] = 'పరీక్షించిన విద్యార్థులు సెషన్లో తమ హాజరును మాత్రమే నమోదు చేసుకోగలరు.';
$string['studentscanmarksessiontimeend'] = 'సెషన్ ముగింపు (నిమిషాలు)';
$string['studentscanmarksessiontimeend_desc'] = 'సెషన్కు ముగింపు సమయం లేకపోతే, విద్యార్థులకు వారి హాజరును రికార్డు చేయడానికి ఎన్ని నిమిషాలు అందుబాటులో ఉండాలి.';
$string['submitattendance'] = 'హాజరును సమర్పించండి';
$string['subnet'] = 'సబ్';
$string['subnetactivitylevel'] = 'సక్రియ స్థాయి వద్ద సబ్నెట్ కాన్ఫిగరేషన్ను అనుమతించండి';
$string['subnetactivitylevel_desc'] = 'ప్రారంభించబడితే, హాజరు సృష్టించేటప్పుడు ఉపాధ్యాయులు డిఫాల్ట్ సబ్నెట్ను కార్యాచరణ స్థాయిలో భర్తీ చేయవచ్చు. లేకపోతే సెషన్ను సృష్టించినప్పుడు సైట్ డిఫాల్ట్ ఉపయోగించబడుతుంది';
$string['subnetwrong'] = 'హాజరు కొన్ని స్థానాల నుండి మాత్రమే నమోదు చేయబడుతుంది మరియు ఈ కంప్యూటర్ అనుమతి జాబితాలో లేదు.';
$string['summary'] = 'సారాంశం';
$string['tablerenamefailed'] = 'పాత attforblock పట్టిక యొక్క హాజరు హాజరు విఫలమైంది';
$string['tactions'] = 'యాక్షన్';
$string['takeattendance'] = 'హాజరు తీసుకోండి';
$string['takensessions'] = 'తీసుకున్న సెషన్లు';
$string['tcreated'] = 'రూపొందించబడింది';
$string['tempaddform'] = 'తాత్కాలిక వినియోగదారుని జోడించండి';
$string['tempexists'] = 'ఈ ఇమెయిల్ చిరునామాతో తాత్కాలిక యూజర్ ఇప్పటికే ఉన్నారు';
$string['temptable'] = 'తాత్కాలిక వినియోగదారుల జాబితా';
$string['tempuser'] = 'తాత్కాలిక వినియోగదారు';
$string['tempusermerge'] = 'తాత్కాలిక వినియోగదారుని విలీనం చేయండి';
$string['tempusers'] = 'తాత్కాలిక వినియోగదారులు';
$string['tempusersedit'] = 'తాత్కాలిక వినియోగదారుని సవరించండి';
$string['tempuserslist'] = 'తాత్కాలిక వినియోగదారులు';
$string['thirdpartyemails'] = 'ఇతర వినియోగదారులకు తెలియజేయండి';
$string['thirdpartyemails_help'] = 'నోటిఫై చేయబడే ఇతర వినియోగదారుల జాబితా. (సామర్థ్యం మోడ్ / హాజరు అవసరం: viewreports)';
$string['thirdpartyemailsubject'] = 'హాజరు హెచ్చరిక';
$string['thirdpartyemailtext'] = '{$a->firstname} {$a->lastname}హాజరు లోపల{$a->coursename} {$a->aname} కంటే తక్కువగా ఉంది{$a->warningpercent} ({$a->percent})';
$string['thirdpartyemailtextfooter'] = 'ఈ కోర్సు యొక్క ఉపాధ్యాయుడు గ్రహీత యొక్క జాబితాకు మీ ఇమెయిల్ను జోడించినందున మీరు దీన్ని స్వీకరిస్తున్నారు';
$string['thiscourse'] = 'ఈ కోర్సు';
$string['time'] = 'సమయం';
$string['timeahead'] = 'ఒక సంవత్సరం కంటే ఎక్కువసేపు బహుళ సెషన్లు సృష్టించబడవు, దయచేసి ప్రారంభ మరియు ముగింపు తేదీలను సర్దుబాటు చేయండి.';
$string['to'] = 'కు:';
$string['triggered'] = 'మొదట తెలియజేయబడింది';
$string['tuseremail'] = 'ఇమెయిల్';
$string['tusername'] = 'పూర్తి పేరు';
$string['ungraded'] = 'అప్గ్రేడెడ్ సెషన్లు';
$string['unknowngroup'] = 'తెలియని గుంపు';
$string['update'] = 'నవీకరణ';
$string['usedefaultsubnet'] = 'డిఫాల్ట్ ఉపయోగించండి';
$string['userexists'] = 'ఈ ఇమెయిల్ చిరునామాతో ఒక నిజమైన యూజర్ ఇప్పటికే ఉన్నారు';
$string['users'] = 'ఎగుమతి చేయడానికి వినియోగదారులు';
$string['usestatusset'] = 'స్థితి సెట్ చేయబడింది';
$string['variable'] = 'వేరియబుల్';
$string['variablesupdated'] = 'వేరియబుల్స్ విజయవంతంగా నవీకరించబడ్డాయి';
$string['versionforprinting'] = 'ముద్రణ కోసం వెర్షన్';
$string['viewmode'] = 'వీక్షణ మోడ్';
$string['warnafter'] = 'హెచ్చరిక ముందు తీసుకున్న సెషన్ల సంఖ్య';
$string['warnafter_help'] = 'కనీసం ఈ సెషన్ల కోసం వినియోగదారు వారి హాజరును తీసుకున్నప్పుడు మాత్రమే హెచ్చరికలు ప్రేరేపించబడతాయి.';
$string['warningdeleted'] = 'హెచ్చరిక తొలగించబడింది';
$string['warningdesc'] = 'ఈ హెచ్చరికలు ఏ కొత్త హాజరు కార్యకలాపాలకు స్వయంచాలకంగా జోడించబడతాయి. ఒకవేళ ఒకటి కంటే ఎక్కువ హెచ్చరికలు ఒకేసారి ప్రేరేపించబడితే, తక్కువ హెచ్చరిక థ్రెషోల్డ్తో హెచ్చరిక పంపబడుతుంది.';
$string['warningdesc_course'] = 'ఇక్కడ సెట్ చేయబడిన హెచ్చరికల పరిమితులు హాజరుకాని నివేదికను ప్రభావితం చేస్తాయి మరియు విద్యార్థులను మరియు మూడవ పక్షాలను తెలియజేయడానికి అనుమతిస్తాయి. ఒకవేళ ఒకటి కంటే ఎక్కువ హెచ్చరికలు ఒకేసారి ప్రేరేపించబడితే, తక్కువ హెచ్చరిక థ్రెషోల్డ్తో హెచ్చరిక పంపబడుతుంది';
$string['warningfailed'] = 'మీరు అదే శాతం మరియు సెషన్ల సంఖ్యను ఉపయోగించే హెచ్చరికను సృష్టించలేరు.';
$string['warningpercent'] = 'శాతం పడిపోయినా హెచ్చరించు';
$string['warningpercent_help'] = 'మొత్తం సంఖ్య ఈ సంఖ్య కంటే తక్కువగా ఉన్నప్పుడు హెచ్చరిక ప్రేరేపించబడుతుంది.';
$string['warnings'] = 'హెచ్చరికలు సెట్ చేయబడ్డాయి';
$string['warningthreshold'] = 'హెచ్చరిక థ్రెషోల్డ్';
$string['warningupdated'] = 'నవీకరించబడిన హెచ్చరికలు';
$string['week'] = 'వారాలు(s)';
$string['weeks'] = 'వారాలు';
$string['youcantdo'] = 'మీరు ఏమీ చేయలేరు';
